/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport;

import java.nio.charset.Charset;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsFrame;
import org.springframework.web.socket.sockjs.TransportType;
import org.springframework.web.socket.sockjs.transport.AbstractHttpSendingTransportHandler;
import org.springframework.web.socket.sockjs.transport.PollingSockJsSession;

public class XhrPollingTransportHandler
extends AbstractHttpSendingTransportHandler {
    @Override
    public TransportType getTransportType() {
        return TransportType.XHR;
    }

    @Override
    protected MediaType getContentType() {
        return new MediaType("application", "javascript", Charset.forName("UTF-8"));
    }

    @Override
    protected SockJsFrame.FrameFormat getFrameFormat(ServerHttpRequest request) {
        return new SockJsFrame.DefaultFrameFormat("%s\n");
    }

    @Override
    public PollingSockJsSession createSession(String sessionId, WebSocketHandler handler) {
        Assert.notNull((Object)this.getSockJsConfig(), (String)"This transport requires SockJsConfiguration");
        return new PollingSockJsSession(sessionId, this.getSockJsConfig(), handler);
    }
}

