/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.adapter;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.adapter.ConfigurableWebSocketSession;

public abstract class AbstractWebSocketSesssionAdapter<T>
implements ConfigurableWebSocketSession {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public abstract void initSession(T var1);

    public final void sendMessage(WebSocketMessage message) throws IOException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Sending " + message + ", " + this));
        }
        Assert.isTrue((boolean)this.isOpen(), (String)"Cannot send message after connection closed.");
        if (message instanceof TextMessage) {
            this.sendTextMessage((TextMessage)message);
        } else if (message instanceof BinaryMessage) {
            this.sendBinaryMessage((BinaryMessage)message);
        } else {
            throw new IllegalStateException("Unexpected WebSocketMessage type: " + message);
        }
    }

    protected abstract void sendTextMessage(TextMessage var1) throws IOException;

    protected abstract void sendBinaryMessage(BinaryMessage var1) throws IOException;

    @Override
    public void close() throws IOException {
        this.close(CloseStatus.NORMAL);
    }

    @Override
    public final void close(CloseStatus status) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Closing " + this));
        }
        this.closeInternal(status);
    }

    protected abstract void closeInternal(CloseStatus var1) throws IOException;

    public String toString() {
        return "WebSocket session id=" + this.getId();
    }
}

