/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.adapter;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.Principal;
import org.eclipse.jetty.websocket.api.Session;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.adapter.AbstractWebSocketSesssionAdapter;

public class JettyWebSocketSessionAdapter
extends AbstractWebSocketSesssionAdapter<Session> {
    private Session session;
    private Principal principal;

    @Override
    public void initSession(Session session) {
        Assert.notNull((Object)session, (String)"session must not be null");
        this.session = session;
    }

    @Override
    public String getId() {
        return ObjectUtils.getIdentityHexString((Object)this.session);
    }

    @Override
    public boolean isSecure() {
        return this.session.isSecure();
    }

    @Override
    public URI getUri() {
        return this.session.getUpgradeRequest().getRequestURI();
    }

    @Override
    public void setUri(URI uri) {
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    @Override
    public String getRemoteHostName() {
        return this.session.getRemoteAddress().getHostName();
    }

    @Override
    public void setRemoteHostName(String address) {
    }

    @Override
    public String getRemoteAddress() {
        InetSocketAddress address = this.session.getRemoteAddress();
        return address.isUnresolved() ? null : address.getAddress().getHostAddress();
    }

    @Override
    public void setRemoteAddress(String address) {
    }

    @Override
    public boolean isOpen() {
        return this.session.isOpen();
    }

    @Override
    protected void sendTextMessage(TextMessage message) throws IOException {
        this.session.getRemote().sendString((String)message.getPayload());
    }

    @Override
    protected void sendBinaryMessage(BinaryMessage message) throws IOException {
        this.session.getRemote().sendBytes((ByteBuffer)message.getPayload());
    }

    @Override
    protected void closeInternal(CloseStatus status) throws IOException {
        this.session.close(status.getCode(), status.getReason());
    }
}

