/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.adapter;

import java.nio.ByteBuffer;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.adapter.StandardWebSocketSessionAdapter;
import org.springframework.web.socket.support.ExceptionWebSocketHandlerDecorator;

public class StandardEndpointAdapter
extends Endpoint {
    private static final Log logger = LogFactory.getLog(StandardEndpointAdapter.class);
    private final WebSocketHandler handler;
    private final StandardWebSocketSessionAdapter wsSession;

    public StandardEndpointAdapter(WebSocketHandler handler, StandardWebSocketSessionAdapter wsSession) {
        Assert.notNull((Object)handler, (String)"handler must not be null");
        Assert.notNull((Object)wsSession, (String)"wsSession must not be null");
        this.handler = handler;
        this.wsSession = wsSession;
    }

    public void onOpen(final Session session, EndpointConfig config) {
        this.wsSession.initSession(session);
        if (this.handler.supportsPartialMessages()) {
            session.addMessageHandler((MessageHandler)new MessageHandler.Partial<String>(){

                public void onMessage(String message, boolean isLast) {
                    StandardEndpointAdapter.this.handleTextMessage(session, message, isLast);
                }
            });
            session.addMessageHandler((MessageHandler)new MessageHandler.Partial<ByteBuffer>(){

                public void onMessage(ByteBuffer message, boolean isLast) {
                    StandardEndpointAdapter.this.handleBinaryMessage(session, message, isLast);
                }
            });
        } else {
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    StandardEndpointAdapter.this.handleTextMessage(session, message, true);
                }
            });
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

                public void onMessage(ByteBuffer message) {
                    StandardEndpointAdapter.this.handleBinaryMessage(session, message, true);
                }
            });
        }
        try {
            this.handler.afterConnectionEstablished(this.wsSession);
        }
        catch (Throwable t) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(this.wsSession, t, logger);
            return;
        }
    }

    private void handleTextMessage(Session session, String payload, boolean isLast) {
        TextMessage textMessage = new TextMessage(payload, isLast);
        try {
            this.handler.handleMessage(this.wsSession, textMessage);
        }
        catch (Throwable t) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(this.wsSession, t, logger);
        }
    }

    private void handleBinaryMessage(Session session, ByteBuffer payload, boolean isLast) {
        BinaryMessage binaryMessage = new BinaryMessage(payload, isLast);
        try {
            this.handler.handleMessage(this.wsSession, binaryMessage);
        }
        catch (Throwable t) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(this.wsSession, t, logger);
        }
    }

    public void onClose(Session session, CloseReason reason) {
        CloseStatus closeStatus = new CloseStatus(reason.getCloseCode().getCode(), reason.getReasonPhrase());
        try {
            this.handler.afterConnectionClosed(this.wsSession, closeStatus);
        }
        catch (Throwable t) {
            logger.error((Object)("Unhandled error for " + this.wsSession), t);
        }
    }

    public void onError(Session session, Throwable exception) {
        try {
            this.handler.handleTransportError(this.wsSession, exception);
        }
        catch (Throwable t) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(this.wsSession, t, logger);
        }
    }
}

