/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client.endpoint;

import javax.websocket.ContainerProvider;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.web.socket.client.ConnectionManagerSupport;
import org.springframework.web.socket.support.BeanCreatingHandlerProvider;

public class AnnotatedEndpointConnectionManager
extends ConnectionManagerSupport
implements BeanFactoryAware {
    private final Object endpoint;
    private final BeanCreatingHandlerProvider<Object> endpointProvider;
    private WebSocketContainer webSocketContainer = ContainerProvider.getWebSocketContainer();
    private Session session;

    public AnnotatedEndpointConnectionManager(Object endpoint, String uriTemplate, Object ... uriVariables) {
        super(uriTemplate, uriVariables);
        this.endpointProvider = null;
        this.endpoint = endpoint;
    }

    public AnnotatedEndpointConnectionManager(Class<?> endpointClass, String uriTemplate, Object ... uriVariables) {
        super(uriTemplate, uriVariables);
        this.endpointProvider = new BeanCreatingHandlerProvider(endpointClass);
        this.endpoint = null;
    }

    public void setWebSocketContainer(WebSocketContainer webSocketContainer) {
        this.webSocketContainer = webSocketContainer;
    }

    public WebSocketContainer getWebSocketContainer() {
        return this.webSocketContainer;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.endpointProvider != null) {
            this.endpointProvider.setBeanFactory(beanFactory);
        }
    }

    @Override
    protected void openConnection() throws Exception {
        Object endpoint = this.endpoint != null ? this.endpoint : this.endpointProvider.getHandler();
        this.session = this.webSocketContainer.connectToServer(endpoint, this.getUri());
    }

    @Override
    protected void closeConnection() throws Exception {
        try {
            if (this.isConnected()) {
                this.session.close();
            }
        }
        finally {
            this.session = null;
        }
    }

    @Override
    protected boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }
}

