/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client.endpoint;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.ContainerProvider;
import javax.websocket.Endpoint;
import javax.websocket.HandshakeResponse;
import javax.websocket.WebSocketContainer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.adapter.StandardEndpointAdapter;
import org.springframework.web.socket.adapter.StandardWebSocketSessionAdapter;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.WebSocketConnectFailureException;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class StandardWebSocketClient
implements WebSocketClient {
    private static final Log logger = LogFactory.getLog(StandardWebSocketClient.class);
    private final WebSocketContainer webSocketContainer;

    public StandardWebSocketClient() {
        this.webSocketContainer = ContainerProvider.getWebSocketContainer();
    }

    public StandardWebSocketClient(WebSocketContainer webSocketContainer) {
        Assert.notNull((Object)webSocketContainer, (String)"webSocketContainer must not be null");
        this.webSocketContainer = webSocketContainer;
    }

    @Override
    public WebSocketSession doHandshake(WebSocketHandler webSocketHandler, String uriTemplate, Object ... uriVariables) throws WebSocketConnectFailureException {
        Assert.notNull((Object)uriTemplate, (String)"uriTemplate must not be null");
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)uriTemplate).buildAndExpand(uriVariables).encode();
        return this.doHandshake(webSocketHandler, null, uriComponents.toUri());
    }

    @Override
    public WebSocketSession doHandshake(WebSocketHandler webSocketHandler, HttpHeaders httpHeaders, URI uri) throws WebSocketConnectFailureException {
        Assert.notNull((Object)webSocketHandler, (String)"webSocketHandler must not be null");
        Assert.notNull((Object)uri, (String)"uri must not be null");
        HttpHeaders httpHeaders2 = httpHeaders = httpHeaders != null ? httpHeaders : new HttpHeaders();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Connecting to " + uri));
        }
        StandardWebSocketSessionAdapter session = new StandardWebSocketSessionAdapter();
        session.setUri(uri);
        session.setRemoteHostName(uri.getHost());
        ClientEndpointConfig.Builder configBuidler = ClientEndpointConfig.Builder.create();
        configBuidler.configurator((ClientEndpointConfig.Configurator)new StandardWebSocketClientConfigurator(httpHeaders));
        List protocols = httpHeaders.getSecWebSocketProtocol();
        if (!protocols.isEmpty()) {
            configBuidler.preferredSubprotocols(protocols);
        }
        try {
            StandardEndpointAdapter endpoint = new StandardEndpointAdapter(webSocketHandler, session);
            this.webSocketContainer.connectToServer((Endpoint)endpoint, configBuidler.build(), uri);
            return session;
        }
        catch (Exception e) {
            throw new WebSocketConnectFailureException("Failed to connect to " + uri, e);
        }
    }

    private static class StandardWebSocketClientConfigurator
    extends ClientEndpointConfig.Configurator {
        private static final Set<String> EXCLUDED_HEADERS = new HashSet<String>(Arrays.asList("Sec-WebSocket-Accept", "Sec-WebSocket-Extensions", "Sec-WebSocket-Key", "Sec-WebSocket-Protocol", "Sec-WebSocket-Version"));
        private final HttpHeaders httpHeaders;

        public StandardWebSocketClientConfigurator(HttpHeaders httpHeaders) {
            this.httpHeaders = httpHeaders;
        }

        public void beforeRequest(Map<String, List<String>> headers) {
            for (String headerName : this.httpHeaders.keySet()) {
                if (EXCLUDED_HEADERS.contains(headerName)) continue;
                List value = this.httpHeaders.get((Object)headerName);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Adding header [" + headerName + "=" + value + "]"));
                }
                headers.put(headerName, value);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Handshake request headers: " + headers));
            }
        }

        public void afterResponse(HandshakeResponse handshakeResponse) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Handshake response headers: " + handshakeResponse.getHeaders()));
            }
        }
    }
}

