/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client.jetty;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.adapter.JettyWebSocketListenerAdapter;
import org.springframework.web.socket.adapter.JettyWebSocketSessionAdapter;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.WebSocketConnectFailureException;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class JettyWebSocketClient
implements WebSocketClient,
SmartLifecycle {
    private static final Log logger = LogFactory.getLog(JettyWebSocketClient.class);
    private final org.eclipse.jetty.websocket.client.WebSocketClient client;
    private boolean autoStartup = true;
    private int phase = Integer.MAX_VALUE;
    private final Object lifecycleMonitor = new Object();

    public JettyWebSocketClient() {
        this.client = new org.eclipse.jetty.websocket.client.WebSocketClient();
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.client.isStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Starting Jetty WebSocketClient");
                    }
                    this.client.start();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to start Jetty client", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Stopping Jetty WebSocketClient");
                    }
                    this.client.stop();
                }
                catch (Exception e) {
                    logger.error((Object)"Error stopping Jetty WebSocketClient", (Throwable)e);
                }
            }
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    @Override
    public WebSocketSession doHandshake(WebSocketHandler webSocketHandler, String uriTemplate, Object ... uriVariables) throws WebSocketConnectFailureException {
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)uriTemplate).buildAndExpand(uriVariables).encode();
        return this.doHandshake(webSocketHandler, null, uriComponents.toUri());
    }

    @Override
    public WebSocketSession doHandshake(WebSocketHandler webSocketHandler, HttpHeaders headers, URI uri) throws WebSocketConnectFailureException {
        Assert.notNull((Object)webSocketHandler, (String)"webSocketHandler must not be null");
        Assert.notNull((Object)uri, (String)"uri must not be null");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Connecting to " + uri));
        }
        JettyWebSocketSessionAdapter session = new JettyWebSocketSessionAdapter();
        session.setUri(uri);
        session.setRemoteHostName(uri.getHost());
        JettyWebSocketListenerAdapter listener = new JettyWebSocketListenerAdapter(webSocketHandler, session);
        try {
            this.client.connect((Object)listener, uri).get();
            return session;
        }
        catch (Exception e) {
            throw new WebSocketConnectFailureException("Failed to connect to " + uri, e);
        }
    }
}

