/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;

public class DefaultHandshakeHandler
implements HandshakeHandler {
    private static final String GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    protected Log logger = LogFactory.getLog(this.getClass());
    private List<String> supportedProtocols = new ArrayList<String>();
    private final RequestUpgradeStrategy requestUpgradeStrategy;

    public DefaultHandshakeHandler() {
        this.requestUpgradeStrategy = new RequestUpgradeStrategyFactory().create();
    }

    public DefaultHandshakeHandler(RequestUpgradeStrategy upgradeStrategy) {
        this.requestUpgradeStrategy = upgradeStrategy;
    }

    public void setSupportedProtocols(String ... protocols) {
        this.supportedProtocols = Arrays.asList(protocols);
    }

    public String[] getSupportedProtocols() {
        return this.supportedProtocols.toArray(new String[this.supportedProtocols.size()]);
    }

    @Override
    public final boolean doHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler webSocketHandler) throws IOException, HandshakeFailureException {
        this.logger.debug((Object)("Starting handshake for " + request.getURI()));
        if (!HttpMethod.GET.equals((Object)request.getMethod())) {
            response.setStatusCode(HttpStatus.METHOD_NOT_ALLOWED);
            response.getHeaders().setAllow(Collections.singleton(HttpMethod.GET));
            this.logger.debug((Object)("Only HTTP GET is allowed, current method is " + request.getMethod()));
            return false;
        }
        if (!"WebSocket".equalsIgnoreCase(request.getHeaders().getUpgrade())) {
            this.handleInvalidUpgradeHeader(request, response);
            return false;
        }
        if (!request.getHeaders().getConnection().contains("Upgrade") && !request.getHeaders().getConnection().contains("upgrade")) {
            this.handleInvalidConnectHeader(request, response);
            return false;
        }
        if (!this.isWebSocketVersionSupported(request)) {
            this.handleWebSocketVersionNotSupported(request, response);
            return false;
        }
        if (!this.isValidOrigin(request)) {
            response.setStatusCode(HttpStatus.FORBIDDEN);
            return false;
        }
        String wsKey = request.getHeaders().getSecWebSocketKey();
        if (wsKey == null) {
            this.logger.debug((Object)"Missing \"Sec-WebSocket-Key\" header");
            response.setStatusCode(HttpStatus.BAD_REQUEST);
            return false;
        }
        String selectedProtocol = this.selectProtocol(request.getHeaders().getSecWebSocketProtocol());
        this.logger.debug((Object)"Upgrading HTTP request");
        response.setStatusCode(HttpStatus.SWITCHING_PROTOCOLS);
        response.getHeaders().setUpgrade("WebSocket");
        response.getHeaders().setConnection("Upgrade");
        response.getHeaders().setSecWebSocketProtocol(selectedProtocol);
        response.getHeaders().setSecWebSocketAccept(this.getWebSocketKeyHash(wsKey));
        response.flush();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Upgrading with " + webSocketHandler));
        }
        this.requestUpgradeStrategy.upgrade(request, response, selectedProtocol, webSocketHandler);
        return true;
    }

    protected void handleInvalidUpgradeHeader(ServerHttpRequest request, ServerHttpResponse response) throws IOException {
        this.logger.debug((Object)("Invalid Upgrade header " + request.getHeaders().getUpgrade()));
        response.setStatusCode(HttpStatus.BAD_REQUEST);
        response.getBody().write("Can \"Upgrade\" only to \"WebSocket\".".getBytes("UTF-8"));
    }

    protected void handleInvalidConnectHeader(ServerHttpRequest request, ServerHttpResponse response) throws IOException {
        this.logger.debug((Object)("Invalid Connection header " + request.getHeaders().getConnection()));
        response.setStatusCode(HttpStatus.BAD_REQUEST);
        response.getBody().write("\"Connection\" must be \"upgrade\".".getBytes("UTF-8"));
    }

    protected boolean isWebSocketVersionSupported(ServerHttpRequest request) {
        String requestedVersion = request.getHeaders().getSecWebSocketVersion();
        for (String supportedVersion : this.getSupportedVerions()) {
            if (!supportedVersion.equals(requestedVersion)) continue;
            return true;
        }
        return false;
    }

    protected String[] getSupportedVerions() {
        return this.requestUpgradeStrategy.getSupportedVersions();
    }

    protected void handleWebSocketVersionNotSupported(ServerHttpRequest request, ServerHttpResponse response) {
        this.logger.debug((Object)("WebSocket version not supported " + request.getHeaders().get((Object)"Sec-WebSocket-Version")));
        response.setStatusCode(HttpStatus.UPGRADE_REQUIRED);
        response.getHeaders().setSecWebSocketVersion(StringUtils.arrayToCommaDelimitedString((Object[])this.getSupportedVerions()));
    }

    protected boolean isValidOrigin(ServerHttpRequest request) {
        String origin = request.getHeaders().getOrigin();
        if (origin != null) {
            // empty if block
        }
        return true;
    }

    protected String selectProtocol(List<String> requestedProtocols) {
        if (CollectionUtils.isEmpty(requestedProtocols)) {
            for (String protocol : requestedProtocols) {
                if (!this.supportedProtocols.contains(protocol)) continue;
                return protocol;
            }
        }
        return null;
    }

    private String getWebSocketKeyHash(String key) throws HandshakeFailureException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            byte[] bytes = digest.digest((key + GUID).getBytes(Charset.forName("ISO-8859-1")));
            return DatatypeConverter.printBase64Binary((byte[])bytes);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new HandshakeFailureException("Failed to generate value for Sec-WebSocket-Key header", ex);
        }
    }

    private static class RequestUpgradeStrategyFactory {
        private static final boolean tomcatWebSocketPresent = ClassUtils.isPresent((String)"org.apache.tomcat.websocket.server.WsHttpUpgradeHandler", (ClassLoader)DefaultHandshakeHandler.class.getClassLoader());
        private static final boolean glassFishWebSocketPresent = ClassUtils.isPresent((String)"org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler", (ClassLoader)DefaultHandshakeHandler.class.getClassLoader());
        private static final boolean jettyWebSocketPresent = ClassUtils.isPresent((String)"org.eclipse.jetty.websocket.server.UpgradeContext", (ClassLoader)DefaultHandshakeHandler.class.getClassLoader());

        private RequestUpgradeStrategyFactory() {
        }

        private RequestUpgradeStrategy create() {
            String className;
            if (tomcatWebSocketPresent) {
                className = "org.springframework.web.socket.server.support.TomcatRequestUpgradeStrategy";
            } else if (glassFishWebSocketPresent) {
                className = "org.springframework.web.socket.server.support.GlassFishRequestUpgradeStrategy";
            } else if (jettyWebSocketPresent) {
                className = "org.springframework.web.socket.server.support.JettyRequestUpgradeStrategy";
            } else {
                throw new IllegalStateException("No suitable " + RequestUpgradeStrategy.class.getSimpleName());
            }
            try {
                Class clazz = ClassUtils.forName((String)className, (ClassLoader)DefaultHandshakeHandler.class.getClassLoader());
                return (RequestUpgradeStrategy)BeanUtils.instantiateClass(clazz.getConstructor(new Class[0]), (Object[])new Object[0]);
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to instantiate " + className, t);
            }
        }
    }
}

