/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.support;

import java.io.IOException;
import javax.websocket.Endpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.adapter.StandardEndpointAdapter;
import org.springframework.web.socket.adapter.StandardWebSocketSessionAdapter;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.support.ServerWebSocketSessionInitializer;

public abstract class AbstractStandardUpgradeStrategy
implements RequestUpgradeStrategy {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ServerWebSocketSessionInitializer wsSessionInitializer = new ServerWebSocketSessionInitializer();

    @Override
    public void upgrade(ServerHttpRequest request, ServerHttpResponse response, String protocol, WebSocketHandler handler) throws IOException, HandshakeFailureException {
        StandardWebSocketSessionAdapter session = new StandardWebSocketSessionAdapter();
        this.wsSessionInitializer.initialize(request, response, session);
        StandardEndpointAdapter endpoint = new StandardEndpointAdapter(handler, session);
        this.upgradeInternal(request, response, protocol, endpoint);
    }

    protected abstract void upgradeInternal(ServerHttpRequest var1, ServerHttpResponse var2, String var3, Endpoint var4) throws IOException, HandshakeFailureException;
}

