/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.support;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.Arrays;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.EndpointWrapper;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.server.TyrusEndpoint;
import org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.websockets.Connection;
import org.glassfish.tyrus.websockets.Version;
import org.glassfish.tyrus.websockets.WebSocketApplication;
import org.glassfish.tyrus.websockets.WebSocketEngine;
import org.glassfish.tyrus.websockets.WebSocketRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.endpoint.ServerEndpointRegistration;
import org.springframework.web.socket.server.support.AbstractStandardUpgradeStrategy;

public class GlassFishRequestUpgradeStrategy
extends AbstractStandardUpgradeStrategy {
    private static final Random random = new Random();

    @Override
    public String[] getSupportedVersions() {
        return StringUtils.commaDelimitedListToStringArray((String)Version.getSupportedWireProtocolVersions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upgradeInternal(ServerHttpRequest request, ServerHttpResponse response, String selectedProtocol, Endpoint endpoint) throws IOException, HandshakeFailureException {
        Assert.isTrue((boolean)(request instanceof ServletServerHttpRequest));
        HttpServletRequest servletRequest = ((ServletServerHttpRequest)request).getServletRequest();
        Assert.isTrue((boolean)(response instanceof ServletServerHttpResponse));
        Object servletResponse = ((ServletServerHttpResponse)response).getServletResponse();
        servletResponse = new AlreadyUpgradedResponseWrapper((HttpServletResponse)servletResponse);
        WebSocketApplication wsApp = this.createTyrusEndpoint(servletRequest, endpoint, selectedProtocol);
        WebSocketEngine engine = WebSocketEngine.getEngine();
        try {
            engine.register(wsApp);
        }
        catch (DeploymentException ex) {
            throw new HandshakeFailureException("Failed to deploy endpoint in GlassFish", ex);
        }
        try {
            if (!this.performUpgrade(servletRequest, (HttpServletResponse)servletResponse, request.getHeaders(), wsApp)) {
                throw new HandshakeFailureException("Failed to upgrade HttpServletRequest");
            }
        }
        finally {
            engine.unregister(wsApp);
        }
    }

    private boolean performUpgrade(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers, WebSocketApplication wsApp) throws IOException {
        TyrusHttpUpgradeHandler upgradeHandler;
        try {
            upgradeHandler = (TyrusHttpUpgradeHandler)request.upgrade(TyrusHttpUpgradeHandler.class);
        }
        catch (ServletException e) {
            throw new HandshakeFailureException("Unable to create UpgardeHandler", e);
        }
        Connection connection = this.createConnection(upgradeHandler, response);
        RequestContext wsRequest = RequestContext.Builder.create().requestURI(URI.create(wsApp.getPath())).requestPath(wsApp.getPath()).connection(connection).secure(request.isSecure()).build();
        for (String header : headers.keySet()) {
            wsRequest.getHeaders().put(header, headers.get((Object)header));
        }
        return WebSocketEngine.getEngine().upgrade(connection, (WebSocketRequest)wsRequest, new WebSocketEngine.WebSocketHolderListener(){

            public void onWebSocketHolder(WebSocketEngine.WebSocketHolder webSocketHolder) {
                upgradeHandler.setWebSocketHolder(webSocketHolder);
            }
        });
    }

    private WebSocketApplication createTyrusEndpoint(HttpServletRequest request, Endpoint endpoint, String selectedProtocol) {
        String requestUri = request.getRequestURI();
        String randomValue = String.valueOf(random.nextLong());
        String endpointPath = requestUri.endsWith("/") ? requestUri + randomValue : requestUri + "/" + randomValue;
        ServerEndpointRegistration endpointConfig = new ServerEndpointRegistration(endpointPath, endpoint);
        endpointConfig.setSubprotocols(Arrays.asList(selectedProtocol));
        return new TyrusEndpoint((SPIEndpoint)new EndpointWrapper(endpoint, (EndpointConfig)endpointConfig, ComponentProviderService.create(), null, "/", new ErrorCollector(), endpointConfig.getConfigurator()));
    }

    private Connection createConnection(TyrusHttpUpgradeHandler handler, HttpServletResponse response) {
        try {
            String name = "org.glassfish.tyrus.servlet.ConnectionImpl";
            Class clazz = ClassUtils.forName((String)name, (ClassLoader)GlassFishRequestUpgradeStrategy.class.getClassLoader());
            Constructor constructor = clazz.getDeclaredConstructor(TyrusHttpUpgradeHandler.class, HttpServletResponse.class);
            ReflectionUtils.makeAccessible(constructor);
            return (Connection)constructor.newInstance(handler, response);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to instantiate GlassFish connection", ex);
        }
    }

    private static class AlreadyUpgradedResponseWrapper
    extends HttpServletResponseWrapper {
        public AlreadyUpgradedResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void setStatus(int sc) {
            Assert.isTrue((sc == HttpStatus.SWITCHING_PROTOCOLS.value() ? 1 : 0) != 0, (String)("Unexpected status code " + sc));
        }

        public void addHeader(String name, String value) {
        }
    }
}

