/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.support;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.adapter.JettyWebSocketListenerAdapter;
import org.springframework.web.socket.adapter.JettyWebSocketSessionAdapter;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.support.ServerWebSocketSessionInitializer;

public class JettyRequestUpgradeStrategy
implements RequestUpgradeStrategy {
    private static final String WEBSOCKET_LISTENER_ATTR_NAME = JettyRequestUpgradeStrategy.class.getName() + ".HANDLER_PROVIDER";
    private WebSocketServerFactory factory;
    private final ServerWebSocketSessionInitializer wsSessionInitializer = new ServerWebSocketSessionInitializer();

    public JettyRequestUpgradeStrategy() {
        this.factory = new WebSocketServerFactory();
        this.factory.setCreator(new WebSocketCreator(){

            public Object createWebSocket(UpgradeRequest request, UpgradeResponse response) {
                Assert.isInstanceOf(ServletUpgradeRequest.class, (Object)request);
                return ((ServletUpgradeRequest)request).getServletAttributes().get(WEBSOCKET_LISTENER_ATTR_NAME);
            }
        });
        try {
            this.factory.init();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to initialize Jetty WebSocketServerFactory", ex);
        }
    }

    @Override
    public String[] getSupportedVersions() {
        return new String[]{String.valueOf(13)};
    }

    @Override
    public void upgrade(ServerHttpRequest request, ServerHttpResponse response, String selectedProtocol, WebSocketHandler webSocketHandler) throws IOException {
        Assert.isInstanceOf(ServletServerHttpRequest.class, (Object)request);
        HttpServletRequest servletRequest = ((ServletServerHttpRequest)request).getServletRequest();
        Assert.isInstanceOf(ServletServerHttpResponse.class, (Object)response);
        HttpServletResponse servletResponse = ((ServletServerHttpResponse)response).getServletResponse();
        if (!this.factory.isUpgradeRequest(servletRequest, servletResponse)) {
            throw new HandshakeFailureException("Not a WebSocket request");
        }
        JettyWebSocketSessionAdapter session = new JettyWebSocketSessionAdapter();
        this.wsSessionInitializer.initialize(request, response, session);
        JettyWebSocketListenerAdapter listener = new JettyWebSocketListenerAdapter(webSocketHandler, session);
        servletRequest.setAttribute(WEBSOCKET_LISTENER_ATTR_NAME, (Object)listener);
        if (!this.factory.acceptWebSocket(servletRequest, servletResponse)) {
            throw new HandshakeFailureException("WebSocket request not accepted by Jetty");
        }
    }
}

