/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.support;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import org.apache.tomcat.websocket.server.WsHandshakeRequest;
import org.apache.tomcat.websocket.server.WsHttpUpgradeHandler;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.endpoint.ServerEndpointRegistration;
import org.springframework.web.socket.server.support.AbstractStandardUpgradeStrategy;

public class TomcatRequestUpgradeStrategy
extends AbstractStandardUpgradeStrategy {
    @Override
    public String[] getSupportedVersions() {
        return new String[]{"13"};
    }

    @Override
    public void upgradeInternal(ServerHttpRequest request, ServerHttpResponse response, String selectedProtocol, Endpoint endpoint) throws IOException {
        WsHttpUpgradeHandler upgradeHandler;
        Assert.isTrue((boolean)(request instanceof ServletServerHttpRequest));
        HttpServletRequest servletRequest = ((ServletServerHttpRequest)request).getServletRequest();
        try {
            upgradeHandler = (WsHttpUpgradeHandler)servletRequest.upgrade(WsHttpUpgradeHandler.class);
        }
        catch (ServletException e) {
            throw new HandshakeFailureException("Unable to create UpgardeHandler", e);
        }
        WsHandshakeRequest webSocketRequest = new WsHandshakeRequest(servletRequest);
        try {
            Method method = ReflectionUtils.findMethod(WsHandshakeRequest.class, (String)"finished");
            ReflectionUtils.makeAccessible((Method)method);
            method.invoke((Object)webSocketRequest, new Object[0]);
        }
        catch (Exception ex) {
            throw new HandshakeFailureException("Failed to upgrade HttpServletRequest", ex);
        }
        WsServerContainer serverContainer = WsServerContainer.getServerContainer();
        ServerEndpointRegistration endpointConfig = new ServerEndpointRegistration("/shouldntmatter", endpoint);
        upgradeHandler.preInit(endpoint, (EndpointConfig)endpointConfig, serverContainer, webSocketRequest, selectedProtocol, Collections.emptyMap(), servletRequest.isSecure());
    }
}

