/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.AbstractSockJsSession;
import org.springframework.web.socket.sockjs.TransportErrorException;
import org.springframework.web.socket.sockjs.TransportHandler;
import org.springframework.web.socket.support.ExceptionWebSocketHandlerDecorator;

public abstract class AbstractHttpReceivingTransportHandler
implements TransportHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public final void handleRequest(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler webSocketHandler, AbstractSockJsSession session) throws TransportErrorException {
        if (session == null) {
            response.setStatusCode(HttpStatus.NOT_FOUND);
            this.logger.warn((Object)"Session not found");
            return;
        }
        this.handleRequestInternal(request, response, session);
    }

    protected void handleRequestInternal(ServerHttpRequest request, ServerHttpResponse response, AbstractSockJsSession session) throws TransportErrorException {
        String[] messages = null;
        try {
            messages = this.readMessages(request);
        }
        catch (JsonMappingException ex) {
            this.logger.error((Object)("Failed to read message: " + ex.getMessage()));
            this.sendInternalServerError(response, "Payload expected.", session.getId());
            return;
        }
        catch (IOException ex) {
            this.logger.error((Object)("Failed to read message: " + ex.getMessage()));
            this.sendInternalServerError(response, "Broken JSON encoding.", session.getId());
            return;
        }
        catch (Throwable t) {
            this.logger.error((Object)("Failed to read message: " + t.getMessage()));
            this.sendInternalServerError(response, "Failed to process messages", session.getId());
            return;
        }
        if (messages == null) {
            this.sendInternalServerError(response, "Payload expected.", session.getId());
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Received message(s): " + Arrays.asList(messages)));
        }
        response.setStatusCode(this.getResponseStatus());
        response.getHeaders().setContentType(new MediaType("text", "plain", Charset.forName("UTF-8")));
        try {
            session.delegateMessages(messages);
        }
        catch (Throwable t) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(session, t, this.logger);
            throw new TransportErrorException("Unhandled WebSocketHandler error in " + this, t, session.getId());
        }
    }

    protected void sendInternalServerError(ServerHttpResponse response, String error, String sessionId) throws TransportErrorException {
        try {
            response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            response.getBody().write(error.getBytes("UTF-8"));
        }
        catch (Throwable t) {
            throw new TransportErrorException("Failed to send error message to client", t, sessionId);
        }
    }

    protected abstract String[] readMessages(ServerHttpRequest var1) throws IOException;

    protected abstract HttpStatus getResponseStatus();
}

