/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.AbstractSockJsSession;
import org.springframework.web.socket.sockjs.ConfigurableTransportHandler;
import org.springframework.web.socket.sockjs.SockJsConfiguration;
import org.springframework.web.socket.sockjs.SockJsFrame;
import org.springframework.web.socket.sockjs.SockJsSessionFactory;
import org.springframework.web.socket.sockjs.TransportErrorException;
import org.springframework.web.socket.sockjs.transport.AbstractHttpSockJsSession;

public abstract class AbstractHttpSendingTransportHandler
implements ConfigurableTransportHandler,
SockJsSessionFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SockJsConfiguration sockJsConfig;

    @Override
    public void setSockJsConfiguration(SockJsConfiguration sockJsConfig) {
        this.sockJsConfig = sockJsConfig;
    }

    public SockJsConfiguration getSockJsConfig() {
        return this.sockJsConfig;
    }

    @Override
    public final void handleRequest(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler webSocketHandler, AbstractSockJsSession session) throws TransportErrorException {
        response.getHeaders().setContentType(this.getContentType());
        AbstractHttpSockJsSession httpServerSession = (AbstractHttpSockJsSession)session;
        this.handleRequestInternal(request, response, httpServerSession);
    }

    protected void handleRequestInternal(ServerHttpRequest request, ServerHttpResponse response, AbstractHttpSockJsSession httpServerSession) throws TransportErrorException {
        if (httpServerSession.isNew()) {
            this.logger.debug((Object)("Opening " + (Object)((Object)this.getTransportType()) + " connection"));
            httpServerSession.setInitialRequest(request, response, this.getFrameFormat(request));
        } else if (!httpServerSession.isActive()) {
            this.logger.debug((Object)("starting " + (Object)((Object)this.getTransportType()) + " async request"));
            httpServerSession.setLongPollingRequest(request, response, this.getFrameFormat(request));
        } else {
            try {
                this.logger.debug((Object)("another " + (Object)((Object)this.getTransportType()) + " connection still open: " + httpServerSession));
                SockJsFrame closeFrame = SockJsFrame.closeFrameAnotherConnectionOpen();
                response.getBody().write(this.getFrameFormat(request).format(closeFrame).getContentBytes());
            }
            catch (IOException e) {
                throw new TransportErrorException("Failed to send SockJS close frame", e, httpServerSession.getId());
            }
        }
    }

    protected abstract MediaType getContentType();

    protected abstract SockJsFrame.FrameFormat getFrameFormat(ServerHttpRequest var1);
}

