/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.springframework.http.server.AsyncServerHttpRequest;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.AbstractSockJsSession;
import org.springframework.web.socket.sockjs.SockJsConfiguration;
import org.springframework.web.socket.sockjs.SockJsFrame;
import org.springframework.web.socket.sockjs.TransportErrorException;
import org.springframework.web.socket.support.ExceptionWebSocketHandlerDecorator;

public abstract class AbstractHttpSockJsSession
extends AbstractSockJsSession {
    private SockJsFrame.FrameFormat frameFormat;
    private final BlockingQueue<String> messageCache = new ArrayBlockingQueue<String>(100);
    private AsyncServerHttpRequest asyncRequest;
    private ServerHttpResponse response;

    public AbstractHttpSockJsSession(String sessionId, SockJsConfiguration config, WebSocketHandler handler) {
        super(sessionId, config, handler);
    }

    public synchronized void setInitialRequest(ServerHttpRequest request, ServerHttpResponse response, SockJsFrame.FrameFormat frameFormat) throws TransportErrorException {
        try {
            this.udpateRequest(request, response, frameFormat);
            this.writePrelude();
            this.writeFrame(SockJsFrame.openFrame());
        }
        catch (Throwable t) {
            this.tryCloseWithSockJsTransportError(t, null);
            throw new TransportErrorException("Failed open SockJS session", t, this.getId());
        }
        try {
            this.delegateConnectionEstablished();
        }
        catch (Throwable t) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(this, t, this.logger);
        }
    }

    protected void writePrelude() throws IOException {
    }

    public synchronized void setLongPollingRequest(ServerHttpRequest request, ServerHttpResponse response, SockJsFrame.FrameFormat frameFormat) throws TransportErrorException {
        try {
            this.udpateRequest(request, response, frameFormat);
            if (this.isClosed()) {
                this.logger.debug((Object)"connection already closed");
                try {
                    this.writeFrame(SockJsFrame.closeFrameGoAway());
                }
                catch (IOException ex) {
                    throw new TransportErrorException("Failed to send SockJS close frame", ex, this.getId());
                }
                return;
            }
            this.asyncRequest.setTimeout(-1L);
            this.asyncRequest.startAsync();
            this.scheduleHeartbeat();
            this.tryFlushCache();
        }
        catch (Throwable t) {
            this.tryCloseWithSockJsTransportError(t, null);
            throw new TransportErrorException("Failed to start long running request and flush messages", t, this.getId());
        }
    }

    private void udpateRequest(ServerHttpRequest request, ServerHttpResponse response, SockJsFrame.FrameFormat frameFormat) {
        Assert.notNull((Object)request, (String)"expected request");
        Assert.notNull((Object)response, (String)"expected response");
        Assert.notNull((Object)frameFormat, (String)"expected frameFormat");
        Assert.isInstanceOf(AsyncServerHttpRequest.class, (Object)request, (String)"Expected AsyncServerHttpRequest");
        this.asyncRequest = (AsyncServerHttpRequest)request;
        this.response = response;
        this.frameFormat = frameFormat;
    }

    @Override
    public synchronized boolean isActive() {
        return this.asyncRequest != null && !this.asyncRequest.isAsyncCompleted();
    }

    protected BlockingQueue<String> getMessageCache() {
        return this.messageCache;
    }

    protected ServerHttpRequest getRequest() {
        return this.asyncRequest;
    }

    protected ServerHttpResponse getResponse() {
        return this.response;
    }

    @Override
    protected final synchronized void sendMessageInternal(String message) throws IOException {
        this.messageCache.add(message);
        this.tryFlushCache();
    }

    private void tryFlushCache() throws IOException {
        if (this.isActive() && !this.getMessageCache().isEmpty()) {
            this.logger.trace((Object)"Flushing messages");
            this.flushCache();
        }
    }

    protected abstract void flushCache() throws IOException;

    @Override
    protected void disconnect(CloseStatus status) {
        this.resetRequest();
    }

    protected synchronized void resetRequest() {
        this.updateLastActiveTime();
        if (this.isActive() && this.asyncRequest.isAsyncStarted()) {
            try {
                this.logger.debug((Object)"Completing async request");
                this.asyncRequest.completeAsync();
            }
            catch (Throwable ex) {
                this.logger.error((Object)("Failed to complete async request: " + ex.getMessage()));
            }
        }
        this.asyncRequest = null;
        this.response = null;
    }

    @Override
    protected synchronized void writeFrameInternal(SockJsFrame frame) throws IOException {
        if (this.isActive()) {
            frame = this.frameFormat.format(frame);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Writing " + frame));
            }
            this.response.getBody().write(frame.getContentBytes());
        }
    }
}

