/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport;

import java.nio.charset.Charset;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsFrame;
import org.springframework.web.socket.sockjs.TransportErrorException;
import org.springframework.web.socket.sockjs.TransportType;
import org.springframework.web.socket.sockjs.transport.AbstractHttpSendingTransportHandler;
import org.springframework.web.socket.sockjs.transport.AbstractHttpSockJsSession;
import org.springframework.web.socket.sockjs.transport.PollingSockJsSession;
import org.springframework.web.util.JavaScriptUtils;

public class JsonpPollingTransportHandler
extends AbstractHttpSendingTransportHandler {
    @Override
    public TransportType getTransportType() {
        return TransportType.JSONP;
    }

    @Override
    protected MediaType getContentType() {
        return new MediaType("application", "javascript", Charset.forName("UTF-8"));
    }

    @Override
    public PollingSockJsSession createSession(String sessionId, WebSocketHandler handler) {
        Assert.state((this.getSockJsConfig() != null ? 1 : 0) != 0, (String)"This transport requires SockJsConfiguration");
        return new PollingSockJsSession(sessionId, this.getSockJsConfig(), handler);
    }

    @Override
    public void handleRequestInternal(ServerHttpRequest request, ServerHttpResponse response, AbstractHttpSockJsSession session) throws TransportErrorException {
        try {
            String callback = (String)request.getQueryParams().getFirst((Object)"c");
            if (!StringUtils.hasText((String)callback)) {
                response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
                response.getBody().write("\"callback\" parameter required".getBytes("UTF-8"));
                return;
            }
        }
        catch (Throwable t) {
            throw new TransportErrorException("Failed to send error to client", t, session.getId());
        }
        super.handleRequestInternal(request, response, session);
    }

    @Override
    protected SockJsFrame.FrameFormat getFrameFormat(ServerHttpRequest request) {
        String callback = (String)request.getQueryParams().getFirst((Object)"c");
        return new SockJsFrame.DefaultFrameFormat(callback + "(\"%s\");\r\n"){

            @Override
            protected String preProcessContent(String content) {
                return JavaScriptUtils.javaScriptEscape((String)content);
            }
        };
    }
}

