/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport;

import java.io.IOException;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsConfiguration;
import org.springframework.web.socket.sockjs.SockJsFrame;
import org.springframework.web.socket.sockjs.TransportErrorException;
import org.springframework.web.socket.sockjs.transport.AbstractHttpSockJsSession;

public class StreamingSockJsSession
extends AbstractHttpSockJsSession {
    private int byteCount;

    public StreamingSockJsSession(String sessionId, SockJsConfiguration config, WebSocketHandler handler) {
        super(sessionId, config, handler);
    }

    @Override
    public synchronized void setInitialRequest(ServerHttpRequest request, ServerHttpResponse response, SockJsFrame.FrameFormat frameFormat) throws TransportErrorException {
        super.setInitialRequest(request, response, frameFormat);
        if (!this.isClosed()) {
            super.setLongPollingRequest(request, response, frameFormat);
        }
    }

    @Override
    protected void flushCache() throws IOException {
        this.cancelHeartbeat();
        do {
            String message = (String)this.getMessageCache().poll();
            SockJsFrame frame = SockJsFrame.messageFrame(message);
            this.writeFrame(frame);
            this.byteCount += frame.getContentBytes().length + 1;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(this.byteCount + " bytes written so far, " + this.getMessageCache().size() + " more messages not flushed"));
            }
            if (this.byteCount < this.getSockJsConfig().getStreamBytesLimit()) continue;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Streamed bytes limit reached. Recycling current request");
            }
            this.resetRequest();
            break;
        } while (!this.getMessageCache().isEmpty());
        this.scheduleHeartbeat();
    }

    @Override
    protected synchronized void resetRequest() {
        super.resetRequest();
        this.byteCount = 0;
    }

    @Override
    protected synchronized void writeFrameInternal(SockJsFrame frame) throws IOException {
        if (this.isActive()) {
            super.writeFrameInternal(frame);
            this.getResponse().flush();
        }
    }
}

