/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.sockjs.AbstractSockJsSession;
import org.springframework.web.socket.sockjs.SockJsConfiguration;
import org.springframework.web.socket.sockjs.SockJsFrame;

public class WebSocketServerSockJsSession
extends AbstractSockJsSession {
    private WebSocketSession webSocketSession;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public WebSocketServerSockJsSession(String sessionId, SockJsConfiguration config, WebSocketHandler handler) {
        super(sessionId, config, handler);
    }

    public void initWebSocketSession(WebSocketSession session) throws Exception {
        this.webSocketSession = session;
        try {
            TextMessage message = new TextMessage(SockJsFrame.openFrame().getContent());
            this.webSocketSession.sendMessage(message);
        }
        catch (IOException ex) {
            this.tryCloseWithSockJsTransportError(ex, null);
            return;
        }
        this.scheduleHeartbeat();
        this.delegateConnectionEstablished();
    }

    @Override
    public boolean isActive() {
        return this.webSocketSession != null && this.webSocketSession.isOpen();
    }

    public void handleMessage(TextMessage message, WebSocketSession wsSession) throws Exception {
        String[] messages;
        String payload = (String)message.getPayload();
        if (StringUtils.isEmpty((Object)payload)) {
            this.logger.trace((Object)"Ignoring empty message");
            return;
        }
        try {
            messages = (String[])this.objectMapper.readValue(payload, String[].class);
        }
        catch (IOException ex) {
            this.logger.error((Object)"Broken data received. Terminating WebSocket connection abruptly", (Throwable)ex);
            this.tryCloseWithSockJsTransportError(ex, CloseStatus.BAD_DATA);
            return;
        }
        this.delegateMessages(messages);
    }

    @Override
    public void sendMessageInternal(String message) throws IOException {
        this.cancelHeartbeat();
        this.writeFrame(SockJsFrame.messageFrame(message));
        this.scheduleHeartbeat();
    }

    @Override
    protected void writeFrameInternal(SockJsFrame frame) throws IOException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Write " + frame));
        }
        TextMessage message = new TextMessage(frame.getContent());
        this.webSocketSession.sendMessage(message);
    }

    @Override
    protected void disconnect(CloseStatus status) throws IOException {
        this.webSocketSession.close(status);
    }
}

