/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport;

import java.io.IOException;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.sockjs.AbstractSockJsSession;
import org.springframework.web.socket.sockjs.ConfigurableTransportHandler;
import org.springframework.web.socket.sockjs.SockJsConfiguration;
import org.springframework.web.socket.sockjs.SockJsSessionFactory;
import org.springframework.web.socket.sockjs.TransportErrorException;
import org.springframework.web.socket.sockjs.TransportType;
import org.springframework.web.socket.sockjs.transport.SockJsWebSocketHandler;
import org.springframework.web.socket.sockjs.transport.WebSocketServerSockJsSession;

public class WebSocketTransportHandler
implements ConfigurableTransportHandler,
HandshakeHandler,
SockJsSessionFactory {
    private final HandshakeHandler handshakeHandler;
    private SockJsConfiguration sockJsConfig;

    public WebSocketTransportHandler(HandshakeHandler handshakeHandler) {
        Assert.notNull((Object)handshakeHandler, (String)"handshakeHandler must not be null");
        this.handshakeHandler = handshakeHandler;
    }

    @Override
    public TransportType getTransportType() {
        return TransportType.WEBSOCKET;
    }

    @Override
    public void setSockJsConfiguration(SockJsConfiguration sockJsConfig) {
        this.sockJsConfig = sockJsConfig;
    }

    @Override
    public AbstractSockJsSession createSession(String sessionId, WebSocketHandler webSocketHandler) {
        return new WebSocketServerSockJsSession(sessionId, this.sockJsConfig, webSocketHandler);
    }

    @Override
    public void handleRequest(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler webSocketHandler, AbstractSockJsSession session) throws TransportErrorException {
        try {
            WebSocketServerSockJsSession wsSession = (WebSocketServerSockJsSession)session;
            SockJsWebSocketHandler sockJsWrapper = new SockJsWebSocketHandler(this.sockJsConfig, webSocketHandler, wsSession);
            this.handshakeHandler.doHandshake(request, response, sockJsWrapper);
        }
        catch (Throwable t) {
            throw new TransportErrorException("Failed to start handshake request", t, session.getId());
        }
    }

    @Override
    public boolean doHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler handler) throws IOException {
        return this.handshakeHandler.doHandshake(request, response, handler);
    }
}

