/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport;

import java.io.IOException;
import java.nio.charset.Charset;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsFrame;
import org.springframework.web.socket.sockjs.TransportType;
import org.springframework.web.socket.sockjs.transport.AbstractHttpSendingTransportHandler;
import org.springframework.web.socket.sockjs.transport.StreamingSockJsSession;

public class XhrStreamingTransportHandler
extends AbstractHttpSendingTransportHandler {
    @Override
    public TransportType getTransportType() {
        return TransportType.XHR_STREAMING;
    }

    @Override
    protected MediaType getContentType() {
        return new MediaType("application", "javascript", Charset.forName("UTF-8"));
    }

    @Override
    public StreamingSockJsSession createSession(String sessionId, WebSocketHandler handler) {
        Assert.state((this.getSockJsConfig() != null ? 1 : 0) != 0, (String)"This transport requires SockJsConfiguration");
        return new StreamingSockJsSession(sessionId, this.getSockJsConfig(), handler){

            @Override
            protected void writePrelude() throws IOException {
                for (int i = 0; i < 2048; ++i) {
                    this.getResponse().getBody().write(104);
                }
                this.getResponse().getBody().write(10);
                this.getResponse().flush();
            }
        };
    }

    @Override
    protected SockJsFrame.FrameFormat getFrameFormat(ServerHttpRequest request) {
        return new SockJsFrame.DefaultFrameFormat("%s\n");
    }
}

