/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.util.Assert;

public class BeanCreatingHandlerProvider<T>
implements BeanFactoryAware {
    private static final Log logger = LogFactory.getLog(BeanCreatingHandlerProvider.class);
    private final Class<? extends T> handlerType;
    private AutowireCapableBeanFactory beanFactory;

    public BeanCreatingHandlerProvider(Class<? extends T> handlerType) {
        Assert.notNull(handlerType, (String)"handlerType must not be null");
        this.handlerType = handlerType;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof AutowireCapableBeanFactory) {
            this.beanFactory = (AutowireCapableBeanFactory)beanFactory;
        }
    }

    public Class<? extends T> getHandlerType() {
        return this.handlerType;
    }

    public T getHandler() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Creating instance for handler type " + this.handlerType));
        }
        if (this.beanFactory == null) {
            logger.warn((Object)"No BeanFactory available, attempting to use default constructor");
            return (T)BeanUtils.instantiate(this.handlerType);
        }
        return (T)this.beanFactory.createBean(this.handlerType);
    }

    public void destroy(T handler) {
        if (this.beanFactory != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Destroying handler instance " + handler));
            }
            this.beanFactory.destroyBean(handler);
        }
    }

    public String toString() {
        return "BeanCreatingHandlerProvider [handlerClass=" + this.handlerType + "]";
    }
}

