/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.socket.config.WebSocketNamespaceUtils;
import org.springframework.web.socket.server.support.WebSocketHttpRequestHandler;
import org.springframework.web.socket.sockjs.SockJsHttpRequestHandler;
import org.w3c.dom.Element;

class HandlersBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String SOCK_JS_SCHEDULER_NAME = "SockJsScheduler";
    private static final int DEFAULT_MAPPING_ORDER = 1;

    HandlersBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserCxt) {
        Object source = parserCxt.extractSource((Object)element);
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), source);
        parserCxt.pushContainingComponent(compDefinition);
        String orderAttribute = element.getAttribute("order");
        int order = orderAttribute.isEmpty() ? 1 : Integer.valueOf(orderAttribute);
        RootBeanDefinition handlerMappingDef = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
        handlerMappingDef.setSource(source);
        handlerMappingDef.setRole(2);
        handlerMappingDef.getPropertyValues().add("order", (Object)order);
        String handlerMappingName = parserCxt.getReaderContext().registerWithGeneratedName((BeanDefinition)handlerMappingDef);
        RuntimeBeanReference handshakeHandler = WebSocketNamespaceUtils.registerHandshakeHandler(element, parserCxt, source);
        Element interceptorsElement = DomUtils.getChildElementByTagName((Element)element, (String)"handshake-interceptors");
        ManagedList<? super Object> interceptors = WebSocketNamespaceUtils.parseBeanSubElements(interceptorsElement, parserCxt);
        RuntimeBeanReference sockJsServiceRef = WebSocketNamespaceUtils.registerSockJsService(element, SOCK_JS_SCHEDULER_NAME, parserCxt, source);
        HandlerMappingStrategy strategy = this.createHandlerMappingStrategy(sockJsServiceRef, handshakeHandler, interceptors);
        List mappingElements = DomUtils.getChildElementsByTagName((Element)element, (String)"mapping");
        ManagedMap urlMap = new ManagedMap();
        urlMap.setSource(source);
        for (Element mappingElement : mappingElements) {
            urlMap.putAll(strategy.createMappings(mappingElement, parserCxt));
        }
        handlerMappingDef.getPropertyValues().add("urlMap", (Object)urlMap);
        parserCxt.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)handlerMappingDef, handlerMappingName));
        parserCxt.popAndRegisterContainingComponent();
        return null;
    }

    private HandlerMappingStrategy createHandlerMappingStrategy(RuntimeBeanReference sockJsServiceRef, RuntimeBeanReference handshakeHandlerRef, ManagedList<? extends Object> interceptorsList) {
        if (sockJsServiceRef != null) {
            SockJSHandlerMappingStrategy strategy = new SockJSHandlerMappingStrategy();
            strategy.setSockJsServiceRef(sockJsServiceRef);
            return strategy;
        }
        WebSocketHandlerMappingStrategy strategy = new WebSocketHandlerMappingStrategy();
        strategy.setHandshakeHandlerReference(handshakeHandlerRef);
        strategy.setInterceptorsList(interceptorsList);
        return strategy;
    }

    private class SockJSHandlerMappingStrategy
    implements HandlerMappingStrategy {
        private RuntimeBeanReference sockJsServiceRef;

        private SockJSHandlerMappingStrategy() {
        }

        public void setSockJsServiceRef(RuntimeBeanReference sockJsServiceRef) {
            this.sockJsServiceRef = sockJsServiceRef;
        }

        @Override
        public ManagedMap<String, Object> createMappings(Element mappingElement, ParserContext parserContext) {
            ManagedMap urlMap = new ManagedMap();
            Object source = parserContext.extractSource((Object)mappingElement);
            List<String> mappings = Arrays.asList(mappingElement.getAttribute("path").split(","));
            RuntimeBeanReference webSocketHandlerReference = new RuntimeBeanReference(mappingElement.getAttribute("handler"));
            ConstructorArgumentValues cavs = new ConstructorArgumentValues();
            cavs.addIndexedArgumentValue(0, (Object)this.sockJsServiceRef, "SockJsService");
            cavs.addIndexedArgumentValue(1, (Object)webSocketHandlerReference, "WebSocketHandler");
            RootBeanDefinition requestHandlerDef = new RootBeanDefinition(SockJsHttpRequestHandler.class, cavs, null);
            requestHandlerDef.setSource(source);
            requestHandlerDef.setRole(2);
            String requestHandlerName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)requestHandlerDef);
            RuntimeBeanReference requestHandlerRef = new RuntimeBeanReference(requestHandlerName);
            for (String path : mappings) {
                String pathPattern = path.endsWith("/") ? path + "**" : path + "/**";
                urlMap.put((Object)pathPattern, (Object)requestHandlerRef);
            }
            return urlMap;
        }
    }

    private class WebSocketHandlerMappingStrategy
    implements HandlerMappingStrategy {
        private RuntimeBeanReference handshakeHandlerReference;
        private ManagedList<?> interceptorsList;

        private WebSocketHandlerMappingStrategy() {
        }

        public void setHandshakeHandlerReference(RuntimeBeanReference handshakeHandlerReference) {
            this.handshakeHandlerReference = handshakeHandlerReference;
        }

        public void setInterceptorsList(ManagedList<?> interceptorsList) {
            this.interceptorsList = interceptorsList;
        }

        @Override
        public ManagedMap<String, Object> createMappings(Element mappingElement, ParserContext parserContext) {
            ManagedMap urlMap = new ManagedMap();
            Object source = parserContext.extractSource((Object)mappingElement);
            List<String> mappings = Arrays.asList(mappingElement.getAttribute("path").split(","));
            RuntimeBeanReference webSocketHandlerReference = new RuntimeBeanReference(mappingElement.getAttribute("handler"));
            ConstructorArgumentValues cavs = new ConstructorArgumentValues();
            cavs.addIndexedArgumentValue(0, (Object)webSocketHandlerReference);
            if (this.handshakeHandlerReference != null) {
                cavs.addIndexedArgumentValue(1, (Object)this.handshakeHandlerReference);
            }
            RootBeanDefinition requestHandlerDef = new RootBeanDefinition(WebSocketHttpRequestHandler.class, cavs, null);
            requestHandlerDef.setSource(source);
            requestHandlerDef.setRole(2);
            requestHandlerDef.getPropertyValues().add("handshakeInterceptors", this.interceptorsList);
            String requestHandlerName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)requestHandlerDef);
            RuntimeBeanReference requestHandlerRef = new RuntimeBeanReference(requestHandlerName);
            for (String mapping : mappings) {
                urlMap.put((Object)mapping, (Object)requestHandlerRef);
            }
            return urlMap;
        }
    }

    private static interface HandlerMappingStrategy {
        public ManagedMap<String, Object> createMappings(Element var1, ParserContext var2);
    }
}

