/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config.annotation;

import org.springframework.context.annotation.Bean;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.simp.config.AbstractMessageBrokerConfiguration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebMvcStompEndpointRegistry;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;

public abstract class WebSocketMessageBrokerConfigurationSupport
extends AbstractMessageBrokerConfiguration {
    protected WebSocketMessageBrokerConfigurationSupport() {
    }

    @Bean
    public HandlerMapping stompWebSocketHandlerMapping() {
        WebMvcStompEndpointRegistry registry = new WebMvcStompEndpointRegistry(this.subProtocolWebSocketHandler(), this.userSessionRegistry(), (TaskScheduler)this.messageBrokerSockJsTaskScheduler());
        this.registerStompEndpoints(registry);
        return registry.getHandlerMapping();
    }

    @Bean
    public WebSocketHandler subProtocolWebSocketHandler() {
        return new SubProtocolWebSocketHandler((MessageChannel)this.clientInboundChannel(), (SubscribableChannel)this.clientOutboundChannel());
    }

    @Bean
    public ThreadPoolTaskScheduler messageBrokerSockJsTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setThreadNamePrefix("MessageBrokerSockJS-");
        return scheduler;
    }

    protected abstract void registerStompEndpoints(StompEndpointRegistry var1);
}

