/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.EndpointWrapper;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.websockets.Connection;
import org.glassfish.tyrus.websockets.Version;
import org.glassfish.tyrus.websockets.WebSocketApplication;
import org.glassfish.tyrus.websockets.WebSocketEngine;
import org.glassfish.tyrus.websockets.WebSocketRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.standard.AbstractStandardUpgradeStrategy;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;

public class GlassFishRequestUpgradeStrategy
extends AbstractStandardUpgradeStrategy {
    private static final Random random = new Random();
    private static final Constructor<?> tyrusConnectionConstructor;
    private static final Constructor<?> tyrusEndpointConstructor;

    @Override
    public String[] getSupportedVersions() {
        return StringUtils.commaDelimitedListToStringArray((String)Version.getSupportedWireProtocolVersions());
    }

    @Override
    protected List<WebSocketExtension> getInstalledExtensions(WebSocketContainer container) {
        try {
            return super.getInstalledExtensions(container);
        }
        catch (UnsupportedOperationException e) {
            return new ArrayList<WebSocketExtension>();
        }
    }

    @Override
    public void upgradeInternal(ServerHttpRequest request, ServerHttpResponse response, String selectedProtocol, List<Extension> selectedExtensions, Endpoint endpoint) throws HandshakeFailureException {
        Assert.isTrue((boolean)(request instanceof ServletServerHttpRequest));
        HttpServletRequest servletRequest = ((ServletServerHttpRequest)request).getServletRequest();
        Assert.isTrue((boolean)(response instanceof ServletServerHttpResponse));
        HttpServletResponse servletResponse = ((ServletServerHttpResponse)response).getServletResponse();
        WebSocketApplication webSocketApplication = this.createTyrusEndpoint(servletRequest, endpoint, selectedProtocol, selectedExtensions);
        WebSocketEngine webSocketEngine = WebSocketEngine.getEngine();
        try {
            webSocketEngine.register(webSocketApplication);
        }
        catch (DeploymentException ex) {
            throw new HandshakeFailureException("Failed to configure endpoint in GlassFish", ex);
        }
        try {
            this.performUpgrade(servletRequest, servletResponse, request.getHeaders(), webSocketApplication);
        }
        catch (IOException ex) {
            throw new HandshakeFailureException("Response update failed during upgrade to WebSocket, uri=" + request.getURI(), ex);
        }
        finally {
            webSocketEngine.unregister(webSocketApplication);
        }
    }

    private boolean performUpgrade(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers, WebSocketApplication wsApp) throws IOException {
        TyrusHttpUpgradeHandler upgradeHandler;
        try {
            upgradeHandler = (TyrusHttpUpgradeHandler)request.upgrade(TyrusHttpUpgradeHandler.class);
        }
        catch (ServletException ex) {
            throw new HandshakeFailureException("Unable to create UpgradeHandler", ex);
        }
        Connection connection = this.createConnection(upgradeHandler, response);
        RequestContext requestContext = RequestContext.Builder.create().requestURI(URI.create(wsApp.getPath())).requestPath(wsApp.getPath()).userPrincipal(request.getUserPrincipal()).connection(connection).secure(request.isSecure()).build();
        for (String header : headers.keySet()) {
            requestContext.getHeaders().put(header, headers.get((Object)header));
        }
        boolean upgraded = WebSocketEngine.getEngine().upgrade(connection, (WebSocketRequest)requestContext, new WebSocketEngine.WebSocketHolderListener(){

            public void onWebSocketHolder(WebSocketEngine.WebSocketHolder webSocketHolder) {
                upgradeHandler.setWebSocketHolder(webSocketHolder);
            }
        });
        response.flushBuffer();
        return upgraded;
    }

    private WebSocketApplication createTyrusEndpoint(HttpServletRequest request, Endpoint endpoint, String selectedProtocol, List<Extension> selectedExtensions) {
        String endpointPath = "/" + random.nextLong();
        ServerEndpointRegistration endpointConfig = new ServerEndpointRegistration(endpointPath, endpoint);
        endpointConfig.setSubprotocols(Arrays.asList(selectedProtocol));
        endpointConfig.setExtensions(selectedExtensions);
        return this.createTyrusEndpoint(new EndpointWrapper(endpoint, (EndpointConfig)endpointConfig, ComponentProviderService.create(), null, "/", new ErrorCollector(), endpointConfig.getConfigurator()));
    }

    private Connection createConnection(TyrusHttpUpgradeHandler handler, HttpServletResponse response) {
        try {
            return (Connection)tyrusConnectionConstructor.newInstance(handler, response);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create GlassFish connection", ex);
        }
    }

    protected WebSocketApplication createTyrusEndpoint(EndpointWrapper endpoint) {
        try {
            return (WebSocketApplication)tyrusEndpointConstructor.newInstance(endpoint);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create GlassFish endpoint", ex);
        }
    }

    static {
        ClassLoader cl = GlassFishRequestUpgradeStrategy.class.getClassLoader();
        try {
            Class<?> tyrusEndpointClass;
            Class<?> tyrusConnectionClass = cl.loadClass("org.glassfish.tyrus.servlet.ConnectionImpl");
            tyrusConnectionConstructor = tyrusConnectionClass.getDeclaredConstructor(TyrusHttpUpgradeHandler.class, HttpServletResponse.class);
            ReflectionUtils.makeAccessible(tyrusConnectionConstructor);
            try {
                tyrusEndpointClass = cl.loadClass("org.glassfish.tyrus.core.TyrusEndpoint");
            }
            catch (ClassNotFoundException ex) {
                try {
                    tyrusEndpointClass = cl.loadClass("org.glassfish.tyrus.server.TyrusEndpoint");
                }
                catch (ClassNotFoundException ex2) {
                    throw ex;
                }
            }
            tyrusEndpointConstructor = tyrusEndpointClass.getConstructor(SPIEndpoint.class);
        }
        catch (Exception ex) {
            throw new IllegalStateException("No compatible Tyrus version found", ex);
        }
    }
}

