/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.handler.ExceptionWebSocketHandlerDecorator;
import org.springframework.web.socket.handler.LoggingWebSocketHandlerDecorator;
import org.springframework.web.socket.sockjs.SockJsException;
import org.springframework.web.socket.sockjs.SockJsService;

public class SockJsHttpRequestHandler
implements HttpRequestHandler {
    private final SockJsService sockJsService;
    private final WebSocketHandler wsHandler;

    public SockJsHttpRequestHandler(SockJsService sockJsService, WebSocketHandler wsHandler) {
        Assert.notNull((Object)sockJsService, (String)"sockJsService must not be null");
        Assert.notNull((Object)wsHandler, (String)"webSocketHandler must not be null");
        this.sockJsService = sockJsService;
        this.wsHandler = new ExceptionWebSocketHandlerDecorator(new LoggingWebSocketHandlerDecorator(wsHandler));
    }

    public SockJsService getSockJsService() {
        return this.sockJsService;
    }

    public WebSocketHandler getWebSocketHandler() {
        return this.wsHandler;
    }

    public void handleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        ServletServerHttpRequest request = new ServletServerHttpRequest(servletRequest);
        ServletServerHttpResponse response = new ServletServerHttpResponse(servletResponse);
        try {
            this.sockJsService.handleRequest((ServerHttpRequest)request, (ServerHttpResponse)response, this.getSockJsPath(servletRequest), this.wsHandler);
        }
        catch (Throwable t) {
            throw new SockJsException("Uncaught failure in SockJS request, uri=" + request.getURI(), t);
        }
    }

    private String getSockJsPath(HttpServletRequest servletRequest) {
        String attribute = HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE;
        String path = (String)servletRequest.getAttribute(attribute);
        return path.length() > 0 && path.charAt(0) != '/' ? "/" + path : path;
    }
}

