/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.support.frame;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.util.Assert;
import org.springframework.web.socket.sockjs.support.frame.AbstractSockJsMessageCodec;

public class Jackson2SockJsMessageCodec
extends AbstractSockJsMessageCodec {
    private final ObjectMapper objectMapper;

    public Jackson2SockJsMessageCodec() {
        this.objectMapper = new ObjectMapper();
    }

    public Jackson2SockJsMessageCodec(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.objectMapper = objectMapper;
    }

    @Override
    public String[] decode(String content) throws IOException {
        return (String[])this.objectMapper.readValue(content, String[].class);
    }

    @Override
    public String[] decodeInputStream(InputStream content) throws IOException {
        return (String[])this.objectMapper.readValue(content, String[].class);
    }

    @Override
    protected char[] applyJsonQuoting(String content) {
        return JsonStringEncoder.getInstance().quoteAsString(content);
    }
}

