/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.support.frame;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.io.JsonStringEncoder;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.util.Assert;
import org.springframework.web.socket.sockjs.support.frame.AbstractSockJsMessageCodec;

public class JacksonSockJsMessageCodec
extends AbstractSockJsMessageCodec {
    private final ObjectMapper objectMapper;

    public JacksonSockJsMessageCodec() {
        this.objectMapper = new ObjectMapper();
    }

    public JacksonSockJsMessageCodec(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.objectMapper = objectMapper;
    }

    @Override
    public String[] decode(String content) throws IOException {
        return (String[])this.objectMapper.readValue(content, String[].class);
    }

    @Override
    public String[] decodeInputStream(InputStream content) throws IOException {
        return (String[])this.objectMapper.readValue(content, String[].class);
    }

    @Override
    protected char[] applyJsonQuoting(String content) {
        return JsonStringEncoder.getInstance().quoteAsString(content);
    }
}

