/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.support.frame;

import java.nio.charset.Charset;
import org.springframework.util.Assert;
import org.springframework.web.socket.sockjs.support.frame.SockJsMessageCodec;

public class SockJsFrame {
    private static final SockJsFrame openFrame = new SockJsFrame("o");
    private static final SockJsFrame heartbeatFrame = new SockJsFrame("h");
    private static final SockJsFrame closeGoAwayFrame = SockJsFrame.closeFrame(3000, "Go away!");
    private static final SockJsFrame closeAnotherConnectionOpenFrame = SockJsFrame.closeFrame(2010, "Another connection still open");
    private final String content;

    private SockJsFrame(String content) {
        Assert.notNull((Object)"Content must not be null");
        this.content = content;
    }

    public static SockJsFrame openFrame() {
        return openFrame;
    }

    public static SockJsFrame heartbeatFrame() {
        return heartbeatFrame;
    }

    public static SockJsFrame messageFrame(SockJsMessageCodec codec, String ... messages) {
        String encoded = codec.encode(messages);
        return new SockJsFrame(encoded);
    }

    public static SockJsFrame closeFrameGoAway() {
        return closeGoAwayFrame;
    }

    public static SockJsFrame closeFrameAnotherConnectionOpen() {
        return closeAnotherConnectionOpenFrame;
    }

    public static SockJsFrame closeFrame(int code, String reason) {
        return new SockJsFrame("c[" + code + ",\"" + reason + "\"]");
    }

    public String getContent() {
        return this.content;
    }

    public byte[] getContentBytes() {
        return this.content.getBytes(Charset.forName("UTF-8"));
    }

    public String toString() {
        String result = this.content;
        if (result.length() > 80) {
            result = result.substring(0, 80) + "...(truncated)";
        }
        return "SockJsFrame content='" + result.replace("\n", "\\n").replace("\r", "\\r") + "'";
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SockJsFrame)) {
            return false;
        }
        return this.content.equals(((SockJsFrame)other).content);
    }

    public static class DefaultFrameFormat
    implements FrameFormat {
        private final String format;

        public DefaultFrameFormat(String format) {
            Assert.notNull((Object)format, (String)"format must not be null");
            this.format = format;
        }

        @Override
        public SockJsFrame format(SockJsFrame frame) {
            String content = String.format(this.format, this.preProcessContent(frame.getContent()));
            return new SockJsFrame(content);
        }

        protected String preProcessContent(String content) {
            return content;
        }
    }

    public static interface FrameFormat {
        public SockJsFrame format(SockJsFrame var1);
    }
}

