/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.handler;

import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.sockjs.SockJsException;
import org.springframework.web.socket.sockjs.transport.TransportHandler;
import org.springframework.web.socket.sockjs.transport.handler.TransportHandlerSupport;
import org.springframework.web.socket.sockjs.transport.session.AbstractHttpSockJsSession;

public abstract class AbstractHttpReceivingTransportHandler
extends TransportHandlerSupport
implements TransportHandler {
    @Override
    public final void handleRequest(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, WebSocketSession wsSession) throws SockJsException {
        Assert.notNull((Object)wsSession, (String)"No session");
        AbstractHttpSockJsSession sockJsSession = (AbstractHttpSockJsSession)wsSession;
        this.handleRequestInternal(request, response, wsHandler, sockJsSession);
    }

    protected void handleRequestInternal(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, AbstractHttpSockJsSession sockJsSession) throws SockJsException {
        String[] messages = null;
        try {
            messages = this.readMessages(request);
        }
        catch (JsonMappingException ex) {
            this.logger.error((Object)("Failed to read message: " + ex.getMessage()));
            this.handleReadError(response, "Payload expected.", sockJsSession.getId());
            return;
        }
        catch (IOException ex) {
            this.logger.error((Object)("Failed to read message: " + ex.getMessage()));
            this.handleReadError(response, "Broken JSON encoding.", sockJsSession.getId());
            return;
        }
        catch (Throwable t) {
            this.logger.error((Object)("Failed to read message: " + t.getMessage()));
            this.handleReadError(response, "Failed to read message(s)", sockJsSession.getId());
            return;
        }
        if (messages == null) {
            this.handleReadError(response, "Payload expected.", sockJsSession.getId());
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Received message(s): " + Arrays.asList(messages)));
        }
        response.setStatusCode(this.getResponseStatus());
        response.getHeaders().setContentType(new MediaType("text", "plain", Charset.forName("UTF-8")));
        sockJsSession.delegateMessages(messages);
    }

    private void handleReadError(ServerHttpResponse resp, String error, String sessionId) {
        try {
            resp.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            resp.getBody().write(error.getBytes("UTF-8"));
        }
        catch (IOException ex) {
            throw new SockJsException("Failed to send error: " + error, sessionId, ex);
        }
    }

    protected abstract String[] readMessages(ServerHttpRequest var1) throws IOException;

    protected abstract HttpStatus getResponseStatus();
}

