/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;
import org.springframework.web.socket.server.support.HandshakeInterceptorChain;
import org.springframework.web.socket.sockjs.SockJsException;
import org.springframework.web.socket.sockjs.support.AbstractSockJsService;
import org.springframework.web.socket.sockjs.support.frame.Jackson2SockJsMessageCodec;
import org.springframework.web.socket.sockjs.support.frame.JacksonSockJsMessageCodec;
import org.springframework.web.socket.sockjs.support.frame.SockJsMessageCodec;
import org.springframework.web.socket.sockjs.transport.TransportHandler;
import org.springframework.web.socket.sockjs.transport.TransportType;
import org.springframework.web.socket.sockjs.transport.handler.EventSourceTransportHandler;
import org.springframework.web.socket.sockjs.transport.handler.HtmlFileTransportHandler;
import org.springframework.web.socket.sockjs.transport.handler.JsonpPollingTransportHandler;
import org.springframework.web.socket.sockjs.transport.handler.JsonpReceivingTransportHandler;
import org.springframework.web.socket.sockjs.transport.handler.SockJsSessionFactory;
import org.springframework.web.socket.sockjs.transport.handler.TransportHandlerSupport;
import org.springframework.web.socket.sockjs.transport.handler.WebSocketTransportHandler;
import org.springframework.web.socket.sockjs.transport.handler.XhrPollingTransportHandler;
import org.springframework.web.socket.sockjs.transport.handler.XhrReceivingTransportHandler;
import org.springframework.web.socket.sockjs.transport.handler.XhrStreamingTransportHandler;
import org.springframework.web.socket.sockjs.transport.session.AbstractSockJsSession;
import org.springframework.web.socket.sockjs.transport.session.SockJsServiceConfig;

public class DefaultSockJsService
extends AbstractSockJsService {
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)DefaultSockJsService.class.getClassLoader());
    private static final boolean jacksonPresent = ClassUtils.isPresent((String)"org.codehaus.jackson.map.ObjectMapper", (ClassLoader)DefaultSockJsService.class.getClassLoader());
    private final Map<TransportType, TransportHandler> transportHandlers = new HashMap<TransportType, TransportHandler>();
    private SockJsMessageCodec messageCodec;
    private final List<HandshakeInterceptor> interceptors = new ArrayList<HandshakeInterceptor>();
    private final Map<String, AbstractSockJsSession> sessions = new ConcurrentHashMap<String, AbstractSockJsSession>();
    private ScheduledFuture<?> sessionCleanupTask;
    private final SockJsServiceConfig sockJsServiceConfig = new SockJsServiceConfig(){

        @Override
        public int getStreamBytesLimit() {
            return DefaultSockJsService.this.getStreamBytesLimit();
        }

        @Override
        public long getHeartbeatTime() {
            return DefaultSockJsService.this.getHeartbeatTime();
        }

        @Override
        public TaskScheduler getTaskScheduler() {
            return DefaultSockJsService.this.getTaskScheduler();
        }

        @Override
        public SockJsMessageCodec getMessageCodec() {
            Assert.state((DefaultSockJsService.this.getMessageCodec() != null ? 1 : 0) != 0, (String)"A SockJsMessageCodec is required but not available. Either add Jackson 2 or Jackson 1.x to the classpath, or configure a SockJsMessageCode");
            return DefaultSockJsService.this.getMessageCodec();
        }

        @Override
        public int getHttpMessageCacheSize() {
            return DefaultSockJsService.this.getHttpMessageCacheSize();
        }
    };

    public DefaultSockJsService(TaskScheduler taskScheduler) {
        this(taskScheduler, null, new TransportHandler[0]);
    }

    public DefaultSockJsService(TaskScheduler taskScheduler, Collection<TransportHandler> transportHandlers, TransportHandler ... transportHandlerOverrides) {
        super(taskScheduler);
        this.initMessageCodec();
        if (CollectionUtils.isEmpty(transportHandlers)) {
            this.addTransportHandlers(this.getDefaultTransportHandlers());
        } else {
            this.addTransportHandlers(transportHandlers);
        }
        if (!ObjectUtils.isEmpty((Object[])transportHandlerOverrides)) {
            this.addTransportHandlers(Arrays.asList(transportHandlerOverrides));
        }
        if (this.transportHandlers.isEmpty()) {
            this.logger.warn((Object)"No transport handlers");
        }
    }

    private void initMessageCodec() {
        if (jackson2Present) {
            this.messageCodec = new Jackson2SockJsMessageCodec();
        } else if (jacksonPresent) {
            this.messageCodec = new JacksonSockJsMessageCodec();
        }
    }

    protected final Set<TransportHandler> getDefaultTransportHandlers() {
        HashSet<TransportHandler> result;
        block2: {
            result = new HashSet<TransportHandler>();
            result.add(new XhrPollingTransportHandler());
            result.add(new XhrReceivingTransportHandler());
            result.add(new JsonpPollingTransportHandler());
            result.add(new JsonpReceivingTransportHandler());
            result.add(new XhrStreamingTransportHandler());
            result.add(new EventSourceTransportHandler());
            result.add(new HtmlFileTransportHandler());
            try {
                result.add(new WebSocketTransportHandler(new DefaultHandshakeHandler()));
            }
            catch (Exception ex) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn((Object)"Failed to create default WebSocketTransportHandler", (Throwable)ex);
            }
        }
        return result;
    }

    protected void addTransportHandlers(Collection<TransportHandler> handlers) {
        for (TransportHandler handler : handlers) {
            if (handler instanceof TransportHandlerSupport) {
                ((TransportHandlerSupport)((Object)handler)).setSockJsServiceConfiguration(this.sockJsServiceConfig);
            }
            this.transportHandlers.put(handler.getTransportType(), handler);
        }
    }

    public void setHandshakeInterceptors(List<HandshakeInterceptor> interceptors) {
        this.interceptors.clear();
        if (interceptors != null) {
            this.interceptors.addAll(interceptors);
        }
    }

    public List<HandshakeInterceptor> getHandshakeInterceptors() {
        return this.interceptors;
    }

    public void setMessageCodec(SockJsMessageCodec messageCodec) {
        this.messageCodec = messageCodec;
    }

    public SockJsMessageCodec getMessageCodec() {
        return this.messageCodec;
    }

    public Map<TransportType, TransportHandler> getTransportHandlers() {
        return Collections.unmodifiableMap(this.transportHandlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleRawWebSocketRequest(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler) throws IOException {
        block11: {
            if (!this.isWebSocketEnabled()) {
                return;
            }
            TransportHandler transportHandler = this.transportHandlers.get((Object)TransportType.WEBSOCKET);
            if (transportHandler == null || !(transportHandler instanceof HandshakeHandler)) {
                this.logger.warn((Object)"No handler for raw WebSocket messages");
                response.setStatusCode(HttpStatus.NOT_FOUND);
                return;
            }
            HandshakeInterceptorChain chain = new HandshakeInterceptorChain(this.interceptors, wsHandler);
            HandshakeFailureException failure = null;
            try {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                if (!chain.applyBeforeHandshake(request, response, attributes)) {
                    return;
                }
                ((HandshakeHandler)((Object)transportHandler)).doHandshake(request, response, wsHandler, attributes);
                chain.applyAfterHandshake(request, response, null);
            }
            catch (HandshakeFailureException ex) {
                failure = ex;
            }
            catch (Throwable t) {
                failure = new HandshakeFailureException("Uncaught failure for request " + request.getURI(), t);
            }
            finally {
                if (failure == null) break block11;
                chain.applyAfterHandshake(request, response, (Exception)((Object)failure));
                throw failure;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleTransportRequest(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, String sessionId, String transport) throws SockJsException {
        block21: {
            TransportType transportType = TransportType.fromValue(transport);
            if (transportType == null) {
                this.logger.debug((Object)("Unknown transport type: " + (Object)((Object)transportType)));
                response.setStatusCode(HttpStatus.NOT_FOUND);
                return;
            }
            TransportHandler transportHandler = this.transportHandlers.get((Object)transportType);
            if (transportHandler == null) {
                this.logger.debug((Object)"Transport handler not found");
                response.setStatusCode(HttpStatus.NOT_FOUND);
                return;
            }
            HttpMethod supportedMethod = transportType.getHttpMethod();
            if (!supportedMethod.equals((Object)request.getMethod())) {
                if (HttpMethod.OPTIONS.equals((Object)request.getMethod()) && transportType.supportsCors()) {
                    response.setStatusCode(HttpStatus.NO_CONTENT);
                    this.addCorsHeaders(request, response, HttpMethod.OPTIONS, supportedMethod);
                    this.addCacheHeaders(response);
                } else {
                    List<HttpMethod> supportedMethods = Arrays.asList(supportedMethod);
                    if (transportType.supportsCors()) {
                        supportedMethods.add(HttpMethod.OPTIONS);
                    }
                    this.sendMethodNotAllowed(response, supportedMethods);
                }
                return;
            }
            HandshakeInterceptorChain chain = new HandshakeInterceptorChain(this.interceptors, wsHandler);
            SockJsException failure = null;
            try {
                WebSocketSession session = this.sessions.get(sessionId);
                if (session == null) {
                    if (transportHandler instanceof SockJsSessionFactory) {
                        HashMap<String, Object> attributes = new HashMap<String, Object>();
                        if (!chain.applyBeforeHandshake(request, response, attributes)) {
                            return;
                        }
                        SockJsSessionFactory sessionFactory = (SockJsSessionFactory)((Object)transportHandler);
                        session = this.createSockJsSession(sessionId, sessionFactory, wsHandler, attributes, request, response);
                    } else {
                        response.setStatusCode(HttpStatus.NOT_FOUND);
                        this.logger.warn((Object)"Session not found");
                        return;
                    }
                }
                if (transportType.sendsNoCacheInstruction()) {
                    this.addNoCacheHeaders(response);
                }
                if (transportType.supportsCors()) {
                    this.addCorsHeaders(request, response, new HttpMethod[0]);
                }
                transportHandler.handleRequest(request, response, wsHandler, session);
                chain.applyAfterHandshake(request, response, null);
            }
            catch (SockJsException ex) {
                failure = ex;
            }
            catch (Throwable t) {
                failure = new SockJsException("Uncaught failure for request " + request.getURI(), sessionId, t);
            }
            finally {
                if (failure == null) break block21;
                chain.applyAfterHandshake(request, response, (Exception)((Object)failure));
                throw failure;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebSocketSession createSockJsSession(String sessionId, SockJsSessionFactory sessionFactory, WebSocketHandler wsHandler, Map<String, Object> handshakeAttributes, ServerHttpRequest request, ServerHttpResponse response) {
        Map<String, AbstractSockJsSession> map = this.sessions;
        synchronized (map) {
            AbstractSockJsSession session = this.sessions.get(sessionId);
            if (session != null) {
                return session;
            }
            if (this.sessionCleanupTask == null) {
                this.scheduleSessionTask();
            }
            this.logger.debug((Object)("Creating new session with session id \"" + sessionId + "\""));
            session = sessionFactory.createSession(sessionId, wsHandler, handshakeAttributes);
            this.sessions.put(sessionId, session);
            return session;
        }
    }

    @Override
    protected boolean isValidTransportType(String lastSegment) {
        return TransportType.fromValue(lastSegment) != null;
    }

    private void scheduleSessionTask() {
        this.sessionCleanupTask = this.getTaskScheduler().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    int count = DefaultSockJsService.this.sessions.size();
                    if (DefaultSockJsService.this.logger.isTraceEnabled() && count != 0) {
                        DefaultSockJsService.this.logger.trace((Object)("Checking " + count + " session(s) for timeouts [" + DefaultSockJsService.this.getName() + "]"));
                    }
                    for (AbstractSockJsSession session : DefaultSockJsService.this.sessions.values()) {
                        if (session.getTimeSinceLastActive() <= DefaultSockJsService.this.getDisconnectDelay()) continue;
                        if (DefaultSockJsService.this.logger.isTraceEnabled()) {
                            DefaultSockJsService.this.logger.trace((Object)("Removing " + session + " for [" + DefaultSockJsService.this.getName() + "]"));
                        }
                        session.close();
                        DefaultSockJsService.this.sessions.remove(session.getId());
                    }
                    if (DefaultSockJsService.this.logger.isTraceEnabled() && count != 0) {
                        DefaultSockJsService.this.logger.trace((Object)(DefaultSockJsService.this.sessions.size() + " remaining session(s) [" + DefaultSockJsService.this.getName() + "]"));
                    }
                }
                catch (Throwable t) {
                    DefaultSockJsService.this.logger.error((Object)("Failed to complete session timeout checks for [" + DefaultSockJsService.this.getName() + "]"), t);
                }
            }
        }, this.getDisconnectDelay());
    }
}

