/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.handler;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.support.frame.SockJsFrame;
import org.springframework.web.socket.sockjs.transport.TransportType;
import org.springframework.web.socket.sockjs.transport.handler.AbstractHttpSendingTransportHandler;
import org.springframework.web.socket.sockjs.transport.session.SockJsServiceConfig;
import org.springframework.web.socket.sockjs.transport.session.StreamingSockJsSession;

public class EventSourceTransportHandler
extends AbstractHttpSendingTransportHandler {
    @Override
    public TransportType getTransportType() {
        return TransportType.EVENT_SOURCE;
    }

    @Override
    protected MediaType getContentType() {
        return new MediaType("text", "event-stream", Charset.forName("UTF-8"));
    }

    @Override
    public StreamingSockJsSession createSession(String sessionId, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        return new EventSourceStreamingSockJsSession(sessionId, this.getSockJsServiceConfig(), wsHandler, attributes);
    }

    @Override
    protected SockJsFrame.FrameFormat getFrameFormat(ServerHttpRequest request) {
        return new SockJsFrame.DefaultFrameFormat("data: %s\r\n\r\n");
    }

    private final class EventSourceStreamingSockJsSession
    extends StreamingSockJsSession {
        private EventSourceStreamingSockJsSession(String sessionId, SockJsServiceConfig config, WebSocketHandler wsHandler, Map<String, Object> attributes) {
            super(sessionId, config, wsHandler, attributes);
        }

        @Override
        protected void writePrelude() throws IOException {
            this.getResponse().getBody().write(13);
            this.getResponse().getBody().write(10);
            this.getResponse().flush();
        }
    }
}

