/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.handler;

import java.util.Collections;
import java.util.Map;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.sockjs.SockJsException;
import org.springframework.web.socket.sockjs.SockJsTransportFailureException;
import org.springframework.web.socket.sockjs.transport.TransportHandler;
import org.springframework.web.socket.sockjs.transport.TransportType;
import org.springframework.web.socket.sockjs.transport.handler.SockJsSessionFactory;
import org.springframework.web.socket.sockjs.transport.handler.SockJsWebSocketHandler;
import org.springframework.web.socket.sockjs.transport.handler.TransportHandlerSupport;
import org.springframework.web.socket.sockjs.transport.session.AbstractSockJsSession;
import org.springframework.web.socket.sockjs.transport.session.WebSocketServerSockJsSession;

public class WebSocketTransportHandler
extends TransportHandlerSupport
implements TransportHandler,
SockJsSessionFactory,
HandshakeHandler {
    private final HandshakeHandler handshakeHandler;

    public WebSocketTransportHandler(HandshakeHandler handshakeHandler) {
        Assert.notNull((Object)handshakeHandler, (String)"handshakeHandler must not be null");
        this.handshakeHandler = handshakeHandler;
    }

    @Override
    public TransportType getTransportType() {
        return TransportType.WEBSOCKET;
    }

    public HandshakeHandler getHandshakeHandler() {
        return this.handshakeHandler;
    }

    @Override
    public AbstractSockJsSession createSession(String sessionId, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        return new WebSocketServerSockJsSession(sessionId, this.getSockJsServiceConfig(), wsHandler, attributes);
    }

    @Override
    public void handleRequest(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, WebSocketSession wsSession) throws SockJsException {
        WebSocketServerSockJsSession sockJsSession = (WebSocketServerSockJsSession)wsSession;
        try {
            wsHandler = new SockJsWebSocketHandler(this.getSockJsServiceConfig(), wsHandler, sockJsSession);
            this.handshakeHandler.doHandshake(request, response, wsHandler, Collections.<String, Object>emptyMap());
        }
        catch (Throwable t) {
            sockJsSession.tryCloseWithSockJsTransportError(t, CloseStatus.SERVER_ERROR);
            throw new SockJsTransportFailureException("WebSocket handshake failure", wsSession.getId(), t);
        }
    }

    @Override
    public boolean doHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler handler, Map<String, Object> attributes) throws HandshakeFailureException {
        return this.handshakeHandler.doHandshake(request, response, handler, attributes);
    }
}

