/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.handler;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.support.frame.SockJsFrame;
import org.springframework.web.socket.sockjs.transport.TransportType;
import org.springframework.web.socket.sockjs.transport.handler.AbstractHttpSendingTransportHandler;
import org.springframework.web.socket.sockjs.transport.session.SockJsServiceConfig;
import org.springframework.web.socket.sockjs.transport.session.StreamingSockJsSession;

public class XhrStreamingTransportHandler
extends AbstractHttpSendingTransportHandler {
    @Override
    public TransportType getTransportType() {
        return TransportType.XHR_STREAMING;
    }

    @Override
    protected MediaType getContentType() {
        return new MediaType("application", "javascript", Charset.forName("UTF-8"));
    }

    @Override
    public StreamingSockJsSession createSession(String sessionId, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        return new XhrStreamingSockJsSession(sessionId, this.getSockJsServiceConfig(), wsHandler, attributes);
    }

    @Override
    protected SockJsFrame.FrameFormat getFrameFormat(ServerHttpRequest request) {
        return new SockJsFrame.DefaultFrameFormat("%s\n");
    }

    private final class XhrStreamingSockJsSession
    extends StreamingSockJsSession {
        private XhrStreamingSockJsSession(String sessionId, SockJsServiceConfig config, WebSocketHandler wsHandler, Map<String, Object> attributes) {
            super(sessionId, config, wsHandler, attributes);
        }

        @Override
        protected void writePrelude() throws IOException {
            for (int i = 0; i < 2048; ++i) {
                this.getResponse().getBody().write(104);
            }
            this.getResponse().getBody().write(10);
            this.getResponse().flush();
        }
    }
}

