/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.session;

import java.util.Map;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsTransportFailureException;
import org.springframework.web.socket.sockjs.support.frame.SockJsFrame;
import org.springframework.web.socket.sockjs.support.frame.SockJsMessageCodec;
import org.springframework.web.socket.sockjs.transport.session.AbstractHttpSockJsSession;
import org.springframework.web.socket.sockjs.transport.session.SockJsServiceConfig;

public class PollingSockJsSession
extends AbstractHttpSockJsSession {
    public PollingSockJsSession(String sessionId, SockJsServiceConfig config, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        super(sessionId, config, wsHandler, attributes);
    }

    @Override
    protected void flushCache() throws SockJsTransportFailureException {
        this.cancelHeartbeat();
        String[] messages = this.getMessageCache().toArray(new String[this.getMessageCache().size()]);
        this.getMessageCache().clear();
        SockJsMessageCodec messageCodec = this.getSockJsServiceConfig().getMessageCodec();
        SockJsFrame frame = SockJsFrame.messageFrame(messageCodec, messages);
        this.writeFrame(frame);
    }

    @Override
    protected void writeFrame(SockJsFrame frame) throws SockJsTransportFailureException {
        super.writeFrame(frame);
        this.resetRequest();
    }
}

