/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.session;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.adapter.NativeWebSocketSession;
import org.springframework.web.socket.sockjs.SockJsTransportFailureException;
import org.springframework.web.socket.sockjs.support.frame.SockJsFrame;
import org.springframework.web.socket.sockjs.support.frame.SockJsMessageCodec;
import org.springframework.web.socket.sockjs.transport.session.AbstractSockJsSession;
import org.springframework.web.socket.sockjs.transport.session.SockJsServiceConfig;

public class WebSocketServerSockJsSession
extends AbstractSockJsSession
implements WebSocketSession,
NativeWebSocketSession {
    private WebSocketSession wsSession;

    public WebSocketServerSockJsSession(String id, SockJsServiceConfig config, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        super(id, config, wsHandler, attributes);
    }

    @Override
    public URI getUri() {
        this.checkDelegateSessionInitialized();
        return this.wsSession.getUri();
    }

    @Override
    public HttpHeaders getHandshakeHeaders() {
        this.checkDelegateSessionInitialized();
        return this.wsSession.getHandshakeHeaders();
    }

    @Override
    public Principal getPrincipal() {
        this.checkDelegateSessionInitialized();
        return this.wsSession.getPrincipal();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        this.checkDelegateSessionInitialized();
        return this.wsSession.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        this.checkDelegateSessionInitialized();
        return this.wsSession.getRemoteAddress();
    }

    @Override
    public String getAcceptedProtocol() {
        this.checkDelegateSessionInitialized();
        return this.wsSession.getAcceptedProtocol();
    }

    @Override
    public List<WebSocketExtension> getExtensions() {
        this.checkDelegateSessionInitialized();
        return this.wsSession.getExtensions();
    }

    private void checkDelegateSessionInitialized() {
        Assert.state((this.wsSession != null ? 1 : 0) != 0, (String)"WebSocketSession not yet initialized");
    }

    @Override
    public Object getNativeSession() {
        if (this.wsSession != null && this.wsSession instanceof NativeWebSocketSession) {
            return ((NativeWebSocketSession)this.wsSession).getNativeSession();
        }
        return null;
    }

    @Override
    public <T> T getNativeSession(Class<T> requiredType) {
        if (this.wsSession != null && this.wsSession instanceof NativeWebSocketSession) {
            return ((NativeWebSocketSession)this.wsSession).getNativeSession(requiredType);
        }
        return null;
    }

    public void initializeDelegateSession(WebSocketSession session) {
        this.wsSession = session;
        try {
            TextMessage message = new TextMessage(SockJsFrame.openFrame().getContent());
            this.wsSession.sendMessage(message);
            this.scheduleHeartbeat();
            this.delegateConnectionEstablished();
        }
        catch (Exception ex) {
            this.tryCloseWithSockJsTransportError(ex, CloseStatus.SERVER_ERROR);
            return;
        }
    }

    @Override
    public boolean isActive() {
        return this.wsSession != null && this.wsSession.isOpen();
    }

    public void handleMessage(TextMessage message, WebSocketSession wsSession) throws Exception {
        String[] messages;
        String payload = (String)message.getPayload();
        if (StringUtils.isEmpty((Object)payload)) {
            this.logger.trace((Object)"Ignoring empty message");
            return;
        }
        try {
            messages = this.getSockJsServiceConfig().getMessageCodec().decode(payload);
        }
        catch (Throwable ex) {
            this.logger.error((Object)"Broken data received. Terminating WebSocket connection abruptly", ex);
            this.tryCloseWithSockJsTransportError(ex, CloseStatus.BAD_DATA);
            return;
        }
        this.delegateMessages(messages);
    }

    @Override
    public void sendMessageInternal(String message) throws SockJsTransportFailureException {
        this.cancelHeartbeat();
        SockJsMessageCodec messageCodec = this.getSockJsServiceConfig().getMessageCodec();
        SockJsFrame frame = SockJsFrame.messageFrame(messageCodec, message);
        this.writeFrame(frame);
        this.scheduleHeartbeat();
    }

    @Override
    protected void writeFrameInternal(SockJsFrame frame) throws IOException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Write " + frame));
        }
        TextMessage message = new TextMessage(frame.getContent());
        this.wsSession.sendMessage(message);
    }

    @Override
    protected void disconnect(CloseStatus status) throws IOException {
        if (this.wsSession != null) {
            this.wsSession.close(status);
        }
    }
}

