/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.standard.AbstractTyrusRequestUpgradeStrategy;

public class GlassFishRequestUpgradeStrategy
extends AbstractTyrusRequestUpgradeStrategy {
    private static final AbstractTyrusRequestUpgradeStrategy.TyrusEndpointHelper endpointHelper = new AbstractTyrusRequestUpgradeStrategy.Tyrus17EndpointHelper();
    private static final GlassFishServletWriterHelper servletWriterHelper = new GlassFishServletWriterHelper();

    @Override
    protected AbstractTyrusRequestUpgradeStrategy.TyrusEndpointHelper getEndpointHelper() {
        return endpointHelper;
    }

    @Override
    protected void handleSuccess(HttpServletRequest request, HttpServletResponse response, WebSocketEngine.UpgradeInfo upgradeInfo, TyrusUpgradeResponse upgradeResponse) throws IOException, ServletException {
        TyrusHttpUpgradeHandler handler = (TyrusHttpUpgradeHandler)request.upgrade(TyrusHttpUpgradeHandler.class);
        Writer servletWriter = GlassFishRequestUpgradeStrategy.servletWriterHelper.newInstance(handler);
        handler.preInit(upgradeInfo, servletWriter, request.getUserPrincipal() != null);
        response.setStatus(upgradeResponse.getStatus());
        for (Map.Entry entry : upgradeResponse.getHeaders().entrySet()) {
            response.addHeader((String)entry.getKey(), Utils.getHeaderFromList((List)((List)entry.getValue())));
        }
        response.flushBuffer();
    }

    private static class GlassFishServletWriterHelper {
        private static final Constructor<?> constructor;

        private GlassFishServletWriterHelper() {
        }

        private Writer newInstance(TyrusHttpUpgradeHandler handler) {
            try {
                return (Writer)constructor.newInstance(handler);
            }
            catch (Exception ex) {
                throw new HandshakeFailureException("Failed to instantiate TyrusServletWriter", ex);
            }
        }

        static {
            try {
                ClassLoader classLoader = GlassFishRequestUpgradeStrategy.class.getClassLoader();
                Class<?> type = classLoader.loadClass("org.glassfish.tyrus.servlet.TyrusServletWriter");
                constructor = type.getDeclaredConstructor(TyrusHttpUpgradeHandler.class);
                ReflectionUtils.makeAccessible(constructor);
            }
            catch (Exception ex) {
                throw new IllegalStateException("No compatible Tyrus version found", ex);
            }
        }
    }
}

