/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.websockets.ServletWebSocketHttpExchange;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.EncodingFactory;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.jsr.handshake.JsrHybi07Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi08Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi13Handshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpointConfig;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.ClassUtils;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.standard.AbstractStandardUpgradeStrategy;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;
import org.xnio.StreamConnection;

public class UndertowRequestUpgradeStrategy
extends AbstractStandardUpgradeStrategy {
    private static final Constructor<ServletWebSocketHttpExchange> exchangeConstructor;
    private static final boolean undertow10Present;
    private static final String[] supportedVersions;
    private Set<WebSocketChannel> peerConnections = undertow10Present ? null : Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public String[] getSupportedVersions() {
        return supportedVersions;
    }

    @Override
    protected void upgradeInternal(ServerHttpRequest request, ServerHttpResponse response, String selectedProtocol, List<Extension> selectedExtensions, Endpoint endpoint) throws HandshakeFailureException {
        HttpServletRequest servletRequest = this.getHttpServletRequest(request);
        HttpServletResponse servletResponse = this.getHttpServletResponse(response);
        final ServletWebSocketHttpExchange exchange = this.createHttpExchange(servletRequest, servletResponse);
        exchange.putAttachment(HandshakeUtil.PATH_PARAMS, Collections.emptyMap());
        ServerWebSocketContainer wsContainer = (ServerWebSocketContainer)this.getContainer(servletRequest);
        final EndpointSessionHandler endpointSessionHandler = new EndpointSessionHandler(wsContainer);
        ConfiguredServerEndpoint configuredServerEndpoint = this.createConfiguredServerEndpoint(selectedProtocol, selectedExtensions, endpoint, servletRequest);
        final Handshake handshake = this.getHandshakeToUse(exchange, configuredServerEndpoint);
        exchange.upgradeChannel(new HttpUpgradeListener(){

            public void handleUpgrade(StreamConnection connection, HttpServerExchange serverExchange) {
                WebSocketChannel channel = handshake.createChannel((WebSocketHttpExchange)exchange, connection, exchange.getBufferPool());
                if (UndertowRequestUpgradeStrategy.this.peerConnections != null) {
                    UndertowRequestUpgradeStrategy.this.peerConnections.add(channel);
                }
                endpointSessionHandler.onConnect((WebSocketHttpExchange)exchange, channel);
            }
        });
        handshake.handshake((WebSocketHttpExchange)exchange);
    }

    private ServletWebSocketHttpExchange createHttpExchange(HttpServletRequest request, HttpServletResponse response) {
        try {
            return this.peerConnections != null ? exchangeConstructor.newInstance(request, response, this.peerConnections) : exchangeConstructor.newInstance(request, response);
        }
        catch (Exception ex) {
            throw new HandshakeFailureException("Failed to instantiate ServletWebSocketHttpExchange", ex);
        }
    }

    private Handshake getHandshakeToUse(ServletWebSocketHttpExchange exchange, ConfiguredServerEndpoint endpoint) {
        JsrHybi13Handshake handshake = new JsrHybi13Handshake(endpoint);
        if (handshake.matches((WebSocketHttpExchange)exchange)) {
            return handshake;
        }
        handshake = new JsrHybi08Handshake(endpoint);
        if (handshake.matches((WebSocketHttpExchange)exchange)) {
            return handshake;
        }
        handshake = new JsrHybi07Handshake(endpoint);
        if (handshake.matches((WebSocketHttpExchange)exchange)) {
            return handshake;
        }
        throw new HandshakeFailureException("No matching Undertow Handshake found: " + exchange.getRequestHeaders());
    }

    private ConfiguredServerEndpoint createConfiguredServerEndpoint(String selectedProtocol, List<Extension> selectedExtensions, Endpoint endpoint, HttpServletRequest servletRequest) {
        String path = servletRequest.getRequestURI();
        ServerEndpointRegistration endpointRegistration = new ServerEndpointRegistration(path, endpoint);
        endpointRegistration.setSubprotocols(Arrays.asList(selectedProtocol));
        endpointRegistration.setExtensions(selectedExtensions);
        return new ConfiguredServerEndpoint((ServerEndpointConfig)endpointRegistration, (InstanceFactory)new EndpointInstanceFactory(endpoint), null, new EncodingFactory(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap()));
    }

    static {
        Class<ServletWebSocketHttpExchange> type = ServletWebSocketHttpExchange.class;
        Class[] paramTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class, Set.class};
        if (ClassUtils.hasConstructor(type, (Class[])paramTypes)) {
            exchangeConstructor = ClassUtils.getConstructorIfAvailable(type, (Class[])paramTypes);
            undertow10Present = false;
        } else {
            paramTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
            exchangeConstructor = ClassUtils.getConstructorIfAvailable(type, (Class[])paramTypes);
            undertow10Present = true;
        }
        supportedVersions = new String[]{WebSocketVersion.V13.toHttpHeaderValue(), WebSocketVersion.V08.toHttpHeaderValue(), WebSocketVersion.V07.toHttpHeaderValue()};
    }

    private static class EndpointInstanceFactory
    implements InstanceFactory<Endpoint> {
        private final Endpoint endpoint;

        public EndpointInstanceFactory(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public InstanceHandle<Endpoint> createInstance() throws InstantiationException {
            return new InstanceHandle<Endpoint>(){

                public Endpoint getInstance() {
                    return EndpointInstanceFactory.this.endpoint;
                }

                public void release() {
                }
            };
        }
    }
}

