/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.EndpointWrapper;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusEndpoint;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.core.Version;
import org.glassfish.tyrus.core.WebSocketApplication;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.standard.AbstractStandardUpgradeStrategy;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;

public abstract class AbstractTyrusRequestUpgradeStrategy
extends AbstractStandardUpgradeStrategy {
    private static final Random random = new Random();
    private final ComponentProviderService componentProvider = ComponentProviderService.create();

    @Override
    public String[] getSupportedVersions() {
        return StringUtils.commaDelimitedListToStringArray((String)Version.getSupportedWireProtocolVersions());
    }

    @Override
    protected List<WebSocketExtension> getInstalledExtensions(WebSocketContainer container) {
        try {
            return super.getInstalledExtensions(container);
        }
        catch (UnsupportedOperationException ex) {
            return new ArrayList<WebSocketExtension>(0);
        }
    }

    @Override
    public void upgradeInternal(ServerHttpRequest request, ServerHttpResponse response, String selectedProtocol, List<Extension> extensions, Endpoint endpoint) throws HandshakeFailureException {
        HttpServletRequest servletRequest = this.getHttpServletRequest(request);
        HttpServletResponse servletResponse = this.getHttpServletResponse(response);
        TyrusServerContainer serverContainer = (TyrusServerContainer)this.getContainer(servletRequest);
        TyrusWebSocketEngine engine = (TyrusWebSocketEngine)serverContainer.getWebSocketEngine();
        Object tyrusEndpoint = null;
        try {
            String path = "/" + random.nextLong();
            tyrusEndpoint = this.createTyrusEndpoint(endpoint, path, selectedProtocol, extensions, (WebSocketContainer)serverContainer, engine);
            this.getEndpointHelper().register(engine, tyrusEndpoint);
            HttpHeaders headers = request.getHeaders();
            RequestContext requestContext = this.createRequestContext(servletRequest, path, headers);
            TyrusUpgradeResponse upgradeResponse = new TyrusUpgradeResponse();
            WebSocketEngine.UpgradeInfo upgradeInfo = engine.upgrade((UpgradeRequest)requestContext, (UpgradeResponse)upgradeResponse);
            switch (upgradeInfo.getStatus()) {
                case SUCCESS: {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Successful upgrade: " + upgradeResponse.getHeaders()));
                    }
                    this.handleSuccess(servletRequest, servletResponse, upgradeInfo, upgradeResponse);
                    break;
                }
                case HANDSHAKE_FAILED: {
                    throw new HandshakeFailureException("Unexpected handshake failure: " + request.getURI());
                }
                case NOT_APPLICABLE: {
                    throw new HandshakeFailureException("Unexpected handshake mapping failure: " + request.getURI());
                }
            }
            if (tyrusEndpoint != null) {
                this.getEndpointHelper().unregister(engine, tyrusEndpoint);
            }
        }
        catch (Exception ex) {
            try {
                throw new HandshakeFailureException("Error during handshake: " + request.getURI(), ex);
            }
            catch (Throwable throwable) {
                if (tyrusEndpoint != null) {
                    this.getEndpointHelper().unregister(engine, tyrusEndpoint);
                }
                throw throwable;
            }
        }
    }

    private Object createTyrusEndpoint(Endpoint endpoint, String endpointPath, String protocol, List<Extension> extensions, WebSocketContainer container, TyrusWebSocketEngine engine) throws DeploymentException {
        ServerEndpointRegistration endpointConfig = new ServerEndpointRegistration(endpointPath, endpoint);
        endpointConfig.setSubprotocols(Arrays.asList(protocol));
        endpointConfig.setExtensions(extensions);
        return this.getEndpointHelper().createdEndpoint(endpointConfig, this.componentProvider, container, engine);
    }

    private RequestContext createRequestContext(HttpServletRequest request, String endpointPath, HttpHeaders headers) {
        RequestContext context = RequestContext.Builder.create().requestURI(URI.create(endpointPath)).userPrincipal(request.getUserPrincipal()).secure(request.isSecure()).build();
        for (String header : headers.keySet()) {
            context.getHeaders().put(header, headers.get((Object)header));
        }
        return context;
    }

    protected abstract TyrusEndpointHelper getEndpointHelper();

    protected abstract void handleSuccess(HttpServletRequest var1, HttpServletResponse var2, WebSocketEngine.UpgradeInfo var3, TyrusUpgradeResponse var4) throws IOException, ServletException;

    protected static class Tyrus135EndpointHelper
    implements TyrusEndpointHelper {
        private static final Method registerMethod;

        protected Tyrus135EndpointHelper() {
        }

        @Override
        public Object createdEndpoint(ServerEndpointRegistration registration, ComponentProviderService provider, WebSocketContainer container, TyrusWebSocketEngine engine) throws DeploymentException {
            TyrusEndpointWrapper endpointWrapper = new TyrusEndpointWrapper(registration.getEndpoint(), (EndpointConfig)registration, provider, container, "/", registration.getConfigurator());
            return new TyrusEndpoint((EndpointWrapper)endpointWrapper);
        }

        @Override
        public void register(TyrusWebSocketEngine engine, Object endpoint) {
            try {
                registerMethod.invoke((Object)engine, endpoint);
            }
            catch (Exception ex) {
                throw new HandshakeFailureException("Failed to register " + endpoint, ex);
            }
        }

        @Override
        public void unregister(TyrusWebSocketEngine engine, Object endpoint) {
            engine.unregister((WebSocketApplication)((TyrusEndpoint)endpoint));
        }

        static {
            try {
                registerMethod = TyrusWebSocketEngine.class.getDeclaredMethod("register", WebSocketApplication.class);
                ReflectionUtils.makeAccessible((Method)registerMethod);
            }
            catch (Exception ex) {
                throw new IllegalStateException("No compatible Tyrus version found", ex);
            }
        }
    }

    protected static class Tyrus17EndpointHelper
    implements TyrusEndpointHelper {
        private static final Constructor<?> constructor;
        private static final Method registerMethod;
        private static final Method unRegisterMethod;

        protected Tyrus17EndpointHelper() {
        }

        private static Constructor<?> getEndpointConstructor() {
            for (Constructor<?> current : TyrusEndpointWrapper.class.getConstructors()) {
                Class<?>[] types = current.getParameterTypes();
                if (Endpoint.class != types[0] || EndpointConfig.class != types[1]) continue;
                return current;
            }
            throw new IllegalStateException("No compatible Tyrus version found");
        }

        @Override
        public Object createdEndpoint(ServerEndpointRegistration registration, ComponentProviderService provider, WebSocketContainer container, TyrusWebSocketEngine engine) throws DeploymentException {
            DirectFieldAccessor accessor = new DirectFieldAccessor((Object)engine);
            Object sessionListener = accessor.getPropertyValue("sessionListener");
            Object clusterContext = accessor.getPropertyValue("clusterContext");
            try {
                return constructor.newInstance(new Object[]{registration.getEndpoint(), registration, provider, container, "/", registration.getConfigurator(), sessionListener, clusterContext, null});
            }
            catch (Exception ex) {
                throw new HandshakeFailureException("Failed to register " + (Object)((Object)registration), ex);
            }
        }

        @Override
        public void register(TyrusWebSocketEngine engine, Object endpoint) {
            try {
                registerMethod.invoke((Object)engine, endpoint);
            }
            catch (Exception ex) {
                throw new HandshakeFailureException("Failed to register " + endpoint, ex);
            }
        }

        @Override
        public void unregister(TyrusWebSocketEngine engine, Object endpoint) {
            try {
                unRegisterMethod.invoke((Object)engine, endpoint);
            }
            catch (Exception ex) {
                throw new HandshakeFailureException("Failed to unregister " + endpoint, ex);
            }
        }

        static {
            try {
                constructor = Tyrus17EndpointHelper.getEndpointConstructor();
                registerMethod = TyrusWebSocketEngine.class.getDeclaredMethod("register", TyrusEndpointWrapper.class);
                unRegisterMethod = TyrusWebSocketEngine.class.getDeclaredMethod("unregister", TyrusEndpointWrapper.class);
                ReflectionUtils.makeAccessible((Method)registerMethod);
            }
            catch (Exception ex) {
                throw new IllegalStateException("No compatible Tyrus version found", ex);
            }
        }
    }

    protected static interface TyrusEndpointHelper {
        public Object createdEndpoint(ServerEndpointRegistration var1, ComponentProviderService var2, WebSocketContainer var3, TyrusWebSocketEngine var4) throws DeploymentException;

        public void register(TyrusWebSocketEngine var1, Object var2);

        public void unregister(TyrusWebSocketEngine var1, Object var2);
    }
}

