/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config.annotation;

import org.springframework.beans.factory.config.CustomScopeConfigurer;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.SimpSessionScope;
import org.springframework.messaging.simp.annotation.support.SimpAnnotationMethodMessageHandler;
import org.springframework.messaging.simp.broker.AbstractBrokerMessageHandler;
import org.springframework.messaging.simp.config.AbstractMessageBrokerConfiguration;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.WebSocketMessageBrokerStats;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebMvcStompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.handler.WebSocketHandlerDecoratorFactory;
import org.springframework.web.socket.messaging.DefaultSimpUserRegistry;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;
import org.springframework.web.socket.messaging.WebSocketAnnotationMethodMessageHandler;

public abstract class WebSocketMessageBrokerConfigurationSupport
extends AbstractMessageBrokerConfiguration {
    private WebSocketTransportRegistration transportRegistration;

    protected SimpAnnotationMethodMessageHandler createAnnotationMethodMessageHandler() {
        return new WebSocketAnnotationMethodMessageHandler((SubscribableChannel)this.clientInboundChannel(), (MessageChannel)this.clientOutboundChannel(), (SimpMessageSendingOperations)this.brokerMessagingTemplate());
    }

    protected SimpUserRegistry createLocalUserRegistry() {
        return new DefaultSimpUserRegistry();
    }

    @Bean
    public HandlerMapping stompWebSocketHandlerMapping() {
        WebSocketHandler handler = this.decorateWebSocketHandler(this.subProtocolWebSocketHandler());
        WebMvcStompEndpointRegistry registry = new WebMvcStompEndpointRegistry(handler, this.getTransportRegistration(), (TaskScheduler)this.messageBrokerTaskScheduler());
        registry.setApplicationContext(this.getApplicationContext());
        this.registerStompEndpoints(registry);
        return registry.getHandlerMapping();
    }

    @Bean
    public WebSocketHandler subProtocolWebSocketHandler() {
        return new SubProtocolWebSocketHandler((MessageChannel)this.clientInboundChannel(), (SubscribableChannel)this.clientOutboundChannel());
    }

    protected WebSocketHandler decorateWebSocketHandler(WebSocketHandler handler) {
        for (WebSocketHandlerDecoratorFactory factory : this.getTransportRegistration().getDecoratorFactories()) {
            handler = factory.decorate(handler);
        }
        return handler;
    }

    protected final WebSocketTransportRegistration getTransportRegistration() {
        if (this.transportRegistration == null) {
            this.transportRegistration = new WebSocketTransportRegistration();
            this.configureWebSocketTransport(this.transportRegistration);
        }
        return this.transportRegistration;
    }

    protected void configureWebSocketTransport(WebSocketTransportRegistration registry) {
    }

    protected abstract void registerStompEndpoints(StompEndpointRegistry var1);

    @Bean
    public static CustomScopeConfigurer webSocketScopeConfigurer() {
        CustomScopeConfigurer configurer = new CustomScopeConfigurer();
        configurer.addScope("websocket", (Scope)new SimpSessionScope());
        return configurer;
    }

    @Bean
    public WebSocketMessageBrokerStats webSocketMessageBrokerStats() {
        AbstractBrokerMessageHandler relayBean = this.stompBrokerRelayMessageHandler();
        StompBrokerRelayMessageHandler brokerRelay = relayBean instanceof StompBrokerRelayMessageHandler ? (StompBrokerRelayMessageHandler)relayBean : null;
        this.stompWebSocketHandlerMapping();
        WebSocketMessageBrokerStats stats = new WebSocketMessageBrokerStats();
        stats.setSubProtocolWebSocketHandler((SubProtocolWebSocketHandler)this.subProtocolWebSocketHandler());
        stats.setStompBrokerRelay(brokerRelay);
        stats.setInboundChannelExecutor(this.clientInboundChannelExecutor());
        stats.setOutboundChannelExecutor(this.clientOutboundChannelExecutor());
        stats.setSockJsTaskScheduler(this.messageBrokerTaskScheduler());
        return stats;
    }

    protected MappingJackson2MessageConverter createJacksonConverter() {
        MappingJackson2MessageConverter messageConverter = super.createJacksonConverter();
        messageConverter.setObjectMapper(Jackson2ObjectMapperBuilder.json().applicationContext(this.getApplicationContext()).build());
        return messageConverter;
    }
}

