/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.faces.webflow.JsfRuntimeInformation;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import org.w3c.dom.Element;

public class ResourcesBeanDefinitionParser
implements BeanDefinitionParser {
    static final String SERVLET_RESOURCE_HANDLER_BEAN_NAME = "jsfResourceRequestHandler";
    static final String PORTLET_RESOURCE_HANDLER_BEAN_NAME = "jsfPortletResourceRequestHandler";
    private static final boolean isRichFacesPresent = ClassUtils.isPresent((String)"org.richfaces.application.CoreConfiguration", (ClassLoader)ResourcesBeanDefinitionParser.class.getClassLoader());

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        new ServletRegistrar(element, parserContext).register();
        if (JsfRuntimeInformation.isSpringPortletPresent()) {
            new PortletRegistrar(element, parserContext).register();
        }
        return null;
    }

    private static class PortletRegistrar
    extends Registrar {
        public PortletRegistrar(Element element, ParserContext parserContext) {
            super(element, parserContext);
        }

        @Override
        public void register() {
            RootBeanDefinition beanDefinition = new RootBeanDefinition("org.springframework.faces.webflow.context.portlet.JsfResourceRequestHandler");
            beanDefinition.setSource(this.source);
            beanDefinition.setRole(2);
            this.parserContext.getRegistry().registerBeanDefinition(ResourcesBeanDefinitionParser.PORTLET_RESOURCE_HANDLER_BEAN_NAME, (BeanDefinition)beanDefinition);
        }
    }

    private static class ServletRegistrar
    extends Registrar {
        public ServletRegistrar(Element element, ParserContext parserContext) {
            super(element, parserContext);
        }

        @Override
        public void register() {
            this.registerHandlerAdapterIfNecessary();
            this.registerResourceHandler();
            this.registerHandlerMappings();
        }

        private void registerHandlerAdapterIfNecessary() {
            if (this.parserContext.getRegistry().containsBeanDefinition("org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter")) {
                return;
            }
            RootBeanDefinition beanDefinition = new RootBeanDefinition(HttpRequestHandlerAdapter.class);
            beanDefinition.setSource(this.source);
            beanDefinition.setRole(2);
            this.parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)beanDefinition);
        }

        private void registerResourceHandler() {
            RootBeanDefinition beanDefinition = new RootBeanDefinition("org.springframework.faces.webflow.JsfResourceRequestHandler");
            beanDefinition.setSource(this.source);
            beanDefinition.setRole(2);
            this.parserContext.getRegistry().registerBeanDefinition(ResourcesBeanDefinitionParser.SERVLET_RESOURCE_HANDLER_BEAN_NAME, (BeanDefinition)beanDefinition);
        }

        private void registerHandlerMappings() {
            ManagedMap urlMap = new ManagedMap();
            urlMap.put("/javax.faces.resource/**", ResourcesBeanDefinitionParser.SERVLET_RESOURCE_HANDLER_BEAN_NAME);
            if (isRichFacesPresent) {
                urlMap.put("/rfRes/**", ResourcesBeanDefinitionParser.SERVLET_RESOURCE_HANDLER_BEAN_NAME);
            }
            RootBeanDefinition beanDefinition = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
            beanDefinition.setSource(this.source);
            beanDefinition.setRole(2);
            beanDefinition.getPropertyValues().add("urlMap", (Object)urlMap);
            String order = this.element.getAttribute("order");
            beanDefinition.getPropertyValues().add("order", StringUtils.hasText((String)order) ? order : Integer.valueOf(0));
            this.parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)beanDefinition);
        }
    }

    private static abstract class Registrar {
        protected final Element element;
        protected final ParserContext parserContext;
        protected final Object source;

        public Registrar(Element element, ParserContext parserContext) {
            this.element = element;
            this.parserContext = parserContext;
            this.source = parserContext.extractSource((Object)element);
        }

        public abstract void register();
    }
}

