/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ResponseStateManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.faces.support.ResponseStateManagerWrapper;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class FlowResponseStateManager
extends ResponseStateManagerWrapper {
    private static final Log logger = LogFactory.getLog(FlowResponseStateManager.class);
    static final String FACES_VIEW_STATE = "facesViewState";
    private static final char[] STATE_FIELD_START = "<input type=\"hidden\" name=\"javax.faces.ViewState\" id=\"javax.faces.ViewState\" value=\"".toCharArray();
    private static final char[] STATE_FIELD_END = "\" />".toCharArray();
    private final ResponseStateManager wrapped;

    public FlowResponseStateManager(ResponseStateManager wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public ResponseStateManager getWrapped() {
        return this.wrapped;
    }

    @Override
    public void writeState(FacesContext facesContext, Object state) throws IOException {
        if (!JsfUtils.isFlowRequest()) {
            super.writeState(facesContext, state);
        } else {
            this.saveState(state);
            ResponseWriter writer = facesContext.getResponseWriter();
            this.writeViewStateField(facesContext, (Writer)writer);
            this.writeRenderKitIdField(facesContext, writer);
        }
    }

    @Override
    public Object getState(FacesContext facesContext, String viewId) {
        if (!JsfUtils.isFlowRequest()) {
            return super.getState(facesContext, viewId);
        }
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        Object state = requestContext.getViewScope().get(FACES_VIEW_STATE);
        if (state == null) {
            logger.debug((Object)"No matching view in view scope");
        }
        return state;
    }

    @Override
    public String getViewState(FacesContext facesContext, Object state) {
        if (!JsfUtils.isFlowRequest()) {
            return super.getViewState(facesContext, state);
        }
        this.saveState(state);
        return this.getFlowExecutionKey();
    }

    private void saveState(Object state) {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        requestContext.getViewScope().put(FACES_VIEW_STATE, state);
    }

    private String getFlowExecutionKey() {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        return requestContext.getFlowExecutionContext().getKey().toString();
    }

    private void writeViewStateField(FacesContext context, Writer writer) throws IOException {
        writer.write(STATE_FIELD_START);
        writer.write(this.getFlowExecutionKey());
        writer.write(STATE_FIELD_END);
    }

    private void writeRenderKitIdField(FacesContext context, ResponseWriter writer) throws IOException {
        String result = context.getApplication().getDefaultRenderKitId();
        if (result != null && !"HTML_BASIC".equals(result)) {
            writer.startElement("input", (UIComponent)context.getViewRoot());
            writer.writeAttribute("type", (Object)"hidden", "type");
            writer.writeAttribute("name", (Object)"javax.faces.RenderKitId", "name");
            writer.writeAttribute("value", (Object)result, "value");
            writer.endElement("input");
        }
    }

    static boolean hasState(RequestContext context) {
        return context != null && context.getViewScope().contains(FACES_VIEW_STATE);
    }
}

