/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow.context.portlet;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.VariableMapper;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.faces.webflow.context.portlet.PortletExternalContextImpl;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class PortletFacesContextImpl
extends FacesContext {
    private static final List<FacesMessage> NO_MESSAGES = Collections.unmodifiableList(Collections.emptyList());
    private static final Iterator<String> NO_CLIENT_IDS_WITH_MESSAGES = Collections.unmodifiableSet(Collections.emptySet()).iterator();
    private Application application;
    private ELContext elContext;
    private ExternalContext externalContext;
    private List<Message> messages;
    private FacesMessage.Severity maximumSeverity;
    private boolean released = false;
    private RenderKitFactory renderKitFactory;
    private boolean renderResponse = false;
    private boolean responseComplete = false;
    private ResponseStream responseStream;
    private ResponseWriter responseWriter;
    private UIViewRoot viewRoot;
    private Map<Object, Object> attributes;
    private PhaseId currentPhaseId;
    private ExceptionHandler exceptionHandler;
    private boolean validationFailed;
    private PartialViewContext partialViewContext;
    private boolean processingEvents;

    public PortletFacesContextImpl(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    public PortletFacesContextImpl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        this.application = JsfUtils.findFactory(ApplicationFactory.class).getApplication();
        this.renderKitFactory = JsfUtils.findFactory(RenderKitFactory.class);
        this.externalContext = new PortletExternalContextImpl(portletContext, portletRequest, portletResponse);
        this.exceptionHandler = JsfUtils.findFactory(ExceptionHandlerFactory.class).getExceptionHandler();
        FacesContext.setCurrentInstance((FacesContext)this);
    }

    public void release() {
        Method delegateMethod;
        this.assertNotReleased();
        if (this.externalContext != null && (delegateMethod = ClassUtils.getMethodIfAvailable(this.externalContext.getClass(), (String)"release", (Class[])new Class[0])) != null) {
            try {
                delegateMethod.invoke((Object)this.externalContext, new Object[0]);
            }
            catch (Exception e) {
                this.externalContext.log("Failed to release external context", (Throwable)e);
            }
            this.externalContext = null;
        }
        this.messages = null;
        this.maximumSeverity = null;
        this.application = null;
        this.responseStream = null;
        this.responseWriter = null;
        this.viewRoot = null;
        this.exceptionHandler = null;
        this.attributes = null;
        this.released = true;
        FacesContext.setCurrentInstance(null);
    }

    public ExternalContext getExternalContext() {
        this.assertNotReleased();
        return this.externalContext;
    }

    public Application getApplication() {
        this.assertNotReleased();
        return this.application;
    }

    public RenderKit getRenderKit() {
        if (this.getViewRoot() == null) {
            return null;
        }
        String renderKitId = this.getViewRoot().getRenderKitId();
        if (renderKitId == null) {
            return null;
        }
        return this.renderKitFactory.getRenderKit((FacesContext)this, renderKitId);
    }

    public boolean getRenderResponse() {
        this.assertNotReleased();
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        this.assertNotReleased();
        return this.responseComplete;
    }

    public ResponseStream getResponseStream() {
        this.assertNotReleased();
        return this.responseStream;
    }

    public void setResponseStream(ResponseStream responseStream) {
        this.assertNotReleased();
        if (responseStream == null) {
            throw new NullPointerException("responseStream");
        }
        this.responseStream = responseStream;
    }

    public ResponseWriter getResponseWriter() {
        this.assertNotReleased();
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.assertNotReleased();
        if (responseWriter == null) {
            throw new NullPointerException("responseWriter");
        }
        this.responseWriter = responseWriter;
    }

    public UIViewRoot getViewRoot() {
        this.assertNotReleased();
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot viewRoot) {
        this.assertNotReleased();
        if (viewRoot == null) {
            throw new NullPointerException("viewRoot");
        }
        this.viewRoot = viewRoot;
    }

    public void renderResponse() {
        this.assertNotReleased();
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.assertNotReleased();
        this.responseComplete = true;
    }

    public ELContext getELContext() {
        if (this.elContext == null) {
            this.createELContext();
        }
        return this.elContext;
    }

    private void createELContext() {
        this.elContext = new PortletELContextImpl(this.getApplication().getELResolver());
        this.elContext.putContext(FacesContext.class, (Object)FacesContext.getCurrentInstance());
        if (this.getViewRoot() != null) {
            this.elContext.setLocale(this.getViewRoot().getLocale());
        }
        this.fireContextCreated(this.getApplication().getELContextListeners());
    }

    private void fireContextCreated(ELContextListener[] listeners) {
        if (listeners.length > 0) {
            ELContextEvent event = new ELContextEvent(this.elContext);
            for (ELContextListener listener : listeners) {
                listener.contextCreated(event);
            }
        }
    }

    public void addMessage(String clientId, FacesMessage message) {
        this.assertNotReleased();
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        this.messages.add(new Message(clientId, message));
        this.recalculateMaximumSeverity(message.getSeverity());
    }

    private void recalculateMaximumSeverity(FacesMessage.Severity severity) {
        if (severity != null && (this.maximumSeverity == null || severity.compareTo((Object)this.maximumSeverity) > 0)) {
            this.maximumSeverity = severity;
        }
    }

    public FacesMessage.Severity getMaximumSeverity() {
        this.assertNotReleased();
        return this.maximumSeverity;
    }

    public Iterator<FacesMessage> getMessages() {
        return this.getMessageList().iterator();
    }

    public List<FacesMessage> getMessageList() {
        this.assertNotReleased();
        if (this.messages == null || this.messages.isEmpty()) {
            return NO_MESSAGES;
        }
        ArrayList<FacesMessage> messageList = new ArrayList<FacesMessage>();
        for (Message message : this.messages) {
            messageList.add(message.getFacesMessage());
        }
        return Collections.unmodifiableList(messageList);
    }

    public Iterator<FacesMessage> getMessages(String clientId) {
        return this.getMessageList(clientId).iterator();
    }

    public List<FacesMessage> getMessageList(String clientId) {
        this.assertNotReleased();
        if (this.messages == null || this.messages.isEmpty()) {
            return NO_MESSAGES;
        }
        ArrayList<FacesMessage> messageList = new ArrayList<FacesMessage>();
        for (Message message : this.messages) {
            if (!message.isForClientId(clientId)) continue;
            messageList.add(message.getFacesMessage());
        }
        return Collections.unmodifiableList(messageList);
    }

    public Iterator<String> getClientIdsWithMessages() {
        this.assertNotReleased();
        if (this.messages == null || this.messages.isEmpty()) {
            return NO_CLIENT_IDS_WITH_MESSAGES;
        }
        LinkedHashSet<String> clientIdsWithMessags = new LinkedHashSet<String>();
        for (Message message : this.messages) {
            clientIdsWithMessags.add(message.getClientId());
        }
        return Collections.unmodifiableSet(clientIdsWithMessags).iterator();
    }

    public Map<Object, Object> getAttributes() {
        this.assertNotReleased();
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>();
        }
        return this.attributes;
    }

    public PhaseId getCurrentPhaseId() {
        this.assertNotReleased();
        return this.currentPhaseId;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public boolean isPostback() {
        RenderKit renderKit = this.getRenderKit();
        if (renderKit == null) {
            String renderKitId = this.getApplication().getViewHandler().calculateRenderKitId((FacesContext)this);
            renderKit = JsfUtils.findFactory(RenderKitFactory.class).getRenderKit((FacesContext)this, renderKitId);
        }
        return renderKit.getResponseStateManager().isPostback((FacesContext)this);
    }

    public boolean isReleased() {
        return this.released;
    }

    public boolean isValidationFailed() {
        this.assertNotReleased();
        return this.validationFailed;
    }

    public void setCurrentPhaseId(PhaseId currentPhaseId) {
        this.assertNotReleased();
        this.currentPhaseId = currentPhaseId;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.assertNotReleased();
        this.exceptionHandler = exceptionHandler;
    }

    public void validationFailed() {
        this.assertNotReleased();
        this.validationFailed = true;
    }

    public PartialViewContext getPartialViewContext() {
        this.assertNotReleased();
        if (this.partialViewContext == null) {
            this.partialViewContext = JsfUtils.findFactory(PartialViewContextFactory.class).getPartialViewContext((FacesContext)this);
        }
        return this.partialViewContext;
    }

    public boolean isProcessingEvents() {
        this.assertNotReleased();
        return this.processingEvents;
    }

    public void setProcessingEvents(boolean processingEvents) {
        this.assertNotReleased();
        this.processingEvents = processingEvents;
    }

    public boolean isProjectStage(ProjectStage stage) {
        Assert.notNull((Object)stage, (String)"Stage must not be null");
        return stage.equals((Object)this.getApplication().getProjectStage());
    }

    private void assertNotReleased() {
        Assert.isTrue((!this.released ? 1 : 0) != 0, (String)"FacesContext already released");
    }

    private static class Message {
        private String clientId;
        private FacesMessage facesMessage;

        public Message(String clientId, FacesMessage facesMessage) {
            this.clientId = clientId;
            this.facesMessage = facesMessage;
        }

        public String getClientId() {
            return this.clientId;
        }

        public boolean isForClientId(String clientId) {
            return ObjectUtils.nullSafeEquals((Object)this.clientId, (Object)clientId);
        }

        public FacesMessage getFacesMessage() {
            return this.facesMessage;
        }
    }

    private class PortletELContextImpl
    extends ELContext {
        private FunctionMapper functionMapper;
        private VariableMapper variableMapper;
        private ELResolver resolver;

        public PortletELContextImpl(ELResolver resolver) {
            this.resolver = resolver;
        }

        public FunctionMapper getFunctionMapper() {
            return this.functionMapper;
        }

        public VariableMapper getVariableMapper() {
            return this.variableMapper;
        }

        public ELResolver getELResolver() {
            return this.resolver;
        }
    }
}

