/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.view.facelets.ResourceResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.util.ClassUtils;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class FlowResourceResolver
extends ResourceResolver {
    private static final List<String> RESOLVERS_CLASSES;
    private final ResourceResolver delegateResolver = this.createDelegateResolver();

    private ResourceResolver createDelegateResolver() {
        try {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            for (String resolverClass : RESOLVERS_CLASSES) {
                if (!ClassUtils.isPresent((String)resolverClass, (ClassLoader)classLoader)) continue;
                return (ResourceResolver)ClassUtils.forName((String)resolverClass, (ClassLoader)classLoader).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalStateException("Unable to find Default ResourceResolver");
    }

    public URL resolveUrl(String path) {
        if (!JsfUtils.isFlowRequest()) {
            return this.delegateResolver.resolveUrl(path);
        }
        try {
            RequestContext context = RequestContextHolder.getRequestContext();
            ApplicationContext flowContext = context.getActiveFlow().getApplicationContext();
            if (flowContext == null) {
                throw new IllegalStateException("A Flow ApplicationContext is required to resolve Flow View Resources");
            }
            ApplicationContext appContext = flowContext.getParent();
            Resource viewResource = appContext.getResource(path);
            if (viewResource.exists()) {
                return viewResource.getURL();
            }
            return this.delegateResolver.resolveUrl(path);
        }
        catch (IOException ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    static {
        ArrayList<String> resolvers = new ArrayList<String>();
        resolvers.add("com.sun.faces.facelets.impl.DefaultResourceResolver");
        resolvers.add("org.apache.myfaces.view.facelets.impl.DefaultResourceResolver");
        RESOLVERS_CLASSES = Collections.unmodifiableList(resolvers);
    }
}

