/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.io.IOException;
import javax.faces.FacesWrapper;
import javax.faces.application.StateManager;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import org.apache.myfaces.application.viewstate.StateCacheUtils;
import org.apache.myfaces.renderkit.MyfacesResponseStateManager;
import org.springframework.faces.webflow.FlowResponseStateManager;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class MyFacesFlowResponseStateManager
extends MyfacesResponseStateManager
implements FacesWrapper<ResponseStateManager> {
    private final ResponseStateManager wrapped;

    public MyFacesFlowResponseStateManager(FlowResponseStateManager wrapped) {
        this.wrapped = wrapped;
    }

    public ResponseStateManager getWrapped() {
        return this.wrapped;
    }

    private MyfacesResponseStateManager getWrappedMyfacesResponseStateManager() {
        return StateCacheUtils.getMyFacesResponseStateManager((ResponseStateManager)this.wrapped);
    }

    public boolean isWriteStateAfterRenderViewRequired(FacesContext facesContext) {
        MyfacesResponseStateManager wrapped = this.getWrappedMyfacesResponseStateManager();
        if (wrapped != null) {
            return wrapped.isWriteStateAfterRenderViewRequired(facesContext);
        }
        return super.isWriteStateAfterRenderViewRequired(facesContext);
    }

    public void saveState(FacesContext facesContext, Object state) {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        requestContext.getViewScope().put("facesViewState", state);
    }

    public void writeStateAsUrlParams(FacesContext facesContext, StateManager.SerializedView serializedview) {
        MyfacesResponseStateManager wrapped = this.getWrappedMyfacesResponseStateManager();
        if (wrapped != null) {
            wrapped.writeStateAsUrlParams(facesContext, serializedview);
        }
        super.writeStateAsUrlParams(facesContext, serializedview);
    }

    public Object getComponentStateToRestore(FacesContext context) {
        return this.getWrapped().getComponentStateToRestore(context);
    }

    public Object getState(FacesContext context, String viewId) {
        return this.getWrapped().getState(context, viewId);
    }

    public Object getTreeStructureToRestore(FacesContext context, String viewId) {
        return this.getWrapped().getTreeStructureToRestore(context, viewId);
    }

    public String getViewState(FacesContext context, Object state) {
        return this.getWrapped().getViewState(context, state);
    }

    public boolean isPostback(FacesContext context) {
        return this.getWrapped().isPostback(context);
    }

    public void writeState(FacesContext context, Object state) throws IOException {
        this.getWrapped().writeState(context, state);
    }

    @Deprecated
    public void writeState(FacesContext context, StateManager.SerializedView state) throws IOException {
        this.getWrapped().writeState(context, state);
    }
}

