/*
	Copyright (c) 2004-2010, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

if(!dojo._hasResource["dojox.gfx.matrix"]){dojo._hasResource["dojox.gfx.matrix"]=true;dojo.provide("dojox.gfx.matrix");(function(){var m=dojox.gfx.matrix;var _1={};m._degToRad=function(_2){return _1[_2]||(_1[_2]=(Math.PI*_2/180));};m._radToDeg=function(_3){return _3/Math.PI*180;};m.Matrix2D=function(_4){if(_4){if(typeof _4=="number"){this.xx=this.yy=_4;}else{if(_4 instanceof Array){if(_4.length>0){var _5=m.normalize(_4[0]);for(var i=1;i<_4.length;++i){var l=_5,r=dojox.gfx.matrix.normalize(_4[i]);_5=new m.Matrix2D();_5.xx=l.xx*r.xx+l.xy*r.yx;_5.xy=l.xx*r.xy+l.xy*r.yy;_5.yx=l.yx*r.xx+l.yy*r.yx;_5.yy=l.yx*r.xy+l.yy*r.yy;_5.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_5.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}dojo.mixin(this,_5);}}else{dojo.mixin(this,_4);}}}};dojo.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});dojo.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_6){var c=Math.cos(_6);var s=Math.sin(_6);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_7){return m.rotate(m._degToRad(_7));},skewX:function(_8){return new m.Matrix2D({xy:Math.tan(_8)});},skewXg:function(_9){return m.skewX(m._degToRad(_9));},skewY:function(_a){return new m.Matrix2D({yx:Math.tan(_a)});},skewYg:function(_b){return m.skewY(m._degToRad(_b));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_c){return (_c instanceof m.Matrix2D)?_c:new m.Matrix2D(_c);},clone:function(_d){var _e=new m.Matrix2D();for(var i in _d){if(typeof (_d[i])=="number"&&typeof (_e[i])=="number"&&_e[i]!=_d[i]){_e[i]=_d[i];}}return _e;},invert:function(_f){var M=m.normalize(_f),D=M.xx*M.yy-M.xy*M.yx,M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_10,x,y){return {x:_10.xx*x+_10.xy*y+_10.dx,y:_10.yx*x+_10.yy*y+_10.dy};},multiplyPoint:function(_11,a,b){var M=m.normalize(_11);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiply:function(_12){var M=m.normalize(_12);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_13,x,y){return m.multiply(m.translate(x,y),_13,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_14,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_14),a,b);}return m._sandwich(m.rotate(_14),a.x,a.y);},rotategAt:function(_15,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_15),a,b);}return m._sandwich(m.rotateg(_15),a.x,a.y);},skewXAt:function(_16,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_16),a,b);}return m._sandwich(m.skewX(_16),a.x,a.y);},skewXgAt:function(_17,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_17),a,b);}return m._sandwich(m.skewXg(_17),a.x,a.y);},skewYAt:function(_18,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_18),a,b);}return m._sandwich(m.skewY(_18),a.x,a.y);},skewYgAt:function(_19,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_19),a,b);}return m._sandwich(m.skewYg(_19),a.x,a.y);}});})();dojox.gfx.Matrix2D=dojox.gfx.matrix.Matrix2D;}if(!dojo._hasResource["dojox.gfx._base"]){dojo._hasResource["dojox.gfx._base"]=true;dojo.provide("dojox.gfx._base");(function(){var g=dojox.gfx,b=g._base;g._hasClass=function(_1a,_1b){var cls=_1a.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_1b+" ")>=0;};g._addClass=function(_1c,_1d){var cls=_1c.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_1d+" ")<0){_1c.setAttribute("className",cls+(cls?" ":"")+_1d);}};g._removeClass=function(_1e,_1f){var cls=_1e.getAttribute("className");if(cls){_1e.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_1f+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _20={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};if(dojo.isIE){dojo.doc.documentElement.style.fontSize="100%";}var div=dojo.doc.createElement("div");var s=div.style;s.position="absolute";s.left="-100px";s.top="0px";s.width="30px";s.height="1000em";s.borderWidth="0px";s.margin="0px";s.padding="0px";s.outline="none";s.lineHeight="1";s.overflow="hidden";dojo.body().appendChild(div);for(var p in _20){div.style.fontSize=p;_20[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}dojo.body().removeChild(div);div=null;return _20;};var _21=null;b._getCachedFontMeasurements=function(_22){if(_22||!_21){_21=b._getFontMeasurements();}return _21;};var _23=null,_24={};b._getTextBox=function(_25,_26,_27){var m,s,al=arguments.length;if(!_23){m=_23=dojo.doc.createElement("div");s=m.style;s.position="absolute";s.left="-10000px";s.top="0";dojo.body().appendChild(m);}else{m=_23;s=m.style;}m.className="";s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&_26){for(var i in _26){if(i in _24){continue;}s[i]=_26[i];}}if(al>2&&_27){m.className=_27;}m.innerHTML=_25;if(m["getBoundingClientRect"]){var bcr=m.getBoundingClientRect();return {l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{return dojo.marginBox(m);}};var _28=0;b._getUniqueId=function(){var id;do{id=dojo._scopeName+"Unique"+(++_28);}while(dojo.byId(id));return id;};})();dojo.mixin(dojox.gfx,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _29={};return function(_2a){var t=_29[_2a];if(t){return new t();}t=_29[_2a]=new Function;t.prototype=dojox.gfx["default"+_2a];return new t();};})(),normalizeColor:function(_2b){return (_2b instanceof dojo.Color)?_2b:new dojo.Color(_2b);},normalizeParameters:function(_2c,_2d){if(_2d){var _2e={};for(var x in _2c){if(x in _2d&&!(x in _2e)){_2c[x]=_2d[x];}}}return _2c;},makeParameters:function(_2f,_30){if(!_30){return dojo.delegate(_2f);}var _31={};for(var i in _2f){if(!(i in _31)){_31[i]=dojo.clone((i in _30)?_30[i]:_2f[i]);}}return _31;},formatNumber:function(x,_32){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _33=val.indexOf(".");if(_33>=0&&val.length-_33>5){val=x.toFixed(4);}}if(x<0){return val;}return _32?" "+val:val;},makeFontString:function(_34){return _34.style+" "+_34.variant+" "+_34.weight+" "+_34.size+" "+_34.family;},splitFontString:function(str){var _35=dojox.gfx.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}_35.style=t[0];_35.variant=t[1];_35.weight=t[2];var i=t[3].indexOf("/");_35.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){_35.family=t.slice(j).join(" ");}}while(false);return _35;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return dojox.gfx._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*dojox.gfx.px_in_pt();},px2pt:function(len){return len/dojox.gfx.px_in_pt();},normalizedLength:function(len){if(len.length==0){return 0;}if(len.length>2){var _36=dojox.gfx.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_36;case "in":return val*72*_36;case "pc":return val*12*_36;case "mm":return val*dojox.gfx.mm_in_pt*_36;case "cm":return val*dojox.gfx.cm_in_pt*_36;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-Za-z])|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,equalSources:function(a,b){return a&&b&&a==b;}});}if(!dojo._hasResource["dojox.gfx"]){dojo._hasResource["dojox.gfx"]=true;dojo.provide("dojox.gfx");dojo.loadInit(function(){var gfx=dojo.getObject("dojox.gfx",true),sl,_37,_38;if(!gfx.renderer){if(dojo.config.forceGfxRenderer){dojox.gfx.renderer=dojo.config.forceGfxRenderer;return;}var _39=(typeof dojo.config.gfxRenderer=="string"?dojo.config.gfxRenderer:"svg,vml,silverlight,canvas").split(",");var ua=navigator.userAgent,_3a=0,_3b=0;if(dojo.isSafari>=3){if(ua.indexOf("iPhone")>=0||ua.indexOf("iPod")>=0){_38=ua.match(/Version\/(\d(\.\d)?(\.\d)?)\sMobile\/([^\s]*)\s?/);if(_38){_3a=parseInt(_38[4].substr(0,3),16);}}}if(dojo.isWebKit){if(!_3a){_38=ua.match(/Android\s+(\d+\.\d+)/);if(_38){_3b=parseFloat(_38[1]);}}}for(var i=0;i<_39.length;++i){switch(_39[i]){case "svg":if(!dojo.isIE&&(!_3a||_3a>=1521)&&!_3b&&!dojo.isAIR){dojox.gfx.renderer="svg";}break;case "vml":if(dojo.isIE){dojox.gfx.renderer="vml";}break;case "silverlight":try{if(dojo.isIE){sl=new ActiveXObject("AgControl.AgControl");if(sl&&sl.IsVersionSupported("1.0")){_37=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_37=true;}}}catch(e){_37=false;}finally{sl=null;}if(_37){dojox.gfx.renderer="silverlight";}break;case "canvas":if(!dojo.isIE){dojox.gfx.renderer="canvas";}break;}if(dojox.gfx.renderer){break;}}if(dojo.config.isDebug){}}});dojo.requireIf(dojox.gfx.renderer=="svg","dojox.gfx.svg");dojo.requireIf(dojox.gfx.renderer=="vml","dojox.gfx.vml");dojo.requireIf(dojox.gfx.renderer=="silverlight","dojox.gfx.silverlight");dojo.requireIf(dojox.gfx.renderer=="canvas","dojox.gfx.canvas");}if(!dojo._hasResource["dojox.lang.functional.lambda"]){dojo._hasResource["dojox.lang.functional.lambda"]=true;dojo.provide("dojox.lang.functional.lambda");(function(){var df=dojox.lang.functional,_3c={};var _3d="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _3e=function(s){var _3f=[],_40=_3d.call(s,/\s*->\s*/m);if(_40.length>1){while(_40.length){s=_40.pop();_3f=_40.pop().split(/\s*,\s*|\s+/m);if(_40.length){_40.push("(function("+_3f+"){return ("+s+")})");}}}else{if(s.match(/\b_\b/)){_3f=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){_3f.push("$1");s="$1"+s;}if(r){_3f.push("$2");s=s+"$2";}}else{var _41=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};dojo.forEach(_41,function(v){if(!(v in t)){_3f.push(v);t[v]=1;}});}}}return {args:_3f,body:s};};var _42=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};dojo.mixin(df,{rawLambda:function(s){return _3e(s);},buildLambda:function(s){s=_3e(s);return "function("+s.args.join(",")+"){return ("+s.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _42(s);}if(s in _3c){return _3c[s];}s=_3e(s);return _3c[s]=new Function(s.args,"return ("+s.body+");");},clearLambdaCache:function(){_3c={};}});})();}if(!dojo._hasResource["dojox.lang.functional.array"]){dojo._hasResource["dojox.lang.functional.array"]=true;dojo.provide("dojox.lang.functional.array");(function(){var d=dojo,df=dojox.lang.functional,_43={};d.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t=[],v,i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _43)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _43)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,i;if(d.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _43)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _43)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _43)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});})();}if(!dojo._hasResource["dojox.lang.functional.object"]){dojo._hasResource["dojox.lang.functional.object"]=true;dojo.provide("dojox.lang.functional.object");(function(){var d=dojo,df=dojox.lang.functional,_44={};d.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in _44)){t.push(i);}}return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in _44)){t.push(obj[i]);}}return t;},filterIn:function(obj,f,o){o=o||d.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in _44)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}return t;},forIn:function(obj,f,o){o=o||d.global;f=df.lambda(f);for(var i in obj){if(!(i in _44)){f.call(o,obj[i],i,obj);}}return o;},mapIn:function(obj,f,o){o=o||d.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in _44)){t[i]=f.call(o,obj[i],i,obj);}}return t;}});})();}if(!dojo._hasResource["dojox.lang.functional"]){dojo._hasResource["dojox.lang.functional"]=true;dojo.provide("dojox.lang.functional");}if(!dojo._hasResource["dojox.lang.functional.fold"]){dojo._hasResource["dojox.lang.functional.fold"]=true;dojo.provide("dojox.lang.functional.fold");(function(){var d=dojo,df=dojox.lang.functional,_45={};d.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _45)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var z,i,n;if(d.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _46=true;for(i in a){if(!(i in _45)){if(_46){z=a[i];_46=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||d.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});})();}if(!dojo._hasResource["dojox.lang.functional.reversed"]){dojo._hasResource["dojox.lang.functional.reversed"]=true;dojo.provide("dojox.lang.functional.reversed");(function(){var d=dojo,df=dojox.lang.functional;d.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});})();}if(!dojo._hasResource["dojo.colors"]){dojo._hasResource["dojo.colors"]=true;dojo.provide("dojo.colors");(function(){var _47=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=function(_48,obj){var m=_48.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=dojo.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return dojo.colorFromArray(a,obj);}return dojo.colorFromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_47(m1,m2,H+1/3)*256,_47(m1,m2,H)*256,_47(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return dojo.colorFromArray(a,obj);}}return null;};var _49=function(c,low,_4a){c=Number(c);return isNaN(c)?_4a:c<low?low:c>_4a?_4a:c;};dojo.Color.prototype.sanitize=function(){var t=this;t.r=Math.round(_49(t.r,0,255));t.g=Math.round(_49(t.g,0,255));t.b=Math.round(_49(t.b,0,255));t.a=_49(t.a,0,1);return this;};})();dojo.colors.makeGrey=function(g,a){return dojo.colorFromArray([g,g,g,a]);};dojo.mixin(dojo.Color.named,{aliceblue:[240,248,255],antiquewhite:[250,235,215],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],blanchedalmond:[255,235,205],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],oldlace:[253,245,230],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],thistle:[216,191,216],tomato:[255,99,71],transparent:[0,0,0,0],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],whitesmoke:[245,245,245],yellowgreen:[154,205,50]});}if(!dojo._hasResource["dojox.color._base"]){dojo._hasResource["dojox.color._base"]=true;dojo.provide("dojox.color._base");dojox.color.Color=dojo.Color;dojox.color.blend=dojo.blendColors;dojox.color.fromRgb=dojo.colorFromRgb;dojox.color.fromHex=dojo.colorFromHex;dojox.color.fromArray=dojo.colorFromArray;dojox.color.fromString=dojo.colorFromString;dojox.color.greyscale=dojo.colors.makeGrey;dojo.mixin(dojox.color,{fromCmy:function(_4b,_4c,_4d){if(dojo.isArray(_4b)){_4c=_4b[1],_4d=_4b[2],_4b=_4b[0];}else{if(dojo.isObject(_4b)){_4c=_4b.m,_4d=_4b.y,_4b=_4b.c;}}_4b/=100,_4c/=100,_4d/=100;var r=1-_4b,g=1-_4c,b=1-_4d;return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromCmyk:function(_4e,_4f,_50,_51){if(dojo.isArray(_4e)){_4f=_4e[1],_50=_4e[2],_51=_4e[3],_4e=_4e[0];}else{if(dojo.isObject(_4e)){_4f=_4e.m,_50=_4e.y,_51=_4e.b,_4e=_4e.c;}}_4e/=100,_4f/=100,_50/=100,_51/=100;var r,g,b;r=1-Math.min(1,_4e*(1-_51)+_51);g=1-Math.min(1,_4f*(1-_51)+_51);b=1-Math.min(1,_50*(1-_51)+_51);return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsl:function(hue,_52,_53){if(dojo.isArray(hue)){_52=hue[1],_53=hue[2],hue=hue[0];}else{if(dojo.isObject(hue)){_52=hue.s,_53=hue.l,hue=hue.h;}}_52/=100;_53/=100;while(hue<0){hue+=360;}while(hue>=360){hue-=360;}var r,g,b;if(hue<120){r=(120-hue)/60,g=hue/60,b=0;}else{if(hue<240){r=0,g=(240-hue)/60,b=(hue-120)/60;}else{r=(hue-240)/60,g=0,b=(360-hue)/60;}}r=2*_52*Math.min(r,1)+(1-_52);g=2*_52*Math.min(g,1)+(1-_52);b=2*_52*Math.min(b,1)+(1-_52);if(_53<0.5){r*=_53,g*=_53,b*=_53;}else{r=(1-_53)*r+2*_53-1;g=(1-_53)*g+2*_53-1;b=(1-_53)*b+2*_53-1;}return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsv:function(hue,_54,_55){if(dojo.isArray(hue)){_54=hue[1],_55=hue[2],hue=hue[0];}else{if(dojo.isObject(hue)){_54=hue.s,_55=hue.v,hue=hue.h;}}if(hue==360){hue=0;}_54/=100;_55/=100;var r,g,b;if(_54==0){r=_55,b=_55,g=_55;}else{var _56=hue/60,i=Math.floor(_56),f=_56-i;var p=_55*(1-_54);var q=_55*(1-(_54*f));var t=_55*(1-(_54*(1-f)));switch(i){case 0:r=_55,g=t,b=p;break;case 1:r=q,g=_55,b=p;break;case 2:r=p,g=_55,b=t;break;case 3:r=p,g=q,b=_55;break;case 4:r=t,g=p,b=_55;break;case 5:r=_55,g=p,b=q;break;}}return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});}});dojo.extend(dojox.color.Color,{toCmy:function(){var _57=1-(this.r/255),_58=1-(this.g/255),_59=1-(this.b/255);return {c:Math.round(_57*100),m:Math.round(_58*100),y:Math.round(_59*100)};},toCmyk:function(){var _5a,_5b,_5c,_5d;var r=this.r/255,g=this.g/255,b=this.b/255;_5d=Math.min(1-r,1-g,1-b);_5a=(1-r-_5d)/(1-_5d);_5b=(1-g-_5d)/(1-_5d);_5c=(1-b-_5d)/(1-_5d);return {c:Math.round(_5a*100),m:Math.round(_5b*100),y:Math.round(_5c*100),b:Math.round(_5d*100)};},toHsl:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _5e=max-min;var h=0,s=0,l=(min+max)/2;if(l>0&&l<1){s=_5e/((l<0.5)?(2*l):(2-2*l));}if(_5e>0){if(max==r&&max!=g){h+=(g-b)/_5e;}if(max==g&&max!=b){h+=(2+(b-r)/_5e);}if(max==b&&max!=r){h+=(4+(r-g)/_5e);}h*=60;}return {h:h,s:Math.round(s*100),l:Math.round(l*100)};},toHsv:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _5f=max-min;var h=null,s=(max==0)?0:(_5f/max);if(s==0){h=0;}else{if(r==max){h=60*(g-b)/_5f;}else{if(g==max){h=120+60*(b-r)/_5f;}else{h=240+60*(r-g)/_5f;}}if(h<0){h+=360;}}return {h:h,s:Math.round(s*100),v:Math.round(max*100)};}});}if(!dojo._hasResource["dojox.color"]){dojo._hasResource["dojox.color"]=true;dojo.provide("dojox.color");}if(!dojo._hasResource["dojox.color.Palette"]){dojo._hasResource["dojox.color.Palette"]=true;dojo.provide("dojox.color.Palette");(function(){var dxc=dojox.color;dxc.Palette=function(_60){this.colors=[];if(_60 instanceof dojox.color.Palette){this.colors=_60.colors.slice(0);}else{if(_60 instanceof dojox.color.Color){this.colors=[null,null,_60,null,null];}else{if(dojo.isArray(_60)){this.colors=dojo.map(_60.slice(0),function(_61){if(dojo.isString(_61)){return new dojox.color.Color(_61);}return _61;});}else{if(dojo.isString(_60)){this.colors=[null,null,new dojox.color.Color(_60),null,null];}}}}};function _62(p,_63,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(_64){var r=(_63=="dr")?_64.r+val:_64.r,g=(_63=="dg")?_64.g+val:_64.g,b=(_63=="db")?_64.b+val:_64.b,a=(_63=="da")?_64.a+val:_64.a;ret.colors.push(new dojox.color.Color({r:Math.min(255,Math.max(0,r)),g:Math.min(255,Math.max(0,g)),b:Math.min(255,Math.max(0,b)),a:Math.min(1,Math.max(0,a))}));});return ret;};function _65(p,_66,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(_67){var o=_67.toCmy(),c=(_66=="dc")?o.c+val:o.c,m=(_66=="dm")?o.m+val:o.m,y=(_66=="dy")?o.y+val:o.y;ret.colors.push(dojox.color.fromCmy(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y))));});return ret;};function _68(p,_69,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(_6a){var o=_6a.toCmyk(),c=(_69=="dc")?o.c+val:o.c,m=(_69=="dm")?o.m+val:o.m,y=(_69=="dy")?o.y+val:o.y,k=(_69=="dk")?o.b+val:o.b;ret.colors.push(dojox.color.fromCmyk(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y)),Math.min(100,Math.max(0,k))));});return ret;};function _6b(p,_6c,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(_6d){var o=_6d.toHsl(),h=(_6c=="dh")?o.h+val:o.h,s=(_6c=="ds")?o.s+val:o.s,l=(_6c=="dl")?o.l+val:o.l;ret.colors.push(dojox.color.fromHsl(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,l))));});return ret;};function _6e(p,_6f,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(_70){var o=_70.toHsv(),h=(_6f=="dh")?o.h+val:o.h,s=(_6f=="ds")?o.s+val:o.s,v=(_6f=="dv")?o.v+val:o.v;ret.colors.push(dojox.color.fromHsv(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,v))));});return ret;};function _71(val,low,_72){return _72-((_72-val)*((_72-low)/_72));};dojo.extend(dxc.Palette,{transform:function(_73){var fn=_62;if(_73.use){var use=_73.use.toLowerCase();if(use.indexOf("hs")==0){if(use.charAt(2)=="l"){fn=_6b;}else{fn=_6e;}}else{if(use.indexOf("cmy")==0){if(use.charAt(3)=="k"){fn=_68;}else{fn=_65;}}}}else{if("dc" in _73||"dm" in _73||"dy" in _73){if("dk" in _73){fn=_68;}else{fn=_65;}}else{if("dh" in _73||"ds" in _73){if("dv" in _73){fn=_6e;}else{fn=_6b;}}}}var _74=this;for(var p in _73){if(p=="use"){continue;}_74=fn(_74,p,_73[p]);}return _74;},clone:function(){return new dxc.Palette(this);}});dojo.mixin(dxc.Palette,{generators:{analogous:function(_75){var _76=_75.high||60,low=_75.low||18,_77=dojo.isString(_75.base)?new dojox.color.Color(_75.base):_75.base,hsv=_77.toHsv();var h=[(hsv.h+low+360)%360,(hsv.h+Math.round(low/2)+360)%360,hsv.h,(hsv.h-Math.round(_76/2)+360)%360,(hsv.h-_76+360)%360];var s1=Math.max(10,(hsv.s<=95)?hsv.s+5:(100-(hsv.s-95))),s2=(hsv.s>1)?hsv.s-1:21-hsv.s,v1=(hsv.v>=92)?hsv.v-9:Math.max(hsv.v+9,20),v2=(hsv.v<=90)?Math.max(hsv.v+5,20):(95+Math.ceil((hsv.v-90)/2)),s=[s1,s2,hsv.s,s1,s1],v=[v1,v2,hsv.v,v1,v2];return new dxc.Palette(dojo.map(h,function(hue,i){return dojox.color.fromHsv(hue,s[i],v[i]);}));},monochromatic:function(_78){var _79=dojo.isString(_78.base)?new dojox.color.Color(_78.base):_78.base,hsv=_79.toHsv();var s1=(hsv.s-30>9)?hsv.s-30:hsv.s+30,s2=hsv.s,v1=_71(hsv.v,20,100),v2=(hsv.v-20>20)?hsv.v-20:hsv.v+60,v3=(hsv.v-50>20)?hsv.v-50:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(hsv.h,s1,v1),dojox.color.fromHsv(hsv.h,s2,v3),_79,dojox.color.fromHsv(hsv.h,s1,v3),dojox.color.fromHsv(hsv.h,s2,v2)]);},triadic:function(_7a){var _7b=dojo.isString(_7a.base)?new dojox.color.Color(_7a.base):_7a.base,hsv=_7b.toHsv();var h1=(hsv.h+57+360)%360,h2=(hsv.h-157+360)%360,s1=(hsv.s>20)?hsv.s-10:hsv.s+10,s2=(hsv.s>90)?hsv.s-10:hsv.s+10,s3=(hsv.s>95)?hsv.s-5:hsv.s+5,v1=(hsv.v-20>20)?hsv.v-20:hsv.v+20,v2=(hsv.v-30>20)?hsv.v-30:hsv.v+30,v3=(hsv.v-30>70)?hsv.v-30:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(h1,s1,hsv.v),dojox.color.fromHsv(hsv.h,s2,v2),_7b,dojox.color.fromHsv(h2,s2,v1),dojox.color.fromHsv(h2,s3,v3)]);},complementary:function(_7c){var _7d=dojo.isString(_7c.base)?new dojox.color.Color(_7c.base):_7c.base,hsv=_7d.toHsv();var h1=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,s1=Math.max(hsv.s-10,0),s2=_71(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(hsv.h,s1,v1),dojox.color.fromHsv(hsv.h,s2,v2),_7d,dojox.color.fromHsv(h1,s3,v2),dojox.color.fromHsv(h1,hsv.s,hsv.v)]);},splitComplementary:function(_7e){var _7f=dojo.isString(_7e.base)?new dojox.color.Color(_7e.base):_7e.base,_80=_7e.da||30,hsv=_7f.toHsv();var _81=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,h1=(_81-_80+360)%360,h2=(_81+_80)%360,s1=Math.max(hsv.s-10,0),s2=_71(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(h1,s1,v1),dojox.color.fromHsv(h1,s2,v2),_7f,dojox.color.fromHsv(h2,s3,v2),dojox.color.fromHsv(h2,hsv.s,hsv.v)]);},compound:function(_82){var _83=dojo.isString(_82.base)?new dojox.color.Color(_82.base):_82.base,hsv=_83.toHsv();var h1=((hsv.h*2)+18<360)?(hsv.h*2)+18:Math.floor(hsv.h/2)-18,h2=((hsv.h*2)+120<360)?(hsv.h*2)+120:Math.floor(hsv.h/2)-120,h3=((hsv.h*2)+99<360)?(hsv.h*2)+99:Math.floor(hsv.h/2)-99,s1=(hsv.s-40>10)?hsv.s-40:hsv.s+40,s2=(hsv.s-10>80)?hsv.s-10:hsv.s+10,s3=(hsv.s-25>10)?hsv.s-25:hsv.s+25,v1=(hsv.v-40>10)?hsv.v-40:hsv.v+40,v2=(hsv.v-20>80)?hsv.v-20:hsv.v+20,v3=Math.max(hsv.v,20);return new dxc.Palette([dojox.color.fromHsv(h1,s1,v1),dojox.color.fromHsv(h1,s2,v2),_83,dojox.color.fromHsv(h2,s3,v3),dojox.color.fromHsv(h3,s2,v2)]);},shades:function(_84){var _85=dojo.isString(_84.base)?new dojox.color.Color(_84.base):_84.base,hsv=_85.toHsv();var s=(hsv.s==100&&hsv.v==0)?0:hsv.s,v1=(hsv.v-50>20)?hsv.v-50:hsv.v+30,v2=(hsv.v-25>=20)?hsv.v-25:hsv.v+55,v3=(hsv.v-75>=20)?hsv.v-75:hsv.v+5,v4=Math.max(hsv.v-10,20);return new dxc.Palette([new dojox.color.fromHsv(hsv.h,s,v1),new dojox.color.fromHsv(hsv.h,s,v2),_85,new dojox.color.fromHsv(hsv.h,s,v3),new dojox.color.fromHsv(hsv.h,s,v4)]);}},generate:function(_86,_87){if(dojo.isFunction(_87)){return _87({base:_86});}else{if(dxc.Palette.generators[_87]){return dxc.Palette.generators[_87]({base:_86});}}throw new Error("dojox.color.Palette.generate: the specified generator ('"+_87+"') does not exist.");}});})();}if(!dojo._hasResource["dojox.lang.utils"]){dojo._hasResource["dojox.lang.utils"]=true;dojo.provide("dojox.lang.utils");(function(){var _88={},du=dojox.lang.utils,_89=Object.prototype.toString;var _8a=function(o){if(o){switch(_89.call(o)){case "[object Array]":return o.slice(0);case "[object Object]":return dojo.delegate(o);}}return o;};dojo.mixin(du,{coerceType:function(_8b,_8c){switch(typeof _8b){case "number":return Number(eval("("+_8c+")"));case "string":return String(_8c);case "boolean":return Boolean(eval("("+_8c+")"));}return eval("("+_8c+")");},updateWithObject:function(_8d,_8e,_8f){if(!_8e){return _8d;}for(var x in _8d){if(x in _8e&&!(x in _88)){var t=_8d[x];if(t&&typeof t=="object"){du.updateWithObject(t,_8e[x],_8f);}else{_8d[x]=_8f?du.coerceType(t,_8e[x]):_8a(_8e[x]);}}}return _8d;},updateWithPattern:function(_90,_91,_92,_93){if(!_91||!_92){return _90;}for(var x in _92){if(x in _91&&!(x in _88)){_90[x]=_93?du.coerceType(_92[x],_91[x]):_8a(_91[x]);}}return _90;},merge:function(_94,_95){if(_95){var _96=_89.call(_94),_97=_89.call(_95),t,i,l,m;switch(_97){case "[object Array]":if(_97==_96){t=new Array(Math.max(_94.length,_95.length));for(i=0,l=t.length;i<l;++i){t[i]=du.merge(_94[i],_95[i]);}return t;}return _95.slice(0);case "[object Object]":if(_97==_96&&_94){t=dojo.delegate(_94);for(i in _95){if(i in _94){l=_94[i];m=_95[i];if(m!==l){t[i]=du.merge(l,m);}}else{t[i]=dojo.clone(_95[i]);}}return t;}return dojo.clone(_95);}}return _95;}});})();}if(!dojo._hasResource["dojox.gfx.gradutils"]){dojo._hasResource["dojox.gfx.gradutils"]=true;dojo.provide("dojox.gfx.gradutils");(function(){var d=dojo,m=dojox.gfx.matrix,C=d.Color;function _98(o,c){if(o<=0){return c[0].color;}var len=c.length;if(o>=1){return c[len-1].color;}for(var i=0;i<len;++i){var _99=c[i];if(_99.offset>=o){if(i){var _9a=c[i-1];return d.blendColors(new C(_9a.color),new C(_99.color),(o-_9a.offset)/(_99.offset-_9a.offset));}return _99.color;}}return c[len-1].color;};dojox.gfx.gradutils.getColor=function(_9b,pt){var o;if(_9b){switch(_9b.type){case "linear":var _9c=Math.atan2(_9b.y2-_9b.y1,_9b.x2-_9b.x1),_9d=m.rotate(-_9c),_9e=m.project(_9b.x2-_9b.x1,_9b.y2-_9b.y1),p=m.multiplyPoint(_9e,pt),pf1=m.multiplyPoint(_9e,_9b.x1,_9b.y1),pf2=m.multiplyPoint(_9e,_9b.x2,_9b.y2),_9f=m.multiplyPoint(_9d,pf2.x-pf1.x,pf2.y-pf1.y).x,o=m.multiplyPoint(_9d,p.x-pf1.x,p.y-pf1.y).x/_9f;break;case "radial":var dx=pt.x-_9b.cx,dy=pt.y-_9b.cy,o=Math.sqrt(dx*dx+dy*dy)/_9b.r;break;}return _98(o,_9b.colors);}return new C(_9b||[0,0,0,0]);};dojox.gfx.gradutils.reverse=function(_a0){if(_a0){switch(_a0.type){case "linear":case "radial":_a0=dojo.delegate(_a0);if(_a0.colors){var c=_a0.colors,l=c.length,i=0,_a1,n=_a0.colors=new Array(c.length);for(;i<l;++i){_a1=c[i];n[i]={offset:1-_a1.offset,color:_a1.color};}n.sort(function(a,b){return a.offset-b.offset;});}break;}}return _a0;};})();}if(!dojo._hasResource["dojox.charting.Theme"]){dojo._hasResource["dojox.charting.Theme"]=true;dojo.provide("dojox.charting.Theme");dojo.declare("dojox.charting.Theme",null,{shapeSpaces:{shape:1,shapeX:1,shapeY:1},constructor:function(_a2){_a2=_a2||{};var def=dojox.charting.Theme.defaultTheme;dojo.forEach(["chart","plotarea","axis","series","marker"],function(_a3){this[_a3]=dojo.delegate(def[_a3],_a2[_a3]);},this);if(_a2.seriesThemes&&_a2.seriesThemes.length){this.colors=null;this.seriesThemes=_a2.seriesThemes.slice(0);}else{this.seriesThemes=null;this.colors=(_a2.colors||dojox.charting.Theme.defaultColors).slice(0);}this.markerThemes=null;if(_a2.markerThemes&&_a2.markerThemes.length){this.markerThemes=_a2.markerThemes.slice(0);}this.markers=dojo.delegate(dojox.charting.Theme.defaultMarkers,_a2.markers);this.noGradConv=_a2.noGradConv;this.noRadialConv=_a2.noRadialConv;if(_a2.reverseFills){this.reverseFills();}this._current=0;this._buildMarkerArray();},clone:function(){var _a4=new dojox.charting.Theme({chart:this.chart,plotarea:this.plotarea,axis:this.axis,series:this.series,marker:this.marker,colors:this.colors,markers:this.markers,seriesThemes:this.seriesThemes,markerThemes:this.markerThemes,noGradConv:this.noGradConv,noRadialConv:this.noRadialConv});dojo.forEach(["clone","clear","next","skip","addMixin","post","getTick"],function(_a5){if(this.hasOwnProperty(_a5)){_a4[_a5]=this[_a5];}},this);return _a4;},clear:function(){this._current=0;},next:function(_a6,_a7,_a8){var _a9=dojox.lang.utils.merge,_aa,_ab;if(this.colors){_aa=dojo.delegate(this.series);_ab=dojo.delegate(this.marker);var _ac=new dojo.Color(this.colors[this._current%this.colors.length]),old;if(_aa.stroke&&_aa.stroke.color){_aa.stroke=dojo.delegate(_aa.stroke);old=new dojo.Color(_aa.stroke.color);_aa.stroke.color=new dojo.Color(_ac);_aa.stroke.color.a=old.a;}else{_aa.stroke={color:_ac};}if(_ab.stroke&&_ab.stroke.color){_ab.stroke=dojo.delegate(_ab.stroke);old=new dojo.Color(_ab.stroke.color);_ab.stroke.color=new dojo.Color(_ac);_ab.stroke.color.a=old.a;}else{_ab.stroke={color:_ac};}if(!_aa.fill||_aa.fill.type){_aa.fill=_ac;}else{old=new dojo.Color(_aa.fill);_aa.fill=new dojo.Color(_ac);_aa.fill.a=old.a;}if(!_ab.fill||_ab.fill.type){_ab.fill=_ac;}else{old=new dojo.Color(_ab.fill);_ab.fill=new dojo.Color(_ac);_ab.fill.a=old.a;}}else{_aa=this.seriesThemes?_a9(this.series,this.seriesThemes[this._current%this.seriesThemes.length]):this.series;_ab=this.markerThemes?_a9(this.marker,this.markerThemes[this._current%this.markerThemes.length]):_aa;}var _ad=_ab&&_ab.symbol||this._markers[this._current%this._markers.length];var _ae={series:_aa,marker:_ab,symbol:_ad};++this._current;if(_a7){_ae=this.addMixin(_ae,_a6,_a7);}if(_a8){_ae=this.post(_ae,_a6);}return _ae;},skip:function(){++this._current;},addMixin:function(_af,_b0,_b1,_b2){if(dojo.isArray(_b1)){dojo.forEach(_b1,function(m){_af=this.addMixin(_af,_b0,m);},this);}else{var t={};if("color" in _b1){if(_b0=="line"||_b0=="area"){dojo.setObject("series.stroke.color",_b1.color,t);dojo.setObject("marker.stroke.color",_b1.color,t);}else{dojo.setObject("series.fill",_b1.color,t);}}dojo.forEach(["stroke","outline","shadow","fill","font","fontColor"],function(_b3){var _b4="marker"+_b3.charAt(0).toUpperCase()+_b3.substr(1),b=_b4 in _b1;if(_b3 in _b1){dojo.setObject("series."+_b3,_b1[_b3],t);if(!b){dojo.setObject("marker."+_b3,_b1[_b3],t);}}if(b){dojo.setObject("marker."+_b3,_b1[_b4],t);}});if("marker" in _b1){t.symbol=_b1.marker;}_af=dojox.lang.utils.merge(_af,t);}if(_b2){_af=this.post(_af,_b0);}return _af;},post:function(_b5,_b6){var _b7=_b5.series.fill,t;if(!this.noGradConv&&this.shapeSpaces[_b7.space]&&_b7.type=="linear"){if(_b6=="bar"){t={x1:_b7.y1,y1:_b7.x1,x2:_b7.y2,y2:_b7.x2};}else{if(!this.noRadialConv&&_b7.space=="shape"&&(_b6=="slice"||_b6=="circle")){t={type:"radial",cx:0,cy:0,r:100};}}if(t){return dojox.lang.utils.merge(_b5,{series:{fill:t}});}}return _b5;},getTick:function(_b8,_b9){var _ba=this.axis.tick,_bb=_b8+"Tick";merge=dojox.lang.utils.merge;if(_ba){if(this.axis[_bb]){_ba=merge(_ba,this.axis[_bb]);}}else{_ba=this.axis[_bb];}if(_b9){if(_ba){if(_b9[_bb]){_ba=merge(_ba,_b9[_bb]);}}else{_ba=_b9[_bb];}}return _ba;},inspectObjects:function(f){dojo.forEach(["chart","plotarea","axis","series","marker"],function(_bc){f(this[_bc]);},this);if(this.seriesThemes){dojo.forEach(this.seriesThemes,f);}if(this.markerThemes){dojo.forEach(this.markerThemes,f);}},reverseFills:function(){this.inspectObjects(function(o){if(o&&o.fill){o.fill=dojox.gfx.gradutils.reverse(o.fill);}});},addMarker:function(_bd,_be){this.markers[_bd]=_be;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}}});dojo.mixin(dojox.charting.Theme,{defaultMarkers:{CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"},defaultColors:["#54544c","#858e94","#6e767a","#948585","#474747"],defaultTheme:{chart:{stroke:null,fill:"white",pageStyle:null},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},tick:{color:"#666",position:"center",font:"normal normal normal 7pt Tahoma",fontColor:"#333"},majorTick:{width:1,length:6},minorTick:{width:0.8,length:3},microTick:{width:0.5,length:1}},series:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"},marker:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"}},defineColors:function(_bf){_bf=_bf||{};var c=[],n=_bf.num||5;if(_bf.colors){var l=_bf.colors.length;for(var i=0;i<n;i++){c.push(_bf.colors[i%l]);}return c;}if(_bf.hue){var s=_bf.saturation||100;var st=_bf.low||30;var end=_bf.high||90;var l=(end+st)/2;return dojox.color.Palette.generate(dojox.color.fromHsv(_bf.hue,s,l),"monochromatic").colors;}if(_bf.generator){return dojox.color.Palette.generate(_bf.base,_bf.generator).colors;}return c;},generateGradient:function(_c0,_c1,_c2){var _c3=dojo.delegate(_c0);_c3.colors=[{offset:0,color:_c1},{offset:1,color:_c2}];return _c3;},generateHslColor:function(_c4,_c5){_c4=new dojox.color.Color(_c4);var hsl=_c4.toHsl(),_c6=dojox.color.fromHsl(hsl.h,hsl.s,_c5);_c6.a=_c4.a;return _c6;},generateHslGradient:function(_c7,_c8,_c9,_ca){_c7=new dojox.color.Color(_c7);var hsl=_c7.toHsl(),_cb=dojox.color.fromHsl(hsl.h,hsl.s,_c9),_cc=dojox.color.fromHsl(hsl.h,hsl.s,_ca);_cb.a=_cc.a=_c7.a;return dojox.charting.Theme.generateGradient(_c8,_cb,_cc);}});}if(!dojo._hasResource["dojox.charting.Element"]){dojo._hasResource["dojox.charting.Element"]=true;dojo.provide("dojox.charting.Element");dojo.declare("dojox.charting.Element",null,{chart:null,group:null,htmlElements:null,dirty:true,constructor:function(_cd){this.chart=_cd;this.group=null;this.htmlElements=[];this.dirty=true;},createGroup:function(_ce){if(!_ce){_ce=this.chart.surface;}if(!this.group){this.group=_ce.createGroup();}return this;},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.group.clear();this.group.removeShape();this.group=null;}this.dirty=true;return this;},cleanGroup:function(_cf){this.destroyHtmlElements();if(!_cf){_cf=this.chart.surface;}if(this.group){this.group.clear();}else{this.group=_cf.createGroup();}this.dirty=true;return this;},destroyHtmlElements:function(){if(this.htmlElements.length){dojo.forEach(this.htmlElements,dojo.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();},_plotFill:function(_d0,dim,_d1){if(!_d0||!_d0.type||!_d0.space){return _d0;}var _d2=_d0.space;switch(_d0.type){case "linear":if(_d2==="plot"||_d2==="shapeX"||_d2==="shapeY"){_d0=dojox.gfx.makeParameters(dojox.gfx.defaultLinearGradient,_d0);_d0.space=_d2;if(_d2==="plot"||_d2==="shapeX"){var _d3=dim.height-_d1.t-_d1.b;_d0.y1=_d1.t+_d3*_d0.y1/100;_d0.y2=_d1.t+_d3*_d0.y2/100;}if(_d2==="plot"||_d2==="shapeY"){var _d3=dim.width-_d1.l-_d1.r;_d0.x1=_d1.l+_d3*_d0.x1/100;_d0.x2=_d1.l+_d3*_d0.x2/100;}}break;case "radial":if(_d2==="plot"){_d0=dojox.gfx.makeParameters(dojox.gfx.defaultRadialGradient,_d0);_d0.space=_d2;var _d4=dim.width-_d1.l-_d1.r,_d5=dim.height-_d1.t-_d1.b;_d0.cx=_d1.l+_d4*_d0.cx/100;_d0.cy=_d1.t+_d5*_d0.cy/100;_d0.r=_d0.r*Math.sqrt(_d4*_d4+_d5*_d5)/200;}break;case "pattern":if(_d2==="plot"||_d2==="shapeX"||_d2==="shapeY"){_d0=dojox.gfx.makeParameters(dojox.gfx.defaultPattern,_d0);_d0.space=_d2;if(_d2==="plot"||_d2==="shapeX"){var _d3=dim.height-_d1.t-_d1.b;_d0.y=_d1.t+_d3*_d0.y/100;_d0.height=_d3*_d0.height/100;}if(_d2==="plot"||_d2==="shapeY"){var _d3=dim.width-_d1.l-_d1.r;_d0.x=_d1.l+_d3*_d0.x/100;_d0.width=_d3*_d0.width/100;}}break;}return _d0;},_shapeFill:function(_d6,_d7){if(!_d6||!_d6.space){return _d6;}var _d8=_d6.space;switch(_d6.type){case "linear":if(_d8==="shape"||_d8==="shapeX"||_d8==="shapeY"){_d6=dojox.gfx.makeParameters(dojox.gfx.defaultLinearGradient,_d6);_d6.space=_d8;if(_d8==="shape"||_d8==="shapeX"){var _d9=_d7.width;_d6.x1=_d7.x+_d9*_d6.x1/100;_d6.x2=_d7.x+_d9*_d6.x2/100;}if(_d8==="shape"||_d8==="shapeY"){var _d9=_d7.height;_d6.y1=_d7.y+_d9*_d6.y1/100;_d6.y2=_d7.y+_d9*_d6.y2/100;}}break;case "radial":if(_d8==="shape"){_d6=dojox.gfx.makeParameters(dojox.gfx.defaultRadialGradient,_d6);_d6.space=_d8;_d6.cx=_d7.x+_d7.width/2;_d6.cy=_d7.y+_d7.height/2;_d6.r=_d6.r*_d7.width/200;}break;case "pattern":if(_d8==="shape"||_d8==="shapeX"||_d8==="shapeY"){_d6=dojox.gfx.makeParameters(dojox.gfx.defaultPattern,_d6);_d6.space=_d8;if(_d8==="shape"||_d8==="shapeX"){var _d9=_d7.width;_d6.x=_d7.x+_d9*_d6.x/100;_d6.width=_d9*_d6.width/100;}if(_d8==="shape"||_d8==="shapeY"){var _d9=_d7.height;_d6.y=_d7.y+_d9*_d6.y/100;_d6.height=_d9*_d6.height/100;}}break;}return _d6;},_pseudoRadialFill:function(_da,_db,_dc,_dd,end){if(!_da||_da.type!=="radial"||_da.space!=="shape"){return _da;}var _de=_da.space;_da=dojox.gfx.makeParameters(dojox.gfx.defaultRadialGradient,_da);_da.space=_de;if(arguments.length<4){_da.cx=_db.x;_da.cy=_db.y;_da.r=_da.r*_dc/100;return _da;}var _df=arguments.length<5?_dd:(end+_dd)/2;return {type:"linear",x1:_db.x,y1:_db.y,x2:_db.x+_da.r*_dc*Math.cos(_df)/100,y2:_db.y+_da.r*_dc*Math.sin(_df)/100,colors:_da.colors};return _da;}});}if(!dojo._hasResource["dojox.charting.Series"]){dojo._hasResource["dojox.charting.Series"]=true;dojo.provide("dojox.charting.Series");dojo.declare("dojox.charting.Series",dojox.charting.Element,{constructor:function(_e0,_e1,_e2){dojo.mixin(this,_e2);if(typeof this.plot!="string"){this.plot="default";}this.update(_e1);},clear:function(){this.dyn={};},update:function(_e3){if(dojo.isArray(_e3)){this.data=_e3;}else{this.source=_e3;this.data=this.source.data;if(this.source.setSeriesObject){this.source.setSeriesObject(this);}}this.dirty=true;this.clear();}});}if(!dojo._hasResource["dojox.charting.scaler.common"]){dojo._hasResource["dojox.charting.scaler.common"]=true;dojo.provide("dojox.charting.scaler.common");(function(){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};dojo.mixin(dojox.charting.scaler.common,{findString:function(val,_e4){val=val.toLowerCase();for(var i=0;i<_e4.length;++i){if(val==_e4[i]){return true;}}return false;},getNumericLabel:function(_e5,_e6,_e7){var def=_e7.fixed?_e5.toFixed(_e6<0?-_e6:0):_e5.toString();if(_e7.labelFunc){var r=_e7.labelFunc(def,_e5,_e6);if(r){return r;}}if(_e7.labels){var l=_e7.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_e5){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_e5)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_e5)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_e5)){return l[lo].text;}}return def;}});})();}if(!dojo._hasResource["dojox.charting.scaler.linear"]){dojo._hasResource["dojox.charting.scaler.linear"]=true;dojo.provide("dojox.charting.scaler.linear");(function(){var _e8=3,dc=dojox.charting,dcs=dc.scaler,_e9=dcs.common,_ea=_e9.findString,_eb=_e9.getNumericLabel;var _ec=function(min,max,_ed,_ee,_ef,_f0,_f1){_ed=dojo.delegate(_ed);if(!_ee){if(_ed.fixUpper=="major"){_ed.fixUpper="minor";}if(_ed.fixLower=="major"){_ed.fixLower="minor";}}if(!_ef){if(_ed.fixUpper=="minor"){_ed.fixUpper="micro";}if(_ed.fixLower=="minor"){_ed.fixLower="micro";}}if(!_f0){if(_ed.fixUpper=="micro"){_ed.fixUpper="none";}if(_ed.fixLower=="micro"){_ed.fixLower="none";}}var _f2=_ea(_ed.fixLower,["major"])?Math.floor(_ed.min/_ee)*_ee:_ea(_ed.fixLower,["minor"])?Math.floor(_ed.min/_ef)*_ef:_ea(_ed.fixLower,["micro"])?Math.floor(_ed.min/_f0)*_f0:_ed.min,_f3=_ea(_ed.fixUpper,["major"])?Math.ceil(_ed.max/_ee)*_ee:_ea(_ed.fixUpper,["minor"])?Math.ceil(_ed.max/_ef)*_ef:_ea(_ed.fixUpper,["micro"])?Math.ceil(_ed.max/_f0)*_f0:_ed.max;if(_ed.useMin){min=_f2;}if(_ed.useMax){max=_f3;}var _f4=(!_ee||_ed.useMin&&_ea(_ed.fixLower,["major"]))?min:Math.ceil(min/_ee)*_ee,_f5=(!_ef||_ed.useMin&&_ea(_ed.fixLower,["major","minor"]))?min:Math.ceil(min/_ef)*_ef,_f6=(!_f0||_ed.useMin&&_ea(_ed.fixLower,["major","minor","micro"]))?min:Math.ceil(min/_f0)*_f0,_f7=!_ee?0:(_ed.useMax&&_ea(_ed.fixUpper,["major"])?Math.round((max-_f4)/_ee):Math.floor((max-_f4)/_ee))+1,_f8=!_ef?0:(_ed.useMax&&_ea(_ed.fixUpper,["major","minor"])?Math.round((max-_f5)/_ef):Math.floor((max-_f5)/_ef))+1,_f9=!_f0?0:(_ed.useMax&&_ea(_ed.fixUpper,["major","minor","micro"])?Math.round((max-_f6)/_f0):Math.floor((max-_f6)/_f0))+1,_fa=_ef?Math.round(_ee/_ef):0,_fb=_f0?Math.round(_ef/_f0):0,_fc=_ee?Math.floor(Math.log(_ee)/Math.LN10):0,_fd=_ef?Math.floor(Math.log(_ef)/Math.LN10):0,_fe=_f1/(max-min);if(!isFinite(_fe)){_fe=1;}return {bounds:{lower:_f2,upper:_f3,from:min,to:max,scale:_fe,span:_f1},major:{tick:_ee,start:_f4,count:_f7,prec:_fc},minor:{tick:_ef,start:_f5,count:_f8,prec:_fd},micro:{tick:_f0,start:_f6,count:_f9,prec:0},minorPerMajor:_fa,microPerMinor:_fb,scaler:dcs.linear};};dojo.mixin(dojox.charting.scaler.linear,{buildScaler:function(min,max,_ff,_100){var h={fixUpper:"none",fixLower:"none",natural:false};if(_100){if("fixUpper" in _100){h.fixUpper=String(_100.fixUpper);}if("fixLower" in _100){h.fixLower=String(_100.fixLower);}if("natural" in _100){h.natural=Boolean(_100.natural);}}if("min" in _100){min=_100.min;}if("max" in _100){max=_100.max;}if(_100.includeZero){if(min>0){min=0;}if(max<0){max=0;}}h.min=min;h.useMin=true;h.max=max;h.useMax=true;if("from" in _100){min=_100.from;h.useMin=false;}if("to" in _100){max=_100.to;h.useMax=false;}if(max<=min){return _ec(min,max,h,0,0,0,_ff);}var mag=Math.floor(Math.log(max-min)/Math.LN10),_101=_100&&("majorTickStep" in _100)?_100.majorTickStep:Math.pow(10,mag),_102=0,_103=0,_104;if(_100&&("minorTickStep" in _100)){_102=_100.minorTickStep;}else{do{_102=_101/10;if(!h.natural||_102>0.9){_104=_ec(min,max,h,_101,_102,0,_ff);if(_104.bounds.scale*_104.minor.tick>_e8){break;}}_102=_101/5;if(!h.natural||_102>0.9){_104=_ec(min,max,h,_101,_102,0,_ff);if(_104.bounds.scale*_104.minor.tick>_e8){break;}}_102=_101/2;if(!h.natural||_102>0.9){_104=_ec(min,max,h,_101,_102,0,_ff);if(_104.bounds.scale*_104.minor.tick>_e8){break;}}return _ec(min,max,h,_101,0,0,_ff);}while(false);}if(_100&&("microTickStep" in _100)){_103=_100.microTickStep;_104=_ec(min,max,h,_101,_102,_103,_ff);}else{do{_103=_102/10;if(!h.natural||_103>0.9){_104=_ec(min,max,h,_101,_102,_103,_ff);if(_104.bounds.scale*_104.micro.tick>_e8){break;}}_103=_102/5;if(!h.natural||_103>0.9){_104=_ec(min,max,h,_101,_102,_103,_ff);if(_104.bounds.scale*_104.micro.tick>_e8){break;}}_103=_102/2;if(!h.natural||_103>0.9){_104=_ec(min,max,h,_101,_102,_103,_ff);if(_104.bounds.scale*_104.micro.tick>_e8){break;}}_103=0;}while(false);}return _103?_104:_ec(min,max,h,_101,_102,0,_ff);},buildTicks:function(_105,_106){var step,next,tick,_107=_105.major.start,_108=_105.minor.start,_109=_105.micro.start;if(_106.microTicks&&_105.micro.tick){step=_105.micro.tick,next=_109;}else{if(_106.minorTicks&&_105.minor.tick){step=_105.minor.tick,next=_108;}else{if(_105.major.tick){step=_105.major.tick,next=_107;}else{return null;}}}var _10a=1/_105.bounds.scale;if(_105.bounds.to<=_105.bounds.from||isNaN(_10a)||!isFinite(_10a)||step<=0||isNaN(step)||!isFinite(step)){return null;}var _10b=[],_10c=[],_10d=[];while(next<=_105.bounds.to+_10a){if(Math.abs(_107-next)<step/2){tick={value:_107};if(_106.majorLabels){tick.label=_eb(_107,_105.major.prec,_106);}_10b.push(tick);_107+=_105.major.tick;_108+=_105.minor.tick;_109+=_105.micro.tick;}else{if(Math.abs(_108-next)<step/2){if(_106.minorTicks){tick={value:_108};if(_106.minorLabels&&(_105.minMinorStep<=_105.minor.tick*_105.bounds.scale)){tick.label=_eb(_108,_105.minor.prec,_106);}_10c.push(tick);}_108+=_105.minor.tick;_109+=_105.micro.tick;}else{if(_106.microTicks){_10d.push({value:_109});}_109+=_105.micro.tick;}}next+=step;}return {major:_10b,minor:_10c,micro:_10d};},getTransformerFromModel:function(_10e){var _10f=_10e.bounds.from,_110=_10e.bounds.scale;return function(x){return (x-_10f)*_110;};},getTransformerFromPlot:function(_111){var _112=_111.bounds.from,_113=_111.bounds.scale;return function(x){return x/_113+_112;};}});})();}if(!dojo._hasResource["dojox.charting.axis2d.common"]){dojo._hasResource["dojox.charting.axis2d.common"]=true;dojo.provide("dojox.charting.axis2d.common");(function(){var g=dojox.gfx;var _114=function(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};var _115=function(n){if(n["getBoundingClientRect"]){var bcr=n.getBoundingClientRect();return bcr.width||(bcr.right-bcr.left);}else{return dojo.marginBox(n).w;}};dojo.mixin(dojox.charting.axis2d.common,{createText:{gfx:function(_116,_117,x,y,_118,text,font,_119){return _117.createText({x:x,y:y,text:text,align:_118}).setFont(font).setFill(_119);},html:function(_11a,_11b,x,y,_11c,text,font,_11d,_11e){var p=dojo.doc.createElement("div"),s=p.style,_11f;_114(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=_11d;s.position="absolute";s.left="-10000px";dojo.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size);if(!_11e){_11f=_115(p);}dojo.body().removeChild(p);s.position="relative";if(_11e){s.width=_11e+"px";switch(_11c){case "middle":s.textAlign="center";s.left=(x-_11e/2)+"px";break;case "end":s.textAlign="right";s.left=(x-_11e)+"px";break;default:s.left=x+"px";s.textAlign="left";break;}}else{switch(_11c){case "middle":s.left=Math.floor(x-_11f/2)+"px";break;case "end":s.left=Math.floor(x-_11f)+"px";break;default:s.left=Math.floor(x)+"px";break;}}s.top=Math.floor(y-size)+"px";s.whiteSpace="nowrap";var wrap=dojo.doc.createElement("div"),w=wrap.style;_114(w);w.width="0px";w.height="0px";wrap.appendChild(p);_11a.node.insertBefore(wrap,_11a.node.firstChild);return wrap;}}});})();}if(!dojo._hasResource["dojox.charting.axis2d.Base"]){dojo._hasResource["dojox.charting.axis2d.Base"]=true;dojo.provide("dojox.charting.axis2d.Base");dojo.declare("dojox.charting.axis2d.Base",dojox.charting.Element,{constructor:function(_120,_121){this.vertical=_121&&_121.vertical;},clear:function(){return this;},initialized:function(){return false;},calculate:function(min,max,span){return this;},getScaler:function(){return null;},getTicks:function(){return null;},getOffsets:function(){return {l:0,r:0,t:0,b:0};},render:function(dim,_122){this.dirty=false;return this;}});}if(!dojo._hasResource["dojox.charting.axis2d.Invisible"]){dojo._hasResource["dojox.charting.axis2d.Invisible"]=true;dojo.provide("dojox.charting.axis2d.Invisible");(function(){var dc=dojox.charting,df=dojox.lang.functional,du=dojox.lang.utils,g=dojox.gfx,lin=dc.scaler.linear,_123=du.merge,_124=4,_125=45;dojo.declare("dojox.charting.axis2d.Invisible",dojox.charting.axis2d.Base,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0},constructor:function(_126,_127){this.opt=dojo.delegate(this.defaultParams,_127);du.updateWithPattern(this.opt,_127,this.optionalParams);},dependOnData:function(){return !("min" in this.opt)||!("max" in this.opt);},clear:function(){delete this.scaler;delete this.ticks;this.dirty=true;return this;},initialized:function(){return "scaler" in this&&!(this.dirty&&this.dependOnData());},setWindow:function(_128,_129){this.scale=_128;this.offset=_129;return this.clear();},getWindowScale:function(){return "scale" in this?this.scale:1;},getWindowOffset:function(){return "offset" in this?this.offset:0;},_groupLabelWidth:function(_12a,font){if(!_12a.length){return 0;}if(dojo.isObject(_12a[0])){_12a=df.map(_12a,function(_12b){return _12b.text;});}var s=_12a.join("<br>");return dojox.gfx._base._getTextBox(s,{font:font}).w||0;},calculate:function(min,max,span,_12c){if(this.initialized()){return this;}var o=this.opt;this.labels="labels" in o?o.labels:_12c;this.scaler=lin.buildScaler(min,max,span,o);var tsb=this.scaler.bounds;if("scale" in this){o.from=tsb.lower+this.offset;o.to=(tsb.upper-tsb.lower)/this.scale+o.from;if(!isFinite(o.from)||isNaN(o.from)||!isFinite(o.to)||isNaN(o.to)||o.to-o.from>=tsb.upper-tsb.lower){delete o.from;delete o.to;delete this.scale;delete this.offset;}else{if(o.from<tsb.lower){o.to+=tsb.lower-o.from;o.from=tsb.lower;}else{if(o.to>tsb.upper){o.from+=tsb.upper-o.to;o.to=tsb.upper;}}this.offset=o.from-tsb.lower;}this.scaler=lin.buildScaler(min,max,span,o);tsb=this.scaler.bounds;if(this.scale==1&&this.offset==0){delete this.scale;delete this.offset;}}var ta=this.chart.theme.axis,_12d=0,_12e=o.rotation%360,_12f=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),size=_12f?g.normalizedLength(g.splitFontString(_12f).size):0,cosr=Math.abs(Math.cos(_12e*Math.PI/180)),sinr=Math.abs(Math.sin(_12e*Math.PI/180));if(_12e<0){_12e+=360;}if(size){if(this.vertical?_12e!=0&&_12e!=180:_12e!=90&&_12e!=270){if(o.maxLabelSize){_12d=o.maxLabelSize;}else{if(this.labels){_12d=this._groupLabelWidth(this.labels,_12f);}else{var _130=Math.ceil(Math.log(Math.max(Math.abs(tsb.from),Math.abs(tsb.to)))/Math.LN10),t=[];if(tsb.from<0||tsb.to<0){t.push("-");}t.push(dojo.string.rep("9",_130));var _131=Math.floor(Math.log(tsb.to-tsb.from)/Math.LN10);if(_131>0){t.push(".");t.push(dojo.string.rep("9",_131));}_12d=dojox.gfx._base._getTextBox(t.join(""),{font:_12f}).w;}}}else{_12d=size;}switch(_12e){case 0:case 90:case 180:case 270:break;default:var gap1=Math.sqrt(_12d*_12d+size*size),gap2=this.vertical?size*cosr+_12d*sinr:_12d*cosr+size*sinr;_12d=Math.min(gap1,gap2);break;}}this.scaler.minMinorStep=_12d+_124;this.ticks=lin.buildTicks(this.scaler,o);return this;},getScaler:function(){return this.scaler;},getTicks:function(){return this.ticks;}});})();}if(!dojo._hasResource["dojox.charting.axis2d.Default"]){dojo._hasResource["dojox.charting.axis2d.Default"]=true;dojo.provide("dojox.charting.axis2d.Default");(function(){var dc=dojox.charting,du=dojox.lang.utils,g=dojox.gfx,lin=dc.scaler.linear,_132=4,_133=45;dojo.declare("dojox.charting.axis2d.Default",dojox.charting.axis2d.Invisible,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0,htmlLabels:true},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,stroke:{},majorTick:{},minorTick:{},microTick:{},tick:{},font:"",fontColor:""},constructor:function(_134,_135){this.opt=dojo.delegate(this.defaultParams,_135);du.updateWithPattern(this.opt,_135,this.optionalParams);},getOffsets:function(){var s=this.scaler,_136={l:0,r:0,t:0,b:0};if(!s){return _136;}var o=this.opt,_137=0,a,b,c,d,gl=dc.scaler.common.getNumericLabel,_138=0,ma=s.major,mi=s.minor,ta=this.chart.theme.axis,_139=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_13a=this.chart.theme.getTick("major",o),_13b=this.chart.theme.getTick("minor",o),size=_139?g.normalizedLength(g.splitFontString(_139).size):0,_13c=o.rotation%360,_13d=o.leftBottom,cosr=Math.abs(Math.cos(_13c*Math.PI/180)),sinr=Math.abs(Math.sin(_13c*Math.PI/180));if(_13c<0){_13c+=360;}if(size){if(o.maxLabelSize){_137=o.maxLabelSize;}else{if(this.labels){_137=this._groupLabelWidth(this.labels,_139);}else{_137=this._groupLabelWidth([gl(ma.start,ma.prec,o),gl(ma.start+ma.count*ma.tick,ma.prec,o),gl(mi.start,mi.prec,o),gl(mi.start+mi.count*mi.tick,mi.prec,o)],_139);}}if(this.vertical){var side=_13d?"l":"r";switch(_13c){case 0:case 180:_136[side]=_137;_136.t=_136.b=size/2;break;case 90:case 270:_136[side]=size;_136.t=_136.b=_137/2;break;default:if(_13c<=_133||(180<_13c&&_13c<=(180+_133))){_136[side]=size*sinr/2+_137*cosr;_136[_13d?"t":"b"]=size*cosr/2+_137*sinr;_136[_13d?"b":"t"]=size*cosr/2;}else{if(_13c>(360-_133)||(180>_13c&&_13c>(180-_133))){_136[side]=size*sinr/2+_137*cosr;_136[_13d?"b":"t"]=size*cosr/2+_137*sinr;_136[_13d?"t":"b"]=size*cosr/2;}else{if(_13c<90||(180<_13c&&_13c<270)){_136[side]=size*sinr+_137*cosr;_136[_13d?"t":"b"]=size*cosr+_137*sinr;}else{_136[side]=size*sinr+_137*cosr;_136[_13d?"b":"t"]=size*cosr+_137*sinr;}}}break;}_136[side]+=_132+Math.max(_13a.length,_13b.length);}else{var side=_13d?"b":"t";switch(_13c){case 0:case 180:_136[side]=size;_136.l=_136.r=_137/2;break;case 90:case 270:_136[side]=_137;_136.l=_136.r=size/2;break;default:if((90-_133)<=_13c&&_13c<=90||(270-_133)<=_13c&&_13c<=270){_136[side]=size*sinr/2+_137*cosr;_136[_13d?"r":"l"]=size*cosr/2+_137*sinr;_136[_13d?"l":"r"]=size*cosr/2;}else{if(90<=_13c&&_13c<=(90+_133)||270<=_13c&&_13c<=(270+_133)){_136[side]=size*sinr/2+_137*cosr;_136[_13d?"l":"r"]=size*cosr/2+_137*sinr;_136[_13d?"r":"l"]=size*cosr/2;}else{if(_13c<_133||(180<_13c&&_13c<(180-_133))){_136[side]=size*sinr+_137*cosr;_136[_13d?"r":"l"]=size*cosr+_137*sinr;}else{_136[side]=size*sinr+_137*cosr;_136[_13d?"l":"r"]=size*cosr+_137*sinr;}}}break;}_136[side]+=_132+Math.max(_13a.length,_13b.length);}}if(_137){this._cachedLabelWidth=_137;}return _136;},render:function(dim,_13e){if(!this.dirty){return this;}var o=this.opt,ta=this.chart.theme.axis,_13f=o.leftBottom,_140=o.rotation%360,_141,stop,_142,_143,_144,_145,_146,_147=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_148=o.fontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"black",_149=this.chart.theme.getTick("major",o),_14a=this.chart.theme.getTick("minor",o),_14b=this.chart.theme.getTick("micro",o),_14c=Math.max(_149.length,_14a.length,_14b.length),_14d="stroke" in o?o.stroke:ta.stroke,size=_147?g.normalizedLength(g.splitFontString(_147).size):0;if(_140<0){_140+=360;}if(this.vertical){_141={y:dim.height-_13e.b};stop={y:_13e.t};_142={x:0,y:-1};_145={x:0,y:0};_143={x:1,y:0};_144={x:_132,y:0};switch(_140){case 0:_146="end";_145.y=size*0.4;break;case 90:_146="middle";_145.x=-size;break;case 180:_146="start";_145.y=-size*0.4;break;case 270:_146="middle";break;default:if(_140<_133){_146="end";_145.y=size*0.4;}else{if(_140<90){_146="end";_145.y=size*0.4;}else{if(_140<(180-_133)){_146="start";}else{if(_140<(180+_133)){_146="start";_145.y=-size*0.4;}else{if(_140<270){_146="start";_145.x=_13f?0:size*0.4;}else{if(_140<(360-_133)){_146="end";_145.x=_13f?0:size*0.4;}else{_146="end";_145.y=size*0.4;}}}}}}}if(_13f){_141.x=stop.x=_13e.l;_143.x=-1;_144.x=-_144.x;}else{_141.x=stop.x=dim.width-_13e.r;switch(_146){case "start":_146="end";break;case "end":_146="start";break;case "middle":_145.x+=size;break;}}}else{_141={x:_13e.l};stop={x:dim.width-_13e.r};_142={x:1,y:0};_145={x:0,y:0};_143={x:0,y:1};_144={x:0,y:_132};switch(_140){case 0:_146="middle";_145.y=size;break;case 90:_146="start";_145.x=-size*0.4;break;case 180:_146="middle";break;case 270:_146="end";_145.x=size*0.4;break;default:if(_140<(90-_133)){_146="start";_145.y=_13f?size:0;}else{if(_140<(90+_133)){_146="start";_145.x=-size*0.4;}else{if(_140<180){_146="start";_145.y=_13f?0:-size;}else{if(_140<(270-_133)){_146="end";_145.y=_13f?0:-size;}else{if(_140<(270+_133)){_146="end";_145.y=_13f?size*0.4:0;}else{_146="end";_145.y=_13f?size:0;}}}}}}if(_13f){_141.y=stop.y=dim.height-_13e.b;}else{_141.y=stop.y=_13e.t;_143.y=-1;_144.y=-_144.y;switch(_146){case "start":_146="end";break;case "end":_146="start";break;case "middle":_145.y-=size;break;}}}this.cleanGroup();try{var s=this.group,c=this.scaler,t=this.ticks,_14e,f=lin.getTransformerFromModel(this.scaler),_14f=(dojox.gfx.renderer=="canvas"),_150=_14f||!_140&&this.opt.htmlLabels&&!dojo.isIE&&!dojo.isOpera?"html":"gfx",dx=_143.x*_149.length,dy=_143.y*_149.length;s.createLine({x1:_141.x,y1:_141.y,x2:stop.x,y2:stop.y}).setStroke(_14d);dojo.forEach(t.major,function(tick){var _151=f(tick.value),elem,x=_141.x+_142.x*_151,y=_141.y+_142.y*_151;s.createLine({x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_149);if(tick.label){elem=dc.axis2d.common.createText[_150](this.chart,s,x+dx+_144.x+(_140?0:_145.x),y+dy+_144.y+(_140?0:_145.y),_146,tick.label,_147,_148);if(_150=="html"){this.htmlElements.push(elem);}else{if(_140){elem.setTransform([{dx:_145.x,dy:_145.y},g.matrix.rotategAt(_140,x+dx+_144.x,y+dy+_144.y)]);}}}},this);dx=_143.x*_14a.length;dy=_143.y*_14a.length;_14e=c.minMinorStep<=c.minor.tick*c.bounds.scale;dojo.forEach(t.minor,function(tick){var _152=f(tick.value),elem,x=_141.x+_142.x*_152,y=_141.y+_142.y*_152;s.createLine({x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_14a);if(_14e&&tick.label){elem=dc.axis2d.common.createText[_150](this.chart,s,x+dx+_144.x+(_140?0:_145.x),y+dy+_144.y+(_140?0:_145.y),_146,tick.label,_147,_148);if(_150=="html"){this.htmlElements.push(elem);}else{if(_140){elem.setTransform([{dx:_145.x,dy:_145.y},g.matrix.rotategAt(_140,x+dx+_144.x,y+dy+_144.y)]);}}}},this);dx=_143.x*_14b.length;dy=_143.y*_14b.length;dojo.forEach(t.micro,function(tick){var _153=f(tick.value),elem,x=_141.x+_142.x*_153,y=_141.y+_142.y*_153;s.createLine({x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_14b);},this);}catch(e){}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.common"]){dojo._hasResource["dojox.charting.plot2d.common"]=true;dojo.provide("dojox.charting.plot2d.common");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common;dojo.mixin(dojox.charting.plot2d.common,{makeStroke:function(_154){if(!_154){return _154;}if(typeof _154=="string"||_154 instanceof dojo.Color){_154={color:_154};}return dojox.gfx.makeParameters(dojox.gfx.defaultStroke,_154);},augmentColor:function(_155,_156){var t=new dojo.Color(_155),c=new dojo.Color(_156);c.a=t.a;return c;},augmentStroke:function(_157,_158){var s=dc.makeStroke(_157);if(s){s.color=dc.augmentColor(s.color,_158);}return s;},augmentFill:function(fill,_159){var fc,c=new dojo.Color(_159);if(typeof fill=="string"||fill instanceof dojo.Color){return dc.augmentColor(fill,_159);}return fill;},defaultStats:{hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY,vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_15a){var _15b=dojo.delegate(dc.defaultStats);for(var i=0;i<_15a.length;++i){var run=_15a[i];for(var j=0;j<run.data.length;j++){if(run.data[j]!==null){if(typeof run.data[j]=="number"){var _15c=_15b.vmin,_15d=_15b.vmax;if(!("ymin" in run)||!("ymax" in run)){dojo.forEach(run.data,function(val,i){if(val!==null){var x=i+1,y=val;if(isNaN(y)){y=0;}_15b.hmin=Math.min(_15b.hmin,x);_15b.hmax=Math.max(_15b.hmax,x);_15b.vmin=Math.min(_15b.vmin,y);_15b.vmax=Math.max(_15b.vmax,y);}});}if("ymin" in run){_15b.vmin=Math.min(_15c,run.ymin);}if("ymax" in run){_15b.vmax=Math.max(_15d,run.ymax);}}else{var _15e=_15b.hmin,_15f=_15b.hmax,_15c=_15b.vmin,_15d=_15b.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){dojo.forEach(run.data,function(val,i){if(val!==null){var x="x" in val?val.x:i+1,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}_15b.hmin=Math.min(_15b.hmin,x);_15b.hmax=Math.max(_15b.hmax,x);_15b.vmin=Math.min(_15b.vmin,y);_15b.vmax=Math.max(_15b.vmax,y);}});}if("xmin" in run){_15b.hmin=Math.min(_15e,run.xmin);}if("xmax" in run){_15b.hmax=Math.max(_15f,run.xmax);}if("ymin" in run){_15b.vmin=Math.min(_15c,run.ymin);}if("ymax" in run){_15b.vmax=Math.max(_15d,run.ymax);}}break;}}}return _15b;},calculateBarSize:function(_160,opt,_161){if(!_161){_161=1;}var gap=opt.gap,size=(_160-2*gap)/_161;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_160-size*_161)/2;return {size:size,gap:gap};},collectStackedStats:function(_162){var _163=dojo.clone(dc.defaultStats);if(_162.length){_163.hmin=Math.min(_163.hmin,1);_163.hmax=df.foldl(_162,"seed, run -> Math.max(seed, run.data.length)",_163.hmax);for(var i=0;i<_163.hmax;++i){var v=_162[0].data[i];if(isNaN(v)){v=0;}_163.vmin=Math.min(_163.vmin,v);for(var j=1;j<_162.length;++j){var t=_162[j].data[i];if(isNaN(t)){t=0;}v+=t;}_163.vmax=Math.max(_163.vmax,v);}}return _163;},curve:function(a,_164){var arr=a.slice(0);if(_164=="x"){arr[arr.length]=arr[0];}var p=dojo.map(arr,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_164)){var dx=item.x-arr[i-1].x,dy=arr[i-1].y;return "C"+(item.x-(_164-1)*(dx/_164))+","+dy+" "+(item.x-(dx/_164))+","+item.y+" "+item.x+","+item.y;}else{if(_164=="X"||_164=="x"||_164=="S"){var p0,p1=arr[i-1],p2=arr[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_164=="x"){p0=arr[arr.length-2];}else{p0=p1;}f=1/3;}else{p0=arr[i-2];}if(i==(arr.length-1)){if(_164=="x"){p3=arr[1];}else{p3=p2;}f=1/3;}else{p3=arr[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var _165=p0p2*f;var _166=p1p3*f;if(_165>p1p2/2&&_166>p1p2/2){_165=p1p2/2;_166=p1p2/2;}else{if(_165>p1p2/2){_165=p1p2/2;_166=p1p2/2*p1p3/p0p2;}else{if(_166>p1p2/2){_166=p1p2/2;_165=p1p2/2*p0p2/p1p3;}}}if(_164=="S"){if(p0==p1){_165=0;}if(p2==p3){_166=0;}}bz1x=p1.x+_165*(p2.x-p0.x)/p0p2;bz1y=p1.y+_165*(p2.y-p0.y)/p0p2;bz2x=p2.x-_166*(p3.x-p1.x)/p1p3;bz2y=p2.y-_166*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");}});})();}if(!dojo._hasResource["dojox.charting.scaler.primitive"]){dojo._hasResource["dojox.charting.scaler.primitive"]=true;dojo.provide("dojox.charting.scaler.primitive");dojox.charting.scaler.primitive={buildScaler:function(min,max,span,_167){if(min==max){min-=0.5;max+=0.5;}return {bounds:{lower:min,upper:max,from:min,to:max,scale:span/(max-min),span:span},scaler:dojox.charting.scaler.primitive};},buildTicks:function(_168,_169){return {major:[],minor:[],micro:[]};},getTransformerFromModel:function(_16a){var _16b=_16a.bounds.from,_16c=_16a.bounds.scale;return function(x){return (x-_16b)*_16c;};},getTransformerFromPlot:function(_16d){var _16e=_16d.bounds.from,_16f=_16d.bounds.scale;return function(x){return x/_16f+_16e;};}};}if(!dojo._hasResource["dojox.charting.plot2d._PlotEvents"]){dojo._hasResource["dojox.charting.plot2d._PlotEvents"]=true;dojo.provide("dojox.charting.plot2d._PlotEvents");dojo.declare("dojox.charting.plot2d._PlotEvents",null,{constructor:function(){this._shapeEvents=[];this._eventSeries={};},destroy:function(){this.resetEvents();this.inherited(arguments);},plotEvent:function(o){},raiseEvent:function(o){this.plotEvent(o);var t=dojo.delegate(o);t.originalEvent=o.type;t.originalPlot=o.plot;t.type="onindirect";dojo.forEach(this.chart.stack,function(plot){if(plot!==this&&plot.plotEvent){t.plot=plot;plot.plotEvent(t);}},this);},connect:function(_170,_171){this.dirty=true;return dojo.connect(this,"plotEvent",_170,_171);},events:function(){var ls=this.plotEvent._listeners;if(!ls||!ls.length){return false;}for(var i in ls){if(!(i in Array.prototype)){return true;}}return false;},resetEvents:function(){if(this._shapeEvents.length){dojo.forEach(this._shapeEvents,function(item){item.shape.disconnect(item.handle);});this._shapeEvents=[];}this.raiseEvent({type:"onplotreset",plot:this});},_connectSingleEvent:function(o,_172){this._shapeEvents.push({shape:o.eventMask,handle:o.eventMask.connect(_172,this,function(e){o.type=_172;o.event=e;this.raiseEvent(o);o.event=null;})});},_connectEvents:function(o){o.chart=this.chart;o.plot=this;o.hAxis=this.hAxis||null;o.vAxis=this.vAxis||null;o.eventMask=o.eventMask||o.shape;this._connectSingleEvent(o,"onmouseover");this._connectSingleEvent(o,"onmouseout");this._connectSingleEvent(o,"onclick");},_reconnectEvents:function(_173){var a=this._eventSeries[_173];if(a){dojo.forEach(a,this._connectEvents,this);}},fireEvent:function(_174,_175,_176,_177){var s=this._eventSeries[_174];if(s&&s.length&&_176<s.length){var o=s[_176];o.type=_175;o.event=_177||null;this.raiseEvent(o);o.event=null;}}});}if(!dojo._hasResource["dojox.charting.plot2d.Base"]){dojo._hasResource["dojox.charting.plot2d.Base"]=true;dojo.provide("dojox.charting.plot2d.Base");dojo.declare("dojox.charting.plot2d.Base",[dojox.charting.Element,dojox.charting.plot2d._PlotEvents],{constructor:function(_178,_179){this.zoom=null,this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};},clear:function(){this.series=[];this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},addSeries:function(run){this.series.push(run);return this;},getSeriesStats:function(){return dojox.charting.plot2d.common.collectSimpleStats(this.series);},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},isDataDirty:function(){return dojo.some(this.series,function(item){return item.dirty;});},performZoom:function(dim,_17a){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,_17b=dim.height-_17a.b,_17c=this._hScaler.bounds,_17d=(_17c.from-_17c.lower)*_17c.scale,_17e=this._vScaler.bounds,_17f=(_17e.from-_17e.lower)*_17e.scale;rVScale=vs/this.lastWindow.vscale,rHScale=hs/this.lastWindow.hscale,rXOffset=(this.lastWindow.xoffset-_17d)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),rYOffset=(_17f-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),shape=this.group,anim=dojox.gfx.fx.animateTransform(dojo.delegate({shape:shape,duration:1200,transform:[{name:"translate",start:[0,0],end:[_17a.l*(1-rHScale),_17b*(1-rVScale)]},{name:"scale",start:[1,1],end:[rHScale,rVScale]},{name:"original"},{name:"translate",start:[0,0],end:[rXOffset,rYOffset]}]},this.zoom));dojo.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:_17d,yoffset:_17f});this.zoomQueue.push(anim);dojo.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}return this;},render:function(dim,_180){return this;},getRequiredColors:function(){return this.series.length;},initializeScalers:function(dim,_181){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_181.hmin,_181.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=dojox.charting.scaler.primitive.buildScaler(_181.hmin,_181.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_181.vmin,_181.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=dojox.charting.scaler.primitive.buildScaler(_181.vmin,_181.vmax,dim.height);}return this;}});}if(!dojo._hasResource["dojox.gfx.fx"]){dojo._hasResource["dojox.gfx.fx"]=true;dojo.provide("dojox.gfx.fx");(function(){var d=dojo,g=dojox.gfx,m=g.matrix;var _182=function(_183,end){this.start=_183,this.end=end;};d.extend(_182,{getValue:function(r){return (this.end-this.start)*r+this.start;}});var _184=function(_185,end,_186){this.start=_185,this.end=end;this.units=_186;};d.extend(_184,{getValue:function(r){return (this.end-this.start)*r+this.start+this.units;}});var _187=function(_188,end){this.start=_188,this.end=end;this.temp=new dojo.Color();};d.extend(_187,{getValue:function(r){return d.blendColors(this.start,this.end,r,this.temp);}});var _189=function(_18a){this.values=_18a;this.length=_18a.length;};d.extend(_189,{getValue:function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];}});var _18b=function(_18c,def){this.values=_18c;this.def=def?def:{};};d.extend(_18b,{getValue:function(r){var ret=dojo.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}return ret;}});var _18d=function(_18e,_18f){this.stack=_18e;this.original=_18f;};d.extend(_18d,{getValue:function(r){var ret=[];dojo.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}if(t.name=="original"&&this.original){ret.push(this.original);return;}if(!(t.name in m)){return;}var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}var val=dojo.map(t.start,function(v,i){return (t.end[i]-v)*r+v;}),_190=f.apply(m,val);if(_190 instanceof m.Matrix2D){ret.push(_190);}},this);return ret;}});var _191=new d.Color(0,0,0,0);var _192=function(prop,obj,name,def){if(prop.values){return new _189(prop.values);}var _193,_194,end;if(prop.start){_194=g.normalizeColor(prop.start);}else{_194=_193=obj?(name?obj[name]:obj):def;}if(prop.end){end=g.normalizeColor(prop.end);}else{if(!_193){_193=obj?(name?obj[name]:obj):def;}end=_193;}return new _187(_194,end);};var _195=function(prop,obj,name,def){if(prop.values){return new _189(prop.values);}var _196,_197,end;if(prop.start){_197=prop.start;}else{_197=_196=obj?obj[name]:def;}if(prop.end){end=prop.end;}else{if(typeof _196!="number"){_196=obj?obj[name]:def;}end=_196;}return new _182(_197,end);};g.fx.animateStroke=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d.Animation(args),_198=args.shape,_199;d.connect(anim,"beforeBegin",anim,function(){_199=_198.getStroke();var prop=args.color,_19a={},_19b,_19c,end;if(prop){_19a.color=_192(prop,_199,"color",_191);}prop=args.style;if(prop&&prop.values){_19a.style=new _189(prop.values);}prop=args.width;if(prop){_19a.width=_195(prop,_199,"width",1);}prop=args.cap;if(prop&&prop.values){_19a.cap=new _189(prop.values);}prop=args.join;if(prop){if(prop.values){_19a.join=new _189(prop.values);}else{_19c=prop.start?prop.start:(_199&&_199.join||0);end=prop.end?prop.end:(_199&&_199.join||0);if(typeof _19c=="number"&&typeof end=="number"){_19a.join=new _182(_19c,end);}}}this.curve=new _18b(_19a,_199);});d.connect(anim,"onAnimate",_198,"setStroke");return anim;};g.fx.animateFill=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d.Animation(args),_19d=args.shape,fill;d.connect(anim,"beforeBegin",anim,function(){fill=_19d.getFill();var prop=args.color,_19e={};if(prop){this.curve=_192(prop,fill,"",_191);}});d.connect(anim,"onAnimate",_19d,"setFill");return anim;};g.fx.animateFont=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d.Animation(args),_19f=args.shape,font;d.connect(anim,"beforeBegin",anim,function(){font=_19f.getFont();var prop=args.style,_1a0={},_1a1,_1a2,end;if(prop&&prop.values){_1a0.style=new _189(prop.values);}prop=args.variant;if(prop&&prop.values){_1a0.variant=new _189(prop.values);}prop=args.weight;if(prop&&prop.values){_1a0.weight=new _189(prop.values);}prop=args.family;if(prop&&prop.values){_1a0.family=new _189(prop.values);}prop=args.size;if(prop&&prop.units){_1a2=parseFloat(prop.start?prop.start:(_19f.font&&_19f.font.size||"0"));end=parseFloat(prop.end?prop.end:(_19f.font&&_19f.font.size||"0"));_1a0.size=new _184(_1a2,end,prop.units);}this.curve=new _18b(_1a0,font);});d.connect(anim,"onAnimate",_19f,"setFont");return anim;};g.fx.animateTransform=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d.Animation(args),_1a3=args.shape,_1a4;d.connect(anim,"beforeBegin",anim,function(){_1a4=_1a3.getTransform();this.curve=new _18d(args.transform,_1a4);});d.connect(anim,"onAnimate",_1a3,"setTransform");return anim;};})();}if(!dojo._hasResource["dojox.charting.plot2d.Default"]){dojo._hasResource["dojox.charting.plot2d.Default"]=true;dojo.provide("dojox.charting.plot2d.Default");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_1a5=df.lambda("item.purgeGroup()");var _1a6=1200;dojo.declare("dojox.charting.plot2d.Default",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",lines:true,areas:false,markers:false,tension:"",animate:false},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:"",markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:""},constructor:function(_1a7,_1a8){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_1a8);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},render:function(dim,_1a9){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_1a9);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_1a5);this._eventSeries={};this.cleanGroup();this.group.setTransform(null);var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_1aa,_1ab,_1ac,_1ad=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}var _1ae=t.next(this.opt.areas?"area":"line",[this.opt,run],true),s=run.group,_1af=[],_1b0=[],rseg=null,_1b1,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_1b2=this._eventSeries[run.name]=new Array(run.data.length);for(var j=0;j<run.data.length;j++){if(run.data[j]!=null){if(!rseg){rseg=[];_1b0.push(j);_1af.push(rseg);}rseg.push(run.data[j]);}else{rseg=null;}}for(var seg=0;seg<_1af.length;seg++){if(typeof _1af[seg][0]=="number"){_1b1=dojo.map(_1af[seg],function(v,i){return {x:ht(i+_1b0[seg]+1)+_1a9.l,y:dim.height-_1a9.b-vt(v)};},this);}else{_1b1=dojo.map(_1af[seg],function(v,i){return {x:ht(v.x)+_1a9.l,y:dim.height-_1a9.b-vt(v.y)};},this);}var _1b3=this.opt.tension?dc.curve(_1b1,this.opt.tension):"";if(this.opt.areas&&_1b1.length>1){var fill=_1ae.series.fill;var _1b4=dojo.clone(_1b1);if(this.opt.tension){var _1b5="L"+_1b4[_1b4.length-1].x+","+(dim.height-_1a9.b)+" L"+_1b4[0].x+","+(dim.height-_1a9.b)+" L"+_1b4[0].x+","+_1b4[0].y;run.dyn.fill=s.createPath(_1b3+" "+_1b5).setFill(fill).getFill();}else{_1b4.push({x:_1b1[_1b1.length-1].x,y:dim.height-_1a9.b});_1b4.push({x:_1b1[0].x,y:dim.height-_1a9.b});_1b4.push(_1b1[0]);run.dyn.fill=s.createPolyline(_1b4).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_1aa=_1ae.series.stroke;if(_1ae.series.outline){_1ab=run.dyn.outline=dc.makeStroke(_1ae.series.outline);_1ab.width=2*_1ab.width+_1aa.width;}}if(this.opt.markers){run.dyn.marker=_1ae.symbol;}var _1b6=null,_1b7=null,_1b8=null;if(_1aa&&_1ae.series.shadow&&_1b1.length>1){var _1b9=_1ae.series.shadow,_1ba=dojo.map(_1b1,function(c){return {x:c.x+_1b9.dx,y:c.y+_1b9.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_1ba,this.opt.tension)).setStroke(_1b9).getStroke();}else{run.dyn.shadow=s.createPolyline(_1ba).setStroke(_1b9).getStroke();}}if(this.opt.markers&&_1ae.marker.shadow){_1b9=_1ae.marker.shadow;_1b8=dojo.map(_1ba,function(c){return s.createPath("M"+c.x+" "+c.y+" "+_1ae.symbol).setStroke(_1b9).setFill(_1b9.color);},this);}}if(this.opt.lines&&_1b1.length>1){if(_1ab){if(this.opt.tension){run.dyn.outline=s.createPath(_1b3).setStroke(_1ab).getStroke();}else{run.dyn.outline=s.createPolyline(_1b1).setStroke(_1ab).getStroke();}}if(this.opt.tension){run.dyn.stroke=s.createPath(_1b3).setStroke(_1aa).getStroke();}else{run.dyn.stroke=s.createPolyline(_1b1).setStroke(_1aa).getStroke();}}if(this.opt.markers){_1b6=new Array(_1b1.length);_1b7=new Array(_1b1.length);_1ab=null;if(_1ae.marker.outline){_1ab=dc.makeStroke(_1ae.marker.outline);_1ab.width=2*_1ab.width+(_1ae.marker.stroke?_1ae.marker.stroke.width:0);}dojo.forEach(_1b1,function(c,i){var path="M"+c.x+" "+c.y+" "+_1ae.symbol;if(_1ab){_1b7[i]=s.createPath(path).setStroke(_1ab);}_1b6[i]=s.createPath(path).setStroke(_1ae.marker.stroke).setFill(_1ae.marker.fill);},this);if(_1ad){dojo.forEach(_1b6,function(s,i){var o={element:"marker",index:i+_1b0[seg],run:run,shape:s,outline:_1b7[i]||null,shadow:_1b8&&_1b8[i]||null,cx:_1b1[i].x,cy:_1b1[i].y};if(typeof _1af[seg][0]=="number"){o.x=i+_1b0[seg]+1;o.y=_1af[seg][i];}else{o.x=_1af[seg][i].x;o.y=_1af[seg][i].y;}this._connectEvents(o);_1b2[i+_1b0[seg]]=o;},this);}else{delete this._eventSeries[run.name];}}}run.dirty=false;}if(this.animate){var _1bb=this.group;dojox.gfx.fx.animateTransform(dojo.delegate({shape:_1bb,duration:_1a6,transform:[{name:"translate",start:[0,dim.height-_1a9.b],end:[0,0]},{name:"scale",start:[1,0],end:[1,1]},{name:"original"}]},this.animate)).play();}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Lines"]){dojo._hasResource["dojox.charting.plot2d.Lines"]=true;dojo.provide("dojox.charting.plot2d.Lines");dojo.declare("dojox.charting.plot2d.Lines",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.Areas"]){dojo._hasResource["dojox.charting.plot2d.Areas"]=true;dojo.provide("dojox.charting.plot2d.Areas");dojo.declare("dojox.charting.plot2d.Areas",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.Markers"]){dojo._hasResource["dojox.charting.plot2d.Markers"]=true;dojo.provide("dojox.charting.plot2d.Markers");dojo.declare("dojox.charting.plot2d.Markers",dojox.charting.plot2d.Default,{constructor:function(){this.opt.markers=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.MarkersOnly"]){dojo._hasResource["dojox.charting.plot2d.MarkersOnly"]=true;dojo.provide("dojox.charting.plot2d.MarkersOnly");dojo.declare("dojox.charting.plot2d.MarkersOnly",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.Scatter"]){dojo._hasResource["dojox.charting.plot2d.Scatter"]=true;dojo.provide("dojox.charting.plot2d.Scatter");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_1bc=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Scatter",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",shadows:null,animate:null},optionalParams:{markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:""},constructor:function(_1bd,_1be){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_1be);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},render:function(dim,_1bf){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_1bf);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_1bc);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_1c0=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}var _1c1=t.next("marker",[this.opt,run]),s=run.group,_1c2,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);if(typeof run.data[0]=="number"){_1c2=dojo.map(run.data,function(v,i){return {x:ht(i+1)+_1bf.l,y:dim.height-_1bf.b-vt(v)};},this);}else{_1c2=dojo.map(run.data,function(v,i){return {x:ht(v.x)+_1bf.l,y:dim.height-_1bf.b-vt(v.y)};},this);}var _1c3=new Array(_1c2.length),_1c4=new Array(_1c2.length),_1c5=new Array(_1c2.length);dojo.forEach(_1c2,function(c,i){var _1c6=typeof run.data[i]=="number"?t.post(_1c1,"marker"):t.addMixin(_1c1,"marker",run.data[i],true),path="M"+c.x+" "+c.y+" "+_1c6.symbol;if(_1c6.marker.shadow){_1c3[i]=s.createPath("M"+(c.x+_1c6.marker.shadow.dx)+" "+(c.y+_1c6.marker.shadow.dy)+" "+_1c6.symbol).setStroke(_1c6.marker.shadow).setFill(_1c6.marker.shadow.color);if(this.animate){this._animateScatter(_1c3[i],dim.height-_1bf.b);}}if(_1c6.marker.outline){var _1c7=dc.makeStroke(_1c6.marker.outline);_1c7.width=2*_1c7.width+_1c6.marker.stroke.width;_1c5[i]=s.createPath(path).setStroke(_1c7);if(this.animate){this._animateScatter(_1c5[i],dim.height-_1bf.b);}}var _1c8=dc.makeStroke(_1c6.marker.stroke),fill=this._plotFill(_1c6.marker.fill,dim,_1bf);if(fill&&(fill.type==="linear"||fill.type=="radial")){var _1c9=dojox.gfx.gradutils.getColor(fill,{x:c.x,y:c.y});if(_1c8){_1c8.color=_1c9;}_1c4[i]=s.createPath(path).setStroke(_1c8).setFill(_1c9);}else{_1c4[i]=s.createPath(path).setStroke(_1c8).setFill(fill);}if(this.animate){this._animateScatter(_1c4[i],dim.height-_1bf.b);}},this);if(_1c4.length){run.dyn.stroke=_1c4[_1c4.length-1].getStroke();run.dyn.fill=_1c4[_1c4.length-1].getFill();}if(_1c0){var _1ca=new Array(_1c4.length);dojo.forEach(_1c4,function(s,i){var o={element:"marker",index:i,run:run,shape:s,outline:_1c5&&_1c5[i]||null,shadow:_1c3&&_1c3[i]||null,cx:_1c2[i].x,cy:_1c2[i].y};if(typeof run.data[0]=="number"){o.x=i+1;o.y=run.data[i];}else{o.x=run.data[i].x;o.y=run.data[i].y;}this._connectEvents(o);_1ca[i]=o;},this);this._eventSeries[run.name]=_1ca;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;return this;},_animateScatter:function(_1cb,_1cc){dojox.gfx.fx.animateTransform(dojo.delegate({shape:_1cb,duration:1200,transform:[{name:"translate",start:[0,_1cc],end:[0,0]},{name:"scale",start:[0,0],end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}if(!dojo._hasResource["dojox.lang.functional.sequence"]){dojo._hasResource["dojox.lang.functional.sequence"]=true;dojo.provide("dojox.lang.functional.sequence");(function(){var d=dojo,df=dojox.lang.functional;d.mixin(df,{repeat:function(n,f,z,o){o=o||d.global;f=df.lambda(f);var t=new Array(n),i=1;t[0]=z;for(;i<n;t[i]=z=f.call(o,z),++i){}return t;},until:function(pr,f,z,o){o=o||d.global;f=df.lambda(f);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(z),z=f.call(o,z)){}return t;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Stacked"]){dojo._hasResource["dojox.charting.plot2d.Stacked"]=true;dojo.provide("dojox.charting.plot2d.Stacked");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_1cd=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Stacked",dojox.charting.plot2d.Default,{getSeriesStats:function(){var _1ce=dc.collectStackedStats(this.series);this._maxRunLength=_1ce.hmax;return _1ce;},render:function(dim,_1cf){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){if(isNaN(v)){v=0;}acc[j]+=v;}}}if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_1cf);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_1cd);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_1d0=this.events(),ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _1d1=t.next(this.opt.areas?"area":"line",[this.opt,run],true),s=run.group,_1d2,_1d3=dojo.map(acc,function(v,i){return {x:ht(i+1)+_1cf.l,y:dim.height-_1cf.b-vt(v)};},this);var _1d4=this.opt.tension?dc.curve(_1d3,this.opt.tension):"";if(this.opt.areas){var _1d5=dojo.clone(_1d3);if(this.opt.tension){var p=dc.curve(_1d5,this.opt.tension);p+=" L"+_1d3[_1d3.length-1].x+","+(dim.height-_1cf.b)+" L"+_1d3[0].x+","+(dim.height-_1cf.b)+" L"+_1d3[0].x+","+_1d3[0].y;run.dyn.fill=s.createPath(p).setFill(_1d1.series.fill).getFill();}else{_1d5.push({x:_1d3[_1d3.length-1].x,y:dim.height-_1cf.b});_1d5.push({x:_1d3[0].x,y:dim.height-_1cf.b});_1d5.push(_1d3[0]);run.dyn.fill=s.createPolyline(_1d5).setFill(_1d1.series.fill).getFill();}}if(this.opt.lines||this.opt.markers){if(_1d1.series.outline){_1d2=dc.makeStroke(_1d1.series.outline);_1d2.width=2*_1d2.width+_1d1.series.stroke.width;}}if(this.opt.markers){run.dyn.marker=_1d1.symbol;}var _1d6,_1d7,_1d8;if(_1d1.series.shadow&&_1d1.series.stroke){var _1d9=_1d1.series.shadow,_1da=dojo.map(_1d3,function(c){return {x:c.x+_1d9.dx,y:c.y+_1d9.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_1da,this.opt.tension)).setStroke(_1d9).getStroke();}else{run.dyn.shadow=s.createPolyline(_1da).setStroke(_1d9).getStroke();}}if(this.opt.markers){_1d9=_1d1.marker.shadow;_1d8=dojo.map(_1da,function(c){return s.createPath("M"+c.x+" "+c.y+" "+_1d1.symbol).setStroke(_1d9).setFill(_1d9.color);},this);}}if(this.opt.lines){if(_1d2){if(this.opt.tension){run.dyn.outline=s.createPath(_1d4).setStroke(_1d2).getStroke();}else{run.dyn.outline=s.createPolyline(_1d3).setStroke(_1d2).getStroke();}}if(this.opt.tension){run.dyn.stroke=s.createPath(_1d4).setStroke(_1d1.series.stroke).getStroke();}else{run.dyn.stroke=s.createPolyline(_1d3).setStroke(_1d1.series.stroke).getStroke();}}if(this.opt.markers){_1d6=new Array(_1d3.length);_1d7=new Array(_1d3.length);_1d2=null;if(_1d1.marker.outline){_1d2=dc.makeStroke(_1d1.marker.outline);_1d2.width=2*_1d2.width+(_1d1.marker.stroke?_1d1.marker.stroke.width:0);}dojo.forEach(_1d3,function(c,i){var path="M"+c.x+" "+c.y+" "+_1d1.symbol;if(_1d2){_1d7[i]=s.createPath(path).setStroke(_1d2);}_1d6[i]=s.createPath(path).setStroke(_1d1.marker.stroke).setFill(_1d1.marker.fill);},this);if(_1d0){var _1db=new Array(_1d6.length);dojo.forEach(_1d6,function(s,i){var o={element:"marker",index:i,run:run,shape:s,outline:_1d7[i]||null,shadow:_1d8&&_1d8[i]||null,cx:_1d3[i].x,cy:_1d3[i].y,x:i+1,y:run.data[i]};this._connectEvents(o);_1db[i]=o;},this);this._eventSeries[run.name]=_1db;}else{delete this._eventSeries[run.name];}}run.dirty=false;for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){if(isNaN(v)){v=0;}acc[j]-=v;}}}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.StackedLines"]){dojo._hasResource["dojox.charting.plot2d.StackedLines"]=true;dojo.provide("dojox.charting.plot2d.StackedLines");dojo.declare("dojox.charting.plot2d.StackedLines",dojox.charting.plot2d.Stacked,{constructor:function(){this.opt.lines=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.StackedAreas"]){dojo._hasResource["dojox.charting.plot2d.StackedAreas"]=true;dojo.provide("dojox.charting.plot2d.StackedAreas");dojo.declare("dojox.charting.plot2d.StackedAreas",dojox.charting.plot2d.Stacked,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.Columns"]){dojo._hasResource["dojox.charting.plot2d.Columns"]=true;dojo.provide("dojox.charting.plot2d.Columns");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_1dc=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Columns",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_1dd,_1de){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_1de);du.updateWithPattern(this.opt,_1de,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},getSeriesStats:function(){var _1df=dc.collectSimpleStats(this.series);_1df.hmin-=0.5;_1df.hmax+=0.5;return _1df;},render:function(dim,_1e0){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_1e0);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_1dc);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_1e1,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_1e2=Math.max(0,this._vScaler.bounds.lower),_1e3=vt(_1e2),_1e4=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_1e1=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _1e5=t.next("column",[this.opt,run]),s=run.group,_1e6=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var _1e7=run.data[j];if(_1e7!==null){var v=typeof _1e7=="number"?_1e7:_1e7.y,vv=vt(v),_1e8=vv-_1e3,h=Math.abs(_1e8),_1e9=typeof _1e7!="number"?t.addMixin(_1e5,"column",_1e7,true):t.post(_1e5,"column");if(_1e1>=1&&h>=1){var rect={x:_1e0.l+ht(j+0.5)+gap,y:dim.height-_1e0.b-(v>_1e2?vv:_1e3),width:_1e1,height:h};var _1ea=this._plotFill(_1e9.series.fill,dim,_1e0);_1ea=this._shapeFill(_1ea,rect);var _1eb=s.createRect(rect).setFill(_1ea).setStroke(_1e9.series.stroke);run.dyn.fill=_1eb.getFill();run.dyn.stroke=_1eb.getStroke();if(_1e4){var o={element:"column",index:j,run:run,shape:_1eb,x:j+0.5,y:v};this._connectEvents(o);_1e6[j]=o;}if(this.animate){this._animateColumn(_1eb,dim.height-_1e0.b-_1e3,h);}}}}this._eventSeries[run.name]=_1e6;run.dirty=false;}this.dirty=false;return this;},_animateColumn:function(_1ec,_1ed,_1ee){dojox.gfx.fx.animateTransform(dojo.delegate({shape:_1ec,duration:1200,transform:[{name:"translate",start:[0,_1ed-(_1ed/_1ee)],end:[0,0]},{name:"scale",start:[1,1/_1ee],end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}if(!dojo._hasResource["dojox.charting.plot2d.StackedColumns"]){dojo._hasResource["dojox.charting.plot2d.StackedColumns"]=true;dojo.provide("dojox.charting.plot2d.StackedColumns");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_1ef=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.StackedColumns",dojox.charting.plot2d.Columns,{getSeriesStats:function(){var _1f0=dc.collectStackedStats(this.series);this._maxRunLength=_1f0.hmax;_1f0.hmin-=0.5;_1f0.hmax+=0.5;return _1f0;},render:function(dim,_1f1){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var _1f2=run.data[j];if(_1f2!==null){var v=typeof _1f2=="number"?_1f2:_1f2.y;if(isNaN(v)){v=0;}acc[j]+=v;}}}if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_1f1);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_1ef);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_1f3,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_1f4=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_1f3=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _1f5=t.next("column",[this.opt,run]),s=run.group,_1f6=new Array(acc.length);for(var j=0;j<acc.length;++j){var _1f2=run.data[j];if(_1f2!==null){var v=acc[j],_1f7=vt(v),_1f8=typeof _1f2!="number"?t.addMixin(_1f5,"column",_1f2,true):t.post(_1f5,"column");if(_1f3>=1&&_1f7>=1){var rect={x:_1f1.l+ht(j+0.5)+gap,y:dim.height-_1f1.b-vt(v),width:_1f3,height:_1f7};var _1f9=this._plotFill(_1f8.series.fill,dim,_1f1);_1f9=this._shapeFill(_1f9,rect);var _1fa=s.createRect(rect).setFill(_1f9).setStroke(_1f8.series.stroke);run.dyn.fill=_1fa.getFill();run.dyn.stroke=_1fa.getStroke();if(_1f4){var o={element:"column",index:j,run:run,shape:_1fa,x:j+0.5,y:v};this._connectEvents(o);_1f6[j]=o;}if(this.animate){this._animateColumn(_1fa,dim.height-_1f1.b,_1f7);}}}}this._eventSeries[run.name]=_1f6;run.dirty=false;for(var j=0;j<run.data.length;++j){var _1f2=run.data[j];if(_1f2!==null){var v=typeof _1f2=="number"?_1f2:_1f2.y;if(isNaN(v)){v=0;}acc[j]-=v;}}}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.ClusteredColumns"]){dojo._hasResource["dojox.charting.plot2d.ClusteredColumns"]=true;dojo.provide("dojox.charting.plot2d.ClusteredColumns");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_1fb=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.ClusteredColumns",dojox.charting.plot2d.Columns,{render:function(dim,_1fc){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_1fc);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_1fb);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_1fd,_1fe,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_1ff=Math.max(0,this._vScaler.bounds.lower),_200=vt(_1ff),_201=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;_1fd=_1fe=f.size;for(var i=0;i<this.series.length;++i){var run=this.series[i],_202=_1fe*i;if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _203=t.next("column",[this.opt,run]),s=run.group,_204=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var _205=run.data[j];if(_205!==null){var v=typeof _205=="number"?_205:_205.y,vv=vt(v),_206=vv-_200,h=Math.abs(_206),_207=typeof _205!="number"?t.addMixin(_203,"column",_205,true):t.post(_203,"column");if(_1fd>=1&&h>=1){var rect={x:_1fc.l+ht(j+0.5)+gap+_202,y:dim.height-_1fc.b-(v>_1ff?vv:_200),width:_1fd,height:h};var _208=this._plotFill(_207.series.fill,dim,_1fc);_208=this._shapeFill(_208,rect);var _209=s.createRect(rect).setFill(_208).setStroke(_207.series.stroke);run.dyn.fill=_209.getFill();run.dyn.stroke=_209.getStroke();if(_201){var o={element:"column",index:j,run:run,shape:_209,x:j+0.5,y:v};this._connectEvents(o);_204[j]=o;}if(this.animate){this._animateColumn(_209,dim.height-_1fc.b-_200,h);}}}}this._eventSeries[run.name]=_204;run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Bars"]){dojo._hasResource["dojox.charting.plot2d.Bars"]=true;dojo.provide("dojox.charting.plot2d.Bars");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_20a=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Bars",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_20b,_20c){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_20c);du.updateWithPattern(this.opt,_20c,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},getSeriesStats:function(){var _20d=dc.collectSimpleStats(this.series),t;_20d.hmin-=0.5;_20d.hmax+=0.5;t=_20d.hmin,_20d.hmin=_20d.vmin,_20d.vmin=t;t=_20d.hmax,_20d.hmax=_20d.vmax,_20d.vmax=t;return _20d;},render:function(dim,_20e){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_20e);}this.dirty=this.isDirty();this.resetEvents();if(this.dirty){dojo.forEach(this.series,_20a);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_20f,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_210=Math.max(0,this._hScaler.bounds.lower),_211=ht(_210),_212=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;_20f=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _213=t.next("bar",[this.opt,run]),s=run.group,_214=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var _215=run.data[j];if(_215!==null){var v=typeof _215=="number"?_215:_215.y,hv=ht(v),_216=hv-_211,w=Math.abs(_216),_217=typeof _215!="number"?t.addMixin(_213,"bar",_215,true):t.post(_213,"bar");if(w>=1&&_20f>=1){var rect={x:_20e.l+(v<_210?hv:_211),y:dim.height-_20e.b-vt(j+1.5)+gap,width:w,height:_20f};var _218=this._plotFill(_217.series.fill,dim,_20e);_218=this._shapeFill(_218,rect);var _219=s.createRect(rect).setFill(_218).setStroke(_217.series.stroke);run.dyn.fill=_219.getFill();run.dyn.stroke=_219.getStroke();if(_212){var o={element:"bar",index:j,run:run,shape:_219,x:v,y:j+1.5};this._connectEvents(o);_214[j]=o;}if(this.animate){this._animateBar(_219,_20e.l+_211,-w);}}}}this._eventSeries[run.name]=_214;run.dirty=false;}this.dirty=false;return this;},_animateBar:function(_21a,_21b,_21c){dojox.gfx.fx.animateTransform(dojo.delegate({shape:_21a,duration:1200,transform:[{name:"translate",start:[_21b-(_21b/_21c),0],end:[0,0]},{name:"scale",start:[1/_21c,1],end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}if(!dojo._hasResource["dojox.charting.plot2d.StackedBars"]){dojo._hasResource["dojox.charting.plot2d.StackedBars"]=true;dojo.provide("dojox.charting.plot2d.StackedBars");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_21d=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.StackedBars",dojox.charting.plot2d.Bars,{getSeriesStats:function(){var _21e=dc.collectStackedStats(this.series),t;this._maxRunLength=_21e.hmax;_21e.hmin-=0.5;_21e.hmax+=0.5;t=_21e.hmin,_21e.hmin=_21e.vmin,_21e.vmin=t;t=_21e.hmax,_21e.hmax=_21e.vmax,_21e.vmax=t;return _21e;},render:function(dim,_21f){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var _220=run.data[j];if(_220!==null){var v=typeof _220=="number"?_220:_220.y;if(isNaN(v)){v=0;}acc[j]+=v;}}}if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_21f);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_21d);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_221,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_222=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;_221=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _223=t.next("bar",[this.opt,run]),s=run.group,_224=new Array(acc.length);for(var j=0;j<acc.length;++j){var _220=run.data[j];if(_220!==null){var v=acc[j],_225=ht(v),_226=typeof _220!="number"?t.addMixin(_223,"bar",_220,true):t.post(_223,"bar");if(_225>=1&&_221>=1){var rect={x:_21f.l,y:dim.height-_21f.b-vt(j+1.5)+gap,width:_225,height:_221};var _227=this._plotFill(_226.series.fill,dim,_21f);_227=this._shapeFill(_227,rect);var _228=s.createRect(rect).setFill(_227).setStroke(_226.series.stroke);run.dyn.fill=_228.getFill();run.dyn.stroke=_228.getStroke();if(_222){var o={element:"bar",index:j,run:run,shape:_228,x:v,y:j+1.5};this._connectEvents(o);_224[j]=o;}if(this.animate){this._animateBar(_228,_21f.l,-_225);}}}}this._eventSeries[run.name]=_224;run.dirty=false;for(var j=0;j<run.data.length;++j){var _220=run.data[j];if(_220!==null){var v=typeof _220=="number"?_220:_220.y;if(isNaN(v)){v=0;}acc[j]-=v;}}}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.ClusteredBars"]){dojo._hasResource["dojox.charting.plot2d.ClusteredBars"]=true;dojo.provide("dojox.charting.plot2d.ClusteredBars");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_229=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.ClusteredBars",dojox.charting.plot2d.Bars,{render:function(dim,_22a){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_22a);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_229);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_22b,_22c,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_22d=Math.max(0,this._hScaler.bounds.lower),_22e=ht(_22d),_22f=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;_22b=_22c=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i],_230=_22c*(this.series.length-i-1);if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _231=t.next("bar",[this.opt,run]),s=run.group,_232=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var _233=run.data[j];if(_233!==null){var v=typeof _233=="number"?_233:_233.y,hv=ht(v),_234=hv-_22e,w=Math.abs(_234),_235=typeof _233!="number"?t.addMixin(_231,"bar",_233,true):t.post(_231,"bar");if(w>=1&&_22b>=1){var rect={x:_22a.l+(v<_22d?hv:_22e),y:dim.height-_22a.b-vt(j+1.5)+gap+_230,width:w,height:_22b};var _236=this._plotFill(_235.series.fill,dim,_22a);_236=this._shapeFill(_236,rect);var _237=s.createRect(rect).setFill(_236).setStroke(_235.series.stroke);run.dyn.fill=_237.getFill();run.dyn.stroke=_237.getStroke();if(_22f){var o={element:"bar",index:j,run:run,shape:_237,x:v,y:j+1.5};this._connectEvents(o);_232[j]=o;}if(this.animate){this._animateBar(_237,_22a.l+_22e,-_234);}}}}this._eventSeries[run.name]=_232;run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Grid"]){dojo._hasResource["dojox.charting.plot2d.Grid"]=true;dojo.provide("dojox.charting.plot2d.Grid");(function(){var du=dojox.lang.utils,dc=dojox.charting.plot2d.common;dojo.declare("dojox.charting.plot2d.Grid",dojox.charting.Element,{defaultParams:{hAxis:"x",vAxis:"y",hMajorLines:true,hMinorLines:false,vMajorLines:true,vMinorLines:false,hStripes:"none",vStripes:"none",animate:null},optionalParams:{},constructor:function(_238,_239){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_239);this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.dirty=true;this.animate=this.opt.animate;this.zoom=null,this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};},clear:function(){this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},addSeries:function(run){return this;},getSeriesStats:function(){return dojo.delegate(dc.defaultStats);},initializeScalers:function(){return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},performZoom:function(dim,_23a){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,_23b=dim.height-_23a.b,_23c=this._hAxis.getScaler().bounds,_23d=(_23c.from-_23c.lower)*_23c.scale,_23e=this._vAxis.getScaler().bounds,_23f=(_23e.from-_23e.lower)*_23e.scale;rVScale=vs/this.lastWindow.vscale,rHScale=hs/this.lastWindow.hscale,rXOffset=(this.lastWindow.xoffset-_23d)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),rYOffset=(_23f-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),shape=this.group,anim=dojox.gfx.fx.animateTransform(dojo.delegate({shape:shape,duration:1200,transform:[{name:"translate",start:[0,0],end:[_23a.l*(1-rHScale),_23b*(1-rVScale)]},{name:"scale",start:[1,1],end:[rHScale,rVScale]},{name:"original"},{name:"translate",start:[0,0],end:[rXOffset,rYOffset]}]},this.zoom));dojo.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:_23d,yoffset:_23f});this.zoomQueue.push(anim);dojo.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}return this;},getRequiredColors:function(){return 0;},render:function(dim,_240){if(this.zoom){return this.performZoom(dim,_240);}this.dirty=this.isDirty();if(!this.dirty){return this;}this.cleanGroup();var s=this.group,ta=this.chart.theme.axis;try{var _241=this._vAxis.getScaler(),vt=_241.scaler.getTransformerFromModel(_241),_242=this._vAxis.getTicks();if(this.opt.hMinorLines){dojo.forEach(_242.minor,function(tick){var y=dim.height-_240.b-vt(tick.value);var _243=s.createLine({x1:_240.l,y1:y,x2:dim.width-_240.r,y2:y}).setStroke(ta.minorTick);if(this.animate){this._animateGrid(_243,"h",_240.l,_240.r+_240.l-dim.width);}},this);}if(this.opt.hMajorLines){dojo.forEach(_242.major,function(tick){var y=dim.height-_240.b-vt(tick.value);var _244=s.createLine({x1:_240.l,y1:y,x2:dim.width-_240.r,y2:y}).setStroke(ta.majorTick);if(this.animate){this._animateGrid(_244,"h",_240.l,_240.r+_240.l-dim.width);}},this);}}catch(e){}try{var _245=this._hAxis.getScaler(),ht=_245.scaler.getTransformerFromModel(_245),_242=this._hAxis.getTicks();if(_242&&this.opt.vMinorLines){dojo.forEach(_242.minor,function(tick){var x=_240.l+ht(tick.value);var _246=s.createLine({x1:x,y1:_240.t,x2:x,y2:dim.height-_240.b}).setStroke(ta.minorTick);if(this.animate){this._animateGrid(_246,"v",dim.height-_240.b,dim.height-_240.b-_240.t);}},this);}if(_242&&this.opt.vMajorLines){dojo.forEach(_242.major,function(tick){var x=_240.l+ht(tick.value);var _247=s.createLine({x1:x,y1:_240.t,x2:x,y2:dim.height-_240.b}).setStroke(ta.majorTick);if(this.animate){this._animateGrid(_247,"v",dim.height-_240.b,dim.height-_240.b-_240.t);}},this);}}catch(e){}this.dirty=false;return this;},_animateGrid:function(_248,type,_249,size){var _24a=type=="h"?[_249,0]:[0,_249];var _24b=type=="h"?[1/size,1]:[1,1/size];dojox.gfx.fx.animateTransform(dojo.delegate({shape:_248,duration:1200,transform:[{name:"translate",start:_24a,end:[0,0]},{name:"scale",start:_24b,end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Pie"]){dojo._hasResource["dojox.charting.plot2d.Pie"]=true;dojo.provide("dojox.charting.plot2d.Pie");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,da=dojox.charting.axis2d.common,g=dojox.gfx,m=g.matrix,_24c=0.2;dojo.declare("dojox.charting.plot2d.Pie",[dojox.charting.Element,dojox.charting.plot2d._PlotEvents],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true,radGrad:"native",fanSize:5,startAngle:0},optionalParams:{radius:0,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_24d,_24e){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_24e);du.updateWithPattern(this.opt,_24e,this.optionalParams);this.run=null;this.dyn=[];},clear:function(){this.dirty=true;this.dyn=[];this.run=null;return this;},setAxis:function(axis){return this;},addSeries:function(run){this.run=run;return this;},getSeriesStats:function(){return dojo.delegate(dc.defaultStats);},initializeScalers:function(){return this;},getRequiredColors:function(){return this.run?this.run.data.length:0;},render:function(dim,_24f){if(!this.dirty){return this;}this.resetEvents();this.dirty=false;this._eventSeries={};this.cleanGroup();var s=this.group,t=this.chart.theme;if(!this.run||!this.run.data.length){return this;}var rx=(dim.width-_24f.l-_24f.r)/2,ry=(dim.height-_24f.t-_24f.b)/2,r=Math.min(rx,ry),_250="font" in this.opt?this.opt.font:t.axis.font,size=_250?g.normalizedLength(g.splitFontString(_250).size):0,_251="fontColor" in this.opt?this.opt.fontColor:t.axis.fontColor,_252=m._degToRad(this.opt.startAngle),_253=_252,step,_254,_255,_256,_257,_258,run=this.run.data,_259=this.events();if(typeof run[0]=="number"){_254=df.map(run,"x ? Math.max(x, 0) : 0");if(df.every(_254,"<= 0")){return this;}_255=df.map(_254,"/this",df.foldl(_254,"+",0));if(this.opt.labels){_256=dojo.map(_255,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}else{_254=df.map(run,"x ? Math.max(x.y, 0) : 0");if(df.every(_254,"<= 0")){return this;}_255=df.map(_254,"/this",df.foldl(_254,"+",0));if(this.opt.labels){_256=dojo.map(_255,function(x,i){if(x<=0){return "";}var v=run[i];return "text" in v?v.text:this._getLabel(x*100)+"%";},this);}}var _25a=df.map(run,function(v,i){if(v===null||typeof v=="number"){return t.next("slice",[this.opt,this.run],true);}return t.next("slice",[this.opt,this.run,v],true);},this);if(this.opt.labels){_257=df.foldl1(df.map(_256,function(_25b,i){var font=_25a[i].series.font;return dojox.gfx._base._getTextBox(_25b,{font:font}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*_257,ry-size)+this.opt.labelOffset;}_258=r-this.opt.labelOffset;}if("radius" in this.opt){r=this.opt.radius;_258=r-this.opt.labelOffset;}var _25c={cx:_24f.l+rx,cy:_24f.t+ry,r:r};this.dyn=[];var _25d=new Array(_255.length);dojo.some(_255,function(_25e,i){if(_25e<=0){return false;}var v=run[i],_25f=_25a[i],_260;if(_25e>=1){_260=this._plotFill(_25f.series.fill,dim,_24f);_260=this._shapeFill(_260,{x:_25c.cx-_25c.r,y:_25c.cy-_25c.r,width:2*_25c.r,height:2*_25c.r});_260=this._pseudoRadialFill(_260,{x:_25c.cx,y:_25c.cy},_25c.r);var _261=s.createCircle(_25c).setFill(_260).setStroke(_25f.series.stroke);this.dyn.push({fill:_260,stroke:_25f.series.stroke});if(_259){var o={element:"slice",index:i,run:this.run,shape:_261,x:i,y:typeof v=="number"?v:v.y,cx:_25c.cx,cy:_25c.cy,cr:r};this._connectEvents(o);_25d[i]=o;}return true;}var end=_253+_25e*2*Math.PI;if(i+1==_255.length){end=_252+2*Math.PI;}var step=end-_253,x1=_25c.cx+r*Math.cos(_253),y1=_25c.cy+r*Math.sin(_253),x2=_25c.cx+r*Math.cos(end),y2=_25c.cy+r*Math.sin(end);var _262=m._degToRad(this.opt.fanSize);if(_25f.series.fill&&_25f.series.fill.type==="radial"&&this.opt.radGrad==="fan"&&step>_262){var _263=s.createGroup(),_264=Math.ceil(step/_262),_265=step/_264;_260=this._shapeFill(_25f.series.fill,{x:_25c.cx-_25c.r,y:_25c.cy-_25c.r,width:2*_25c.r,height:2*_25c.r});for(var j=0;j<_264;++j){var _266=j==0?x1:_25c.cx+r*Math.cos(_253+(j-_24c)*_265),_267=j==0?y1:_25c.cy+r*Math.sin(_253+(j-_24c)*_265),_268=j==_264-1?x2:_25c.cx+r*Math.cos(_253+(j+1+_24c)*_265),_269=j==_264-1?y2:_25c.cy+r*Math.sin(_253+(j+1+_24c)*_265),fan=_263.createPath({}).moveTo(_25c.cx,_25c.cy).lineTo(_266,_267).arcTo(r,r,0,_265>Math.PI,true,_268,_269).lineTo(_25c.cx,_25c.cy).closePath().setFill(this._pseudoRadialFill(_260,{x:_25c.cx,y:_25c.cy},r,_253+(j+0.5)*_265,_253+(j+0.5)*_265));}_263.createPath({}).moveTo(_25c.cx,_25c.cy).lineTo(x1,y1).arcTo(r,r,0,step>Math.PI,true,x2,y2).lineTo(_25c.cx,_25c.cy).closePath().setStroke(_25f.series.stroke);_261=_263;}else{_261=s.createPath({}).moveTo(_25c.cx,_25c.cy).lineTo(x1,y1).arcTo(r,r,0,step>Math.PI,true,x2,y2).lineTo(_25c.cx,_25c.cy).closePath().setStroke(_25f.series.stroke);var _260=_25f.series.fill;if(_260&&_260.type==="radial"){_260=this._shapeFill(_260,{x:_25c.cx-_25c.r,y:_25c.cy-_25c.r,width:2*_25c.r,height:2*_25c.r});if(this.opt.radGrad==="linear"){_260=this._pseudoRadialFill(_260,{x:_25c.cx,y:_25c.cy},r,_253,end);}}else{if(_260&&_260.type==="linear"){_260=this._plotFill(_260,dim,_24f);_260=this._shapeFill(_260,_261.getBoundingBox());}}_261.setFill(_260);}this.dyn.push({fill:_260,stroke:_25f.series.stroke});if(_259){var o={element:"slice",index:i,run:this.run,shape:_261,x:i,y:typeof v=="number"?v:v.y,cx:_25c.cx,cy:_25c.cy,cr:r};this._connectEvents(o);_25d[i]=o;}_253=end;return false;},this);if(this.opt.labels){_253=_252;dojo.some(_255,function(_26a,i){if(_26a<=0){return false;}var _26b=_25a[i];if(_26a>=1){var v=run[i],elem=da.createText[this.opt.htmlLabels&&dojox.gfx.renderer!="vml"?"html":"gfx"](this.chart,s,_25c.cx,_25c.cy+size/2,"middle",_256[i],_26b.series.font,_26b.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(elem);}return true;}var end=_253+_26a*2*Math.PI,v=run[i];if(i+1==_255.length){end=_252+2*Math.PI;}var _26c=(_253+end)/2,x=_25c.cx+_258*Math.cos(_26c),y=_25c.cy+_258*Math.sin(_26c)+size/2;var elem=da.createText[this.opt.htmlLabels&&dojox.gfx.renderer!="vml"?"html":"gfx"](this.chart,s,x,y,"middle",_256[i],_26b.series.font,_26b.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(elem);}_253=end;return false;},this);}var esi=0;this._eventSeries[this.run.name]=df.map(run,function(v){return v<=0?null:_25d[esi++];});return this;},_getLabel:function(_26d){return this.opt.fixed?dojo.number.format(_26d,{places:this.opt.precision}):_26d.toString();}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Bubble"]){dojo._hasResource["dojox.charting.plot2d.Bubble"]=true;dojo.provide("dojox.charting.plot2d.Bubble");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_26e=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Bubble",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",animate:null},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_26f,_270){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_270);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},render:function(dim,_271){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_271);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_26e);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_272=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}if(typeof run.data[0]=="number"){console.warn("dojox.charting.plot2d.Bubble: the data in the following series cannot be rendered as a bubble chart; ",run);continue;}var _273=t.next("circle",[this.opt,run]),s=run.group,_274=dojo.map(run.data,function(v,i){return v?{x:ht(v.x)+_271.l,y:dim.height-_271.b-vt(v.y),radius:this._vScaler.bounds.scale*(v.size/2)}:null;},this);var _275=null,_276=null,_277=null;if(_273.series.shadow){_277=dojo.map(_274,function(item){if(item!==null){var _278=t.addMixin(_273,"circle",item,true),_279=_278.series.shadow;var _27a=s.createCircle({cx:item.x+_279.dx,cy:item.y+_279.dy,r:item.radius}).setStroke(_279).setFill(_279.color);if(this.animate){this._animateBubble(_27a,dim.height-_271.b,item.radius);}return _27a;}return null;},this);if(_277.length){run.dyn.shadow=_277[_277.length-1].getStroke();}}if(_273.series.outline){_276=dojo.map(_274,function(item){if(item!==null){var _27b=t.addMixin(_273,"circle",item,true),_27c=dc.makeStroke(_27b.series.outline);_27c.width=2*_27c.width+_273.series.stroke.width;var _27d=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_27c);if(this.animate){this._animateBubble(_27d,dim.height-_271.b,item.radius);}return _27d;}return null;},this);if(_276.length){run.dyn.outline=_276[_276.length-1].getStroke();}}_275=dojo.map(_274,function(item){if(item!==null){var _27e=t.addMixin(_273,"circle",item,true),rect={x:item.x-item.radius,y:item.y-item.radius,width:2*item.radius,height:2*item.radius};var _27f=this._plotFill(_27e.series.fill,dim,_271);_27f=this._shapeFill(_27f,rect);var _280=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setFill(_27f).setStroke(_27e.series.stroke);if(this.animate){this._animateBubble(_280,dim.height-_271.b,item.radius);}return _280;}return null;},this);if(_275.length){run.dyn.fill=_275[_275.length-1].getFill();run.dyn.stroke=_275[_275.length-1].getStroke();}if(_272){var _281=new Array(_275.length);dojo.forEach(_275,function(s,i){if(s!==null){var o={element:"circle",index:i,run:run,shape:s,outline:_276&&_276[i]||null,shadow:_277&&_277[i]||null,x:run.data[i].x,y:run.data[i].y,r:run.data[i].size/2,cx:_274[i].x,cy:_274[i].y,cr:_274[i].radius};this._connectEvents(o);_281[i]=o;}},this);this._eventSeries[run.name]=_281;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;return this;},_animateBubble:function(_282,_283,size){dojox.gfx.fx.animateTransform(dojo.delegate({shape:_282,duration:1200,transform:[{name:"translate",start:[0,_283],end:[0,0]},{name:"scale",start:[0,1/size],end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Candlesticks"]){dojo._hasResource["dojox.charting.plot2d.Candlesticks"]=true;dojo.provide("dojox.charting.plot2d.Candlesticks");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_284=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Candlesticks",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_285,_286){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_286);du.updateWithPattern(this.opt,_286,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},collectStats:function(_287){var _288=dojo.delegate(dc.defaultStats);for(var i=0;i<_287.length;i++){var run=_287[i];if(!run.data.length){continue;}var _289=_288.vmin,_28a=_288.vmax;if(!("ymin" in run)||!("ymax" in run)){dojo.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_288.hmin=Math.min(_288.hmin,x);_288.hmax=Math.max(_288.hmax,x);_288.vmin=Math.min(_288.vmin,val.open,val.close,val.high,val.low);_288.vmax=Math.max(_288.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_288.vmin=Math.min(_289,run.ymin);}if("ymax" in run){_288.vmax=Math.max(_28a,run.ymax);}}return _288;},getSeriesStats:function(){var _28b=this.collectStats(this.series);_28b.hmin-=0.5;_28b.hmax+=0.5;return _28b;},render:function(dim,_28c){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_28c);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_284);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_28d,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_28e=Math.max(0,this._vScaler.bounds.lower),_28f=vt(_28e),_290=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_28d=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _291=t.next("candlestick",[this.opt,run]),s=run.group,_292=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _293=t.addMixin(_291,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_28c.l+gap,y=dim.height-_28c.b,open=vt(v.open),_294=vt(v.close),high=vt(v.high),low=vt(v.low);if("mid" in v){var mid=vt(v.mid);}if(low>high){var tmp=high;high=low;low=tmp;}if(_28d>=1){var _295=open>_294;var line={x1:_28d/2,x2:_28d/2,y1:y-high,y2:y-low},rect={x:0,y:y-Math.max(open,_294),width:_28d,height:Math.max(_295?open-_294:_294-open,1)};shape=s.createGroup();shape.setTransform({dx:x,dy:0});var _296=shape.createGroup();_296.createLine(line).setStroke(_293.series.stroke);_296.createRect(rect).setStroke(_293.series.stroke).setFill(_295?_293.series.fill:"white");if("mid" in v){_296.createLine({x1:(_293.series.stroke.width||1),x2:_28d-(_293.series.stroke.width||1),y1:y-mid,y2:y-mid}).setStroke(_295?"white":_293.series.stroke);}run.dyn.fill=_293.series.fill;run.dyn.stroke=_293.series.stroke;if(_290){var o={element:"candlestick",index:j,run:run,shape:_296,x:x,y:y-Math.max(open,_294),cx:_28d/2,cy:(y-Math.max(open,_294))+(Math.max(_295?open-_294:_294-open,1)/2),width:_28d,height:Math.max(_295?open-_294:_294-open,1),data:v};this._connectEvents(o);_292[j]=o;}}if(this.animate){this._animateCandlesticks(shape,y-low,high-low);}}}this._eventSeries[run.name]=_292;run.dirty=false;}this.dirty=false;return this;},_animateCandlesticks:function(_297,_298,_299){dojox.gfx.fx.animateTransform(dojo.delegate({shape:_297,duration:1200,transform:[{name:"translate",start:[0,_298-(_298/_299)],end:[0,0]},{name:"scale",start:[1,1/_299],end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}if(!dojo._hasResource["dojox.charting.plot2d.OHLC"]){dojo._hasResource["dojox.charting.plot2d.OHLC"]=true;dojo.provide("dojox.charting.plot2d.OHLC");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_29a=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.OHLC",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_29b,_29c){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_29c);du.updateWithPattern(this.opt,_29c,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},collectStats:function(_29d){var _29e=dojo.delegate(dc.defaultStats);for(var i=0;i<_29d.length;i++){var run=_29d[i];if(!run.data.length){continue;}var _29f=_29e.vmin,_2a0=_29e.vmax;if(!("ymin" in run)||!("ymax" in run)){dojo.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_29e.hmin=Math.min(_29e.hmin,x);_29e.hmax=Math.max(_29e.hmax,x);_29e.vmin=Math.min(_29e.vmin,val.open,val.close,val.high,val.low);_29e.vmax=Math.max(_29e.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_29e.vmin=Math.min(_29f,run.ymin);}if("ymax" in run){_29e.vmax=Math.max(_2a0,run.ymax);}}return _29e;},getSeriesStats:function(){var _2a1=this.collectStats(this.series);_2a1.hmin-=0.5;_2a1.hmax+=0.5;return _2a1;},render:function(dim,_2a2){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_2a2);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_29a);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_2a3,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_2a4=Math.max(0,this._vScaler.bounds.lower),_2a5=vt(_2a4),_2a6=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_2a3=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _2a7=t.next("candlestick",[this.opt,run]),s=run.group,_2a8=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _2a9=t.addMixin(_2a7,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_2a2.l+gap,y=dim.height-_2a2.b,open=vt(v.open),_2aa=vt(v.close),high=vt(v.high),low=vt(v.low);if(low>high){var tmp=high;high=low;low=tmp;}if(_2a3>=1){var hl={x1:_2a3/2,x2:_2a3/2,y1:y-high,y2:y-low},op={x1:0,x2:((_2a3/2)+((_2a9.series.stroke.width||1)/2)),y1:y-open,y2:y-open},cl={x1:((_2a3/2)-((_2a9.series.stroke.width||1)/2)),x2:_2a3,y1:y-_2aa,y2:y-_2aa};shape=s.createGroup();shape.setTransform({dx:x,dy:0});var _2ab=shape.createGroup();_2ab.createLine(hl).setStroke(_2a9.series.stroke);_2ab.createLine(op).setStroke(_2a9.series.stroke);_2ab.createLine(cl).setStroke(_2a9.series.stroke);run.dyn.stroke=_2a9.series.stroke;if(_2a6){var o={element:"candlestick",index:j,run:run,shape:_2ab,x:x,y:y-Math.max(open,_2aa),cx:_2a3/2,cy:(y-Math.max(open,_2aa))+(Math.max(open>_2aa?open-_2aa:_2aa-open,1)/2),width:_2a3,height:Math.max(open>_2aa?open-_2aa:_2aa-open,1),data:v};this._connectEvents(o);_2a8[j]=o;}}if(this.animate){this._animateOHLC(shape,y-low,high-low);}}}this._eventSeries[run.name]=_2a8;run.dirty=false;}this.dirty=false;return this;},_animateOHLC:function(_2ac,_2ad,_2ae){dojox.gfx.fx.animateTransform(dojo.delegate({shape:_2ac,duration:1200,transform:[{name:"translate",start:[0,_2ad-(_2ad/_2ae)],end:[0,0]},{name:"scale",start:[1,1/_2ae],end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}if(!dojo._hasResource["dojox.charting.Chart2D"]){dojo._hasResource["dojox.charting.Chart2D"]=true;dojo.provide("dojox.charting.Chart2D");(function(){var df=dojox.lang.functional,dc=dojox.charting,_2af=df.lambda("item.clear()"),_2b0=df.lambda("item.purgeGroup()"),_2b1=df.lambda("item.destroy()"),_2b2=df.lambda("item.dirty = false"),_2b3=df.lambda("item.dirty = true"),_2b4=df.lambda("item.name");dojo.declare("dojox.charting.Chart2D",null,{constructor:function(node,_2b5){if(!_2b5){_2b5={};}this.margins=_2b5.margins?_2b5.margins:{l:10,t:10,r:10,b:10};this.stroke=_2b5.stroke;this.fill=_2b5.fill;this.delayInMs=_2b5.delayInMs||200;this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.coords=null;this.node=dojo.byId(node);var box=dojo.marginBox(node);this.surface=dojox.gfx.createSurface(this.node,box.w||400,box.h||300);},destroy:function(){dojo.forEach(this.series,_2b1);dojo.forEach(this.stack,_2b1);df.forIn(this.axes,_2b1);this.surface.destroy();},getCoords:function(){if(!this.coords){this.coords=dojo.coords(this.node,true);}return this.coords;},setTheme:function(_2b6){this.theme=_2b6.clone();this.dirty=true;return this;},addAxis:function(name,_2b7){var axis;if(!_2b7||!("type" in _2b7)){axis=new dc.axis2d.Default(this,_2b7);}else{axis=typeof _2b7.type=="string"?new dc.axis2d[_2b7.type](this,_2b7):new _2b7.type(this,_2b7);}axis.name=name;axis.dirty=true;if(name in this.axes){this.axes[name].destroy();}this.axes[name]=axis;this.dirty=true;return this;},getAxis:function(name){return this.axes[name];},removeAxis:function(name){if(name in this.axes){this.axes[name].destroy();delete this.axes[name];this.dirty=true;}return this;},addPlot:function(name,_2b8){var plot;if(!_2b8||!("type" in _2b8)){plot=new dc.plot2d.Default(this,_2b8);}else{plot=typeof _2b8.type=="string"?new dc.plot2d[_2b8.type](this,_2b8):new _2b8.type(this,_2b8);}plot.name=name;plot.dirty=true;if(name in this.plots){this.stack[this.plots[name]].destroy();this.stack[this.plots[name]]=plot;}else{this.plots[name]=this.stack.length;this.stack.push(plot);}this.dirty=true;return this;},removePlot:function(name){if(name in this.plots){var _2b9=this.plots[name];delete this.plots[name];this.stack[_2b9].destroy();this.stack.splice(_2b9,1);df.forIn(this.plots,function(idx,name,_2ba){if(idx>_2b9){_2ba[name]=idx-1;}});this.dirty=true;}return this;},getPlotOrder:function(){return df.map(this.stack,_2b4);},setPlotOrder:function(_2bb){var _2bc={},_2bd=df.filter(_2bb,function(name){if(!(name in this.plots)||(name in _2bc)){return false;}_2bc[name]=1;return true;},this);if(_2bd.length<this.stack.length){df.forEach(this.stack,function(plot){var name=plot.name;if(!(name in _2bc)){_2bd.push(name);}});}var _2be=df.map(_2bd,function(name){return this.stack[this.plots[name]];},this);df.forEach(_2be,function(plot,i){this.plots[plot.name]=i;},this);this.stack=_2be;this.dirty=true;return this;},movePlotToFront:function(name){if(name in this.plots){var _2bf=this.plots[name];if(_2bf){var _2c0=this.getPlotOrder();_2c0.splice(_2bf,1);_2c0.unshift(name);return this.setPlotOrder(_2c0);}}return this;},movePlotToBack:function(name){if(name in this.plots){var _2c1=this.plots[name];if(_2c1<this.stack.length-1){var _2c2=this.getPlotOrder();_2c2.splice(_2c1,1);_2c2.push(name);return this.setPlotOrder(_2c2);}}return this;},addSeries:function(name,data,_2c3){var run=new dc.Series(this,data,_2c3);run.name=name;if(name in this.runs){this.series[this.runs[name]].destroy();this.series[this.runs[name]]=run;}else{this.runs[name]=this.series.length;this.series.push(run);}this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},removeSeries:function(name){if(name in this.runs){var _2c4=this.runs[name],_2c5=this.series[_2c4].plot;delete this.runs[name];this.series[_2c4].destroy();this.series.splice(_2c4,1);df.forIn(this.runs,function(idx,name,runs){if(idx>_2c4){runs[name]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(name,data){if(name in this.runs){var run=this.series[this.runs[name]];run.update(data);this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}return this;},getSeriesOrder:function(_2c6){return df.map(df.filter(this.series,function(run){return run.plot==_2c6;}),_2b4);},setSeriesOrder:function(_2c7){var _2c8,_2c9={},_2ca=df.filter(_2c7,function(name){if(!(name in this.runs)||(name in _2c9)){return false;}var run=this.series[this.runs[name]];if(_2c8){if(run.plot!=_2c8){return false;}}else{_2c8=run.plot;}_2c9[name]=1;return true;},this);df.forEach(this.series,function(run){var name=run.name;if(!(name in _2c9)&&run.plot==_2c8){_2ca.push(name);}});var _2cb=df.map(_2ca,function(name){return this.series[this.runs[name]];},this);this.series=_2cb.concat(df.filter(this.series,function(run){return run.plot!=_2c8;}));df.forEach(this.series,function(run,i){this.runs[run.name]=i;},this);this.dirty=true;return this;},moveSeriesToFront:function(name){if(name in this.runs){var _2cc=this.runs[name],_2cd=this.getSeriesOrder(this.series[_2cc].plot);if(name!=_2cd[0]){_2cd.splice(_2cc,1);_2cd.unshift(name);return this.setSeriesOrder(_2cd);}}return this;},moveSeriesToBack:function(name){if(name in this.runs){var _2ce=this.runs[name],_2cf=this.getSeriesOrder(this.series[_2ce].plot);if(name!=_2cf[_2cf.length-1]){_2cf.splice(_2ce,1);_2cf.push(name);return this.setSeriesOrder(_2cf);}}return this;},resize:function(_2d0,_2d1){var box;switch(arguments.length){case 0:box=dojo.marginBox(this.node);break;case 1:box=_2d0;break;default:box={w:_2d0,h:_2d1};break;}dojo.marginBox(this.node,box);this.surface.setDimensions(box.w,box.h);this.dirty=true;this.coords=null;return this.render();},getGeometry:function(){var ret={};df.forIn(this.axes,function(axis){if(axis.initialized()){ret[axis.name]={name:axis.name,vertical:axis.vertical,scaler:axis.scaler,ticks:axis.ticks};}});return ret;},setAxisWindow:function(name,_2d2,_2d3,zoom){var axis=this.axes[name];if(axis){axis.setWindow(_2d2,_2d3);dojo.forEach(this.stack,function(plot){if(plot.hAxis==name||plot.vAxis==name){plot.zoom=zoom;}});}return this;},setWindow:function(sx,sy,dx,dy,zoom){if(!("plotArea" in this)){this.calculateGeometry();}df.forIn(this.axes,function(axis){var _2d4,_2d5,_2d6=axis.getScaler().bounds,s=_2d6.span/(_2d6.upper-_2d6.lower);if(axis.vertical){_2d4=sy;_2d5=dy/s/_2d4;}else{_2d4=sx;_2d5=dx/s/_2d4;}axis.setWindow(_2d4,_2d5);});dojo.forEach(this.stack,function(plot){plot.zoom=zoom;});return this;},zoomIn:function(name,_2d7){var axis=this.axes[name];if(axis){var _2d8,_2d9,_2da=axis.getScaler().bounds;var _2db=Math.min(_2d7[0],_2d7[1]);var _2dc=Math.max(_2d7[0],_2d7[1]);_2db=_2d7[0]<_2da.lower?_2da.lower:_2db;_2dc=_2d7[1]>_2da.upper?_2da.upper:_2dc;_2d8=(_2da.upper-_2da.lower)/(_2dc-_2db);_2d9=_2db-_2da.lower;this.setAxisWindow(name,_2d8,_2d9);this.render();}},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}var _2dd=dojo.filter(this.stack,function(plot){return plot.dirty||(plot.hAxis&&this.axes[plot.hAxis].dirty)||(plot.vAxis&&this.axes[plot.vAxis].dirty);},this);_2de(_2dd,this.plotArea);return this;},fullGeometry:function(){this._makeDirty();dojo.forEach(this.stack,_2af);if(!this.theme){this.setTheme(new dojox.charting.Theme(dojox.charting._def));}dojo.forEach(this.series,function(run){if(!(run.plot in this.plots)){var plot=new dc.plot2d.Default(this,{});plot.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(plot);}this.stack[this.plots[run.plot]].addSeries(run);},this);dojo.forEach(this.stack,function(plot){if(plot.hAxis){plot.setAxis(this.axes[plot.hAxis]);}if(plot.vAxis){plot.setAxis(this.axes[plot.vAxis]);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=dojox.gfx.normalizedLength(dim.width);dim.height=dojox.gfx.normalizedLength(dim.height);df.forIn(this.axes,_2af);_2de(this.stack,dim);var _2df=this.offsets={l:0,r:0,t:0,b:0};df.forIn(this.axes,function(axis){df.forIn(axis.getOffsets(),function(o,i){_2df[i]+=o;});});df.forIn(this.margins,function(o,i){_2df[i]+=o;});this.plotArea={width:dim.width-_2df.l-_2df.r,height:dim.height-_2df.t-_2df.b};df.forIn(this.axes,_2af);_2de(this.stack,this.plotArea);return this;},render:function(){if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();df.forEachRev(this.stack,function(plot){plot.render(this.dim,this.offsets);},this);df.forIn(this.axes,function(axis){axis.render(this.dim,this.offsets);},this);this._makeClean();if(this.surface.render){this.surface.render();}return this;},fullRender:function(){this.fullGeometry();var _2e0=this.offsets,dim=this.dim;dojo.forEach(this.series,_2b0);df.forIn(this.axes,_2b0);dojo.forEach(this.stack,_2b0);this.surface.clear();var t=this.theme,fill=t.plotarea&&t.plotarea.fill,_2e1=t.plotarea&&t.plotarea.stroke;if(fill){this.surface.createRect({x:_2e0.l-1,y:_2e0.t-1,width:dim.width-_2e0.l-_2e0.r+2,height:dim.height-_2e0.t-_2e0.b+2}).setFill(fill);}if(_2e1){this.surface.createRect({x:_2e0.l,y:_2e0.t,width:dim.width-_2e0.l-_2e0.r+1,height:dim.height-_2e0.t-_2e0.b+1}).setStroke(_2e1);}df.foldr(this.stack,function(z,plot){return plot.render(dim,_2e0),0;},0);fill=this.fill!==undefined?this.fill:(t.chart&&t.chart.fill);_2e1=this.stroke!==undefined?this.stroke:(t.chart&&t.chart.stroke);if(fill=="inherit"){var node=this.node,fill=new dojo.Color(dojo.style(node,"backgroundColor"));while(fill.a==0&&node!=document.documentElement){fill=new dojo.Color(dojo.style(node,"backgroundColor"));node=node.parentNode;}}if(fill){if(_2e0.l){this.surface.createRect({width:_2e0.l,height:dim.height+1}).setFill(fill);}if(_2e0.r){this.surface.createRect({x:dim.width-_2e0.r,width:_2e0.r+1,height:dim.height+2}).setFill(fill);}if(_2e0.t){this.surface.createRect({width:dim.width+1,height:_2e0.t}).setFill(fill);}if(_2e0.b){this.surface.createRect({y:dim.height-_2e0.b,width:dim.width+1,height:_2e0.b+2}).setFill(fill);}}if(_2e1){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_2e1);}df.forIn(this.axes,function(axis){axis.render(dim,_2e0);});this._makeClean();if(this.surface.render){this.surface.render();}return this;},delayedRender:function(){if(!this._delayedRenderHandle){this._delayedRenderHandle=setTimeout(dojo.hitch(this,function(){clearTimeout(this._delayedRenderHandle);this._delayedRenderHandle=null;this.render();}),this.delayInMs);}return this;},connectToPlot:function(name,_2e2,_2e3){return name in this.plots?this.stack[this.plots[name]].connect(_2e2,_2e3):null;},fireEvent:function(_2e4,_2e5,_2e6){if(_2e4 in this.runs){var _2e7=this.series[this.runs[_2e4]].plot;if(_2e7 in this.plots){var plot=this.stack[this.plots[_2e7]];if(plot){plot.fireEvent(_2e4,_2e5,_2e6);}}}return this;},_makeClean:function(){dojo.forEach(this.axes,_2b2);dojo.forEach(this.stack,_2b2);dojo.forEach(this.series,_2b2);this.dirty=false;},_makeDirty:function(){dojo.forEach(this.axes,_2b3);dojo.forEach(this.stack,_2b3);dojo.forEach(this.series,_2b3);this.dirty=true;},_invalidateDependentPlots:function(_2e8,_2e9){if(_2e8 in this.plots){var plot=this.stack[this.plots[_2e8]],axis,_2ea=_2e9?"vAxis":"hAxis";if(plot[_2ea]){axis=this.axes[plot[_2ea]];if(axis&&axis.dependOnData()){axis.dirty=true;dojo.forEach(this.stack,function(p){if(p[_2ea]&&p[_2ea]==plot[_2ea]){p.dirty=true;}});}}else{plot.dirty=true;}}}});function _2eb(_2ec){return {min:_2ec.hmin,max:_2ec.hmax};};function _2ed(_2ee){return {min:_2ee.vmin,max:_2ee.vmax};};function _2ef(_2f0,h){_2f0.hmin=h.min;_2f0.hmax=h.max;};function _2f1(_2f2,v){_2f2.vmin=v.min;_2f2.vmax=v.max;};function _2f3(_2f4,_2f5){if(_2f4&&_2f5){_2f4.min=Math.min(_2f4.min,_2f5.min);_2f4.max=Math.max(_2f4.max,_2f5.max);}return _2f4||_2f5;};function _2de(_2f6,_2f7){var _2f8={},axes={};dojo.forEach(_2f6,function(plot){var _2f9=_2f8[plot.name]=plot.getSeriesStats();if(plot.hAxis){axes[plot.hAxis]=_2f3(axes[plot.hAxis],_2eb(_2f9));}if(plot.vAxis){axes[plot.vAxis]=_2f3(axes[plot.vAxis],_2ed(_2f9));}});dojo.forEach(_2f6,function(plot){var _2fa=_2f8[plot.name];if(plot.hAxis){_2ef(_2fa,axes[plot.hAxis]);}if(plot.vAxis){_2f1(_2fa,axes[plot.vAxis]);}plot.initializeScalers(_2f7,_2fa);});};})();}if(!dojo._hasResource["dojo.fx.easing"]){dojo._hasResource["dojo.fx.easing"]=true;dojo.provide("dojo.fx.easing");dojo.fx.easing={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}return -1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}n-=2;return (Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return -1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}n-=2;return -1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;}n-=2;return (Math.pow(n,5)+2)/2;},sineIn:function(n){return -1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return -1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return (n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return (n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}if(n==1){return 1;}n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}--n;return (-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return -1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return -1/2*(Math.sqrt(1-Math.pow(n,2))-1);}n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return (Math.pow(n,2)*((s+1)*n-s))/2;}n-=2;return (Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;n=n-1;return -1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0){return 0;}n=n*2;if(n==2){return 1;}var p=0.3*1.5;var s=p/4;if(n<1){n-=1;return -0.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}n-=1;return 0.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return (1-dojo.fx.easing.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else{if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+0.75;}else{if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+0.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+0.984375;}}}return l;},bounceInOut:function(n){if(n<0.5){return dojo.fx.easing.bounceIn(n*2)/2;}return (dojo.fx.easing.bounceOut(n*2-1)/2)+0.5;}};}if(!dojo._hasResource["dojox.charting.action2d.Base"]){dojo._hasResource["dojox.charting.action2d.Base"]=true;dojo.provide("dojox.charting.action2d.Base");(function(){var _2fb=400,_2fc=dojo.fx.easing.backOut,df=dojox.lang.functional;dojo.declare("dojox.charting.action2d.Base",null,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(_2fd,plot,_2fe){this.chart=_2fd;this.plot=plot||"default";this.anim={};if(!_2fe){_2fe={};}this.duration=_2fe.duration?_2fe.duration:_2fb;this.easing=_2fe.easing?_2fe.easing:_2fc;},connect:function(){this.handle=this.chart.connectToPlot(this.plot,this,"process");},disconnect:function(){if(this.handle){dojo.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){this.disconnect();df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});})();}if(!dojo._hasResource["dojox.charting.action2d.Highlight"]){dojo._hasResource["dojox.charting.action2d.Highlight"]=true;dojo.provide("dojox.charting.action2d.Highlight");(function(){var _2ff=100,_300=75,_301=50,c=dojox.color,cc=function(_302){return function(){return _302;};},hl=function(_303){var a=new c.Color(_303),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=_2ff;if(x.l<_301){x.l=_300;}else{if(x.l>_300){x.l=_301;}else{x.l=x.l-_301>_300-x.l?_301:_300;}}}return c.fromHsl(x);};dojo.declare("dojox.charting.action2d.Highlight",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut},optionalParams:{highlight:"red"},constructor:function(_304,plot,_305){var a=_305&&_305.highlight;this.colorFun=a?(dojo.isFunction(a)?a:cc(a)):hl;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _306=o.run.name,_307=o.index,anim,_308,_309;if(_306 in this.anim){anim=this.anim[_306][_307];}else{this.anim[_306]={};}if(anim){anim.action.stop(true);}else{var _30a=o.shape.getFill();if(!_30a||!(_30a instanceof dojo.Color)){return;}this.anim[_306][_307]=anim={start:_30a,end:this.colorFun(_30a)};}var _30b=anim.start,end=anim.end;if(o.type=="onmouseout"){var t=_30b;_30b=end;end=t;}anim.action=dojox.gfx.fx.animateFill({shape:o.shape,duration:this.duration,easing:this.easing,color:{start:_30b,end:end}});if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){if(this.anim[_306]){delete this.anim[_306][_307];}});}anim.action.play();}});})();}if(!dojo._hasResource["dojox.charting.action2d.Magnify"]){dojo._hasResource["dojox.charting.action2d.Magnify"]=true;dojo.provide("dojox.charting.action2d.Magnify");(function(){var _30c=2,m=dojox.gfx.matrix,gf=dojox.gfx.fx;dojo.declare("dojox.charting.action2d.Magnify",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut,scale:_30c},optionalParams:{},constructor:function(_30d,plot,_30e){this.scale=_30e&&typeof _30e.scale=="number"?_30e.scale:_30c;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)||!("cx" in o)||!("cy" in o)){return;}var _30f=o.run.name,_310=o.index,_311=[],anim,init,_312;if(_30f in this.anim){anim=this.anim[_30f][_310];}else{this.anim[_30f]={};}if(anim){anim.action.stop(true);}else{this.anim[_30f][_310]=anim={};}if(o.type=="onmouseover"){init=m.identity;_312=this.scale;}else{init=m.scaleAt(this.scale,o.cx,o.cy);_312=1/this.scale;}var _313={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"scaleAt",start:[1,o.cx,o.cy],end:[_312,o.cx,o.cy]},init]};if(o.shape){_311.push(gf.animateTransform(_313));}if(o.oultine){_313.shape=o.outline;_311.push(gf.animateTransform(_313));}if(o.shadow){_313.shape=o.shadow;_311.push(gf.animateTransform(_313));}if(!_311.length){delete this.anim[_30f][_310];return;}anim.action=dojo.fx.combine(_311);if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){if(this.anim[_30f]){delete this.anim[_30f][_310];}});}anim.action.play();}});})();}if(!dojo._hasResource["dojox.lang.functional.scan"]){dojo._hasResource["dojox.lang.functional.scan"]=true;dojo.provide("dojox.lang.functional.scan");(function(){var d=dojo,df=dojox.lang.functional,_314={};d.mixin(df,{scanl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,i;if(d.isArray(a)){t=new Array((n=a.length)+1);t[0]=z;for(i=0;i<n;z=f.call(o,z,a[i],i,a),t[++i]=z){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[z];for(i=0;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}else{t=[z];for(i in a){if(!(i in _314)){t.push(z=f.call(o,z,a[i],i,a));}}}}return t;},scanl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,z,_315=true;if(d.isArray(a)){t=new Array(n=a.length);t[0]=z=a[0];for(var i=1;i<n;t[i]=z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){t=[z=a.next()];for(var i=1;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}}else{for(var i in a){if(!(i in _314)){if(_315){t=[z=a[i]];_315=false;}else{t.push(z=f.call(o,z,a[i],i,a));}}}}}return t;},scanr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n+1),i=n;t[n]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;},scanr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n),z=a[n-1],i=n-1;t[i]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;}});})();}if(!dojo._hasResource["dojox.charting.action2d.MoveSlice"]){dojo._hasResource["dojox.charting.action2d.MoveSlice"]=true;dojo.provide("dojox.charting.action2d.MoveSlice");(function(){var _316=1.05,_317=7,m=dojox.gfx.matrix,gf=dojox.gfx.fx,df=dojox.lang.functional;dojo.declare("dojox.charting.action2d.MoveSlice",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut,scale:_316,shift:_317},optionalParams:{},constructor:function(_318,plot,_319){if(!_319){_319={};}this.scale=typeof _319.scale=="number"?_319.scale:_316;this.shift=typeof _319.shift=="number"?_319.shift:_317;this.connect();},process:function(o){if(!o.shape||o.element!="slice"||!(o.type in this.overOutEvents)){return;}if(!this.angles){var _31a=m._degToRad(o.plot.opt.startAngle);if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",_31a),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",_31a),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _31b=o.index,anim,_31c,_31d,_31e,_31f,_320=(this.angles[_31b]+this.angles[_31b+1])/2,_321=m.rotateAt(-_320,o.cx,o.cy),_322=m.rotateAt(_320,o.cx,o.cy);anim=this.anim[_31b];if(anim){anim.action.stop(true);}else{this.anim[_31b]=anim={};}if(o.type=="onmouseover"){_31e=0;_31f=this.shift;_31c=1;_31d=this.scale;}else{_31e=this.shift;_31f=0;_31c=this.scale;_31d=1;}anim.action=dojox.gfx.fx.animateTransform({shape:o.shape,duration:this.duration,easing:this.easing,transform:[_322,{name:"translate",start:[_31e,0],end:[_31f,0]},{name:"scaleAt",start:[_31c,o.cx,o.cy],end:[_31d,o.cx,o.cy]},_321]});if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){delete this.anim[_31b];});}anim.action.play();},reset:function(){delete this.angles;}});})();}if(!dojo._hasResource["dojox.charting.action2d.Shake"]){dojo._hasResource["dojox.charting.action2d.Shake"]=true;dojo.provide("dojox.charting.action2d.Shake");(function(){var _323=3,m=dojox.gfx.matrix,gf=dojox.gfx.fx;dojo.declare("dojox.charting.action2d.Shake",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut,shiftX:_323,shiftY:_323},optionalParams:{},constructor:function(_324,plot,_325){if(!_325){_325={};}this.shiftX=typeof _325.shiftX=="number"?_325.shiftX:_323;this.shiftY=typeof _325.shiftY=="number"?_325.shiftY:_323;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _326=o.run.name,_327=o.index,_328=[],anim,_329=o.type=="onmouseover"?this.shiftX:-this.shiftX,_32a=o.type=="onmouseover"?this.shiftY:-this.shiftY;if(_326 in this.anim){anim=this.anim[_326][_327];}else{this.anim[_326]={};}if(anim){anim.action.stop(true);}else{this.anim[_326][_327]=anim={};}var _32b={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"translate",start:[this.shiftX,this.shiftY],end:[0,0]},m.identity]};if(o.shape){_328.push(gf.animateTransform(_32b));}if(o.oultine){_32b.shape=o.outline;_328.push(gf.animateTransform(_32b));}if(o.shadow){_32b.shape=o.shadow;_328.push(gf.animateTransform(_32b));}if(!_328.length){delete this.anim[_326][_327];return;}anim.action=dojo.fx.combine(_328);if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){if(this.anim[_326]){delete this.anim[_326][_327];}});}anim.action.play();}});})();}if(!dojo._hasResource["dojox.charting.action2d.Tooltip"]){dojo._hasResource["dojox.charting.action2d.Tooltip"]=true;dojo.provide("dojox.charting.action2d.Tooltip");(function(){var _32c=function(o){var t=o.run&&o.run.data&&o.run.data[o.index];if(t&&typeof t!="number"&&(t.tooltip||t.text)){return t.tooltip||t.text;}if(o.element=="candlestick"){return "<table cellpadding=\"1\" cellspacing=\"0\" border=\"0\" style=\"font-size:0.9em;\">"+"<tr><td>Open:</td><td align=\"right\"><strong>"+o.data.open+"</strong></td></tr>"+"<tr><td>High:</td><td align=\"right\"><strong>"+o.data.high+"</strong></td></tr>"+"<tr><td>Low:</td><td align=\"right\"><strong>"+o.data.low+"</strong></td></tr>"+"<tr><td>Close:</td><td align=\"right\"><strong>"+o.data.close+"</strong></td></tr>"+(o.data.mid!==undefined?"<tr><td>Mid:</td><td align=\"right\"><strong>"+o.data.mid+"</strong></td></tr>":"")+"</table>";}return o.element=="bar"?o.x:o.y;};var df=dojox.lang.functional,m=dojox.gfx.matrix,pi4=Math.PI/4,pi2=Math.PI/2;dojo.declare("dojox.charting.action2d.Tooltip",dojox.charting.action2d.Base,{defaultParams:{text:_32c},optionalParams:{},constructor:function(_32d,plot,_32e){this.text=_32e&&_32e.text?_32e.text:_32c;this.connect();},process:function(o){if(o.type==="onplotreset"||o.type==="onmouseout"){_32f(this.aroundRect);this.aroundRect=null;return;}if(!o.shape||o.type!=="onmouseover"){return;}var _330={type:"rect"},_331=["after","before"];switch(o.element){case "marker":_330.x=o.cx;_330.y=o.cy;_330.width=_330.height=1;break;case "circle":_330.x=o.cx-o.cr;_330.y=o.cy-o.cr;_330.width=_330.height=2*o.cr;break;case "column":_331=["above","below"];case "bar":_330=dojo.clone(o.shape.getShape());break;case "candlestick":_330.x=o.x;_330.y=o.y;_330.width=o.width;_330.height=o.height;break;default:if(!this.angles){if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _332=m._degToRad(o.plot.opt.startAngle),_333=(this.angles[o.index]+this.angles[o.index+1])/2+_332;_330.x=o.cx+o.cr*Math.cos(_333);_330.y=o.cy+o.cr*Math.sin(_333);_330.width=_330.height=1;if(_333<pi4){}else{if(_333<pi2+pi4){_331=["below","above"];}else{if(_333<Math.PI+pi4){_331=["before","after"];}else{if(_333<2*Math.PI-pi4){_331=["above","below"];}}}}break;}var lt=dojo.coords(this.chart.node,true);_330.x+=lt.x;_330.y+=lt.y;_330.x=Math.round(_330.x);_330.y=Math.round(_330.y);_330.width=Math.ceil(_330.width);_330.height=Math.ceil(_330.height);this.aroundRect=_330;_334(this.text(o),this.aroundRect,_331,"center");}});var _335=dojo.declare(dijit._MasterTooltip,{show:function(_336,_337,_338,_339){if(this.aroundNode&&this.aroundNode===_337){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_336;this.domNode.style.top=(this.domNode.offsetTop+1)+"px";if(!this.connectorNode){this.connectorNode=dojo.query(".dijitTooltipConnector",this.domNode)[0];}var _33a=dojo.coords(this.connectorNode);this.arrowWidth=_33a.w,this.arrowHeight=_33a.h;this.place=(_339&&_339=="center")?this.placeChartingTooltip:dijit.placeOnScreenAroundElement,this.place(this.domNode,_337,dijit.getPopupAroundAlignment((_338&&_338.length)?_338:dijit.Tooltip.defaultPosition,this.isLeftToRight()),dojo.hitch(this,"orient"));dojo.style(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_337;},placeChartingTooltip:function(node,_33b,_33c,_33d){return this._placeOnScreenAroundRect(node,_33b.x,_33b.y,_33b.width,_33b.height,_33c,_33d);},_placeOnScreenAroundRect:function(node,x,y,_33e,_33f,_340,_341){var _342=[];for(var _343 in _340){_342.push({aroundCorner:_343,corner:_340[_343],pos:{x:x+(_343.charAt(1)=="L"?0:_33e),y:y+(_343.charAt(0)=="T"?0:_33f),w:_33e,h:_33f}});}return this._place(node,_342,_341);},_place:function(node,_344,_345){var view=dijit.getViewport();if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){dojo.body().appendChild(node);}var best=null;var _346=null,_347=null;dojo.some(_344,function(_348){var _349=_348.corner;var _34a=_348.aroundCorner;var pos=_348.pos;if(_345){_345(node,_348.aroundCorner,_349);}var _34b=node.style;var _34c=_34b.display;var _34d=_34b.visibility;_34b.visibility="hidden";_34b.display="";var mb=dojo.marginBox(node);_34b.display=_34c;_34b.visibility=_34d;var _34e,_34f,endX,endY,_350,_351,_352;_346=null,_347=null;if(_34a.charAt(0)==_349.charAt(0)){_34e=(_349.charAt(1)=="L"?pos.x:Math.max(view.l,pos.x-mb.w)),_34f=(_349.charAt(0)=="T"?(pos.y+pos.h/2-mb.h/2):(pos.y-pos.h/2-mb.h/2)),endX=(_349.charAt(1)=="L"?Math.min(view.l+view.w,_34e+mb.w):pos.x),endY=_34f+mb.h,_350=endX-_34e,_351=endY-_34f,_352=(mb.w-_350)+(mb.h-_351);_347=(mb.h-this.arrowHeight)/2;}else{_34e=(_349.charAt(1)=="L"?(pos.x+pos.w/2-mb.w/2):(pos.x-pos.w/2-mb.w/2)),_34f=(_349.charAt(0)=="T"?pos.y:Math.max(view.t,pos.y-mb.h)),endX=_34e+mb.w,endY=(_349.charAt(0)=="T"?Math.min(view.t+view.h,_34f+mb.h):pos.y),_350=endX-_34e,_351=endY-_34f,_352=(mb.w-_350)+(mb.h-_351);_346=(mb.w-this.arrowWidth)/2;}if(best==null||_352<best.overflow){best={corner:_349,aroundCorner:_348.aroundCorner,x:_34e,y:_34f,w:_350,h:_351,overflow:_352};}return !_352;},this);node.style.left=best.x+"px";node.style.top=best.y+"px";this.connectorNode.style.top="";this.connectorNode.style.left="";if(_347){this.connectorNode.style.top=_347+"px";}if(_346){this.connectorNode.style.left=_346+"px";}if(best.overflow&&_345){_345(node,best.aroundCorner,best.corner);}return best;}});var _353=null;function _334(_354,_355,_356,_357){if(!_353){_353=new _335();}return _353.show(_354,_355,_356,_357);};function _32f(_358){if(!_353){_353=new _335();}return _353.hide(_358);};})();}if(!dojo._hasResource["dojox.charting.widget.Chart2D"]){dojo._hasResource["dojox.charting.widget.Chart2D"]=true;dojo.provide("dojox.charting.widget.Chart2D");(function(){var _359,_35a,_35b,_35c,_35d,_35e=function(o){return o;},df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting,d=dojo;dojo.declare("dojox.charting.widget.Chart2D",dijit._Widget,{theme:null,margins:null,stroke:null,fill:null,buildRendering:function(){var n=this.domNode=this.srcNodeRef;var axes=d.query("> .axis",n).map(_35a).filter(_35e),_35f=d.query("> .plot",n).map(_35b).filter(_35e),_360=d.query("> .action",n).map(_35c).filter(_35e),_361=d.query("> .series",n).map(_35d).filter(_35e);n.innerHTML="";var c=this.chart=new dc.Chart2D(n,{margins:this.margins,stroke:this.stroke,fill:this.fill});if(this.theme){c.setTheme(this.theme);}axes.forEach(function(axis){c.addAxis(axis.name,axis.kwArgs);});_35f.forEach(function(plot){c.addPlot(plot.name,plot.kwArgs);});this.actions=_360.map(function(_362){return new _362.action(c,_362.plot,_362.kwArgs);});var _363=df.foldl(_361,function(_364,_365){if(_365.type=="data"){c.addSeries(_365.name,_365.data,_365.kwArgs);_364=true;}else{c.addSeries(_365.name,[0],_365.kwArgs);var kw={};du.updateWithPattern(kw,_365.kwArgs,{"query":"","queryOptions":null,"start":0,"count":1},true);if(_365.kwArgs.sort){kw.sort=dojo.clone(_365.kwArgs.sort);}d.mixin(kw,{onComplete:function(data){var _366;if("valueFn" in _365.kwArgs){var fn=_365.kwArgs.valueFn;_366=d.map(data,function(x){return fn(_365.data.getValue(x,_365.field,0));});}else{_366=d.map(data,function(x){return _365.data.getValue(x,_365.field,0);});}c.addSeries(_365.name,_366,_365.kwArgs).render();}});_365.data.fetch(kw);}return _364;},false);if(_363){c.render();}},destroy:function(){this.chart.destroy();this.inherited(arguments);},resize:function(box){if(box.w>0&&box.h>0){dojo.marginBox(this.domNode,box);this.chart.resize();}}});_359=function(node,type,kw){var dp=eval("("+type+".prototype.defaultParams)");var x,attr;for(x in dp){if(x in kw){continue;}attr=node.getAttribute(x);kw[x]=du.coerceType(dp[x],attr==null||typeof attr=="undefined"?dp[x]:attr);}var op=eval("("+type+".prototype.optionalParams)");for(x in op){if(x in kw){continue;}attr=node.getAttribute(x);if(attr!=null){kw[x]=du.coerceType(op[x],attr);}}};_35a=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.axis2d[type]){type=dojox._scopeName+".charting.axis2d."+type;}var axis=eval("("+type+")");if(axis){kw.type=axis;}}else{type=dojox._scopeName+".charting.axis2d.Default";}_359(node,type,kw);if(kw.font||kw.fontColor){if(!kw.tick){kw.tick={};}if(kw.font){kw.tick.font=kw.font;}if(kw.fontColor){kw.tick.fontColor=kw.fontColor;}}return o;};_35b=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.plot2d[type]){type=dojox._scopeName+".charting.plot2d."+type;}var plot=eval("("+type+")");if(plot){kw.type=plot;}}else{type=dojox._scopeName+".charting.plot2d.Default";}_359(node,type,kw);return o;};_35c=function(node){var plot=node.getAttribute("plot"),type=node.getAttribute("type");if(!plot){plot="default";}var o={plot:plot,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.action2d[type]){type=dojox._scopeName+".charting.action2d."+type;}var _367=eval("("+type+")");if(!_367){return null;}o.action=_367;}else{return null;}_359(node,type,kw);return o;};_35d=function(node){var ga=d.partial(d.attr,node);var name=ga("name");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs,t;t=ga("plot");if(t!=null){kw.plot=t;}t=ga("marker");if(t!=null){kw.marker=t;}t=ga("stroke");if(t!=null){kw.stroke=eval("("+t+")");}t=ga("outline");if(t!=null){kw.outline=eval("("+t+")");}t=ga("shadow");if(t!=null){kw.shadow=eval("("+t+")");}t=ga("fill");if(t!=null){kw.fill=eval("("+t+")");}t=ga("font");if(t!=null){kw.font=t;}t=ga("fontColor");if(t!=null){kw.fontColor=eval("("+t+")");}t=ga("legend");if(t!=null){kw.legend=t;}t=ga("data");if(t!=null){o.type="data";o.data=t?dojo.map(String(t).split(","),Number):[];return o;}t=ga("array");if(t!=null){o.type="data";o.data=eval("("+t+")");return o;}t=ga("store");if(t!=null){o.type="store";o.data=eval("("+t+")");t=ga("field");o.field=t!=null?t:"value";t=ga("query");if(!!t){kw.query=t;}t=ga("queryOptions");if(!!t){kw.queryOptions=eval("("+t+")");}t=ga("start");if(!!t){kw.start=Number(t);}t=ga("count");if(!!t){kw.count=Number(t);}t=ga("sort");if(!!t){kw.sort=eval("("+t+")");}t=ga("valueFn");if(!!t){kw.valueFn=df.lambda(t);}return o;}return null;};})();}if(!dojo._hasResource["dojox.charting.themes.ET.greys"]){dojo._hasResource["dojox.charting.themes.ET.greys"]=true;dojo.provide("dojox.charting.themes.ET.greys");dojo.deprecated("dojox.charting.themes.ET.greys","1.3");(function(){var dxc=dojox.charting;dxc.themes.ET.greys=new dxc.Theme({antiAlias:false,chart:{stroke:null,fill:"inherit"},plotarea:{stroke:null,fill:"transparent"},axis:{stroke:{width:0},line:{width:0},majorTick:{color:"#666666",width:1,length:5},minorTick:{color:"black",width:0.5,length:2},font:"normal normal normal 8pt Tahoma",fontColor:"#999999"},series:{outline:{width:0,color:"black"},stroke:{width:1,color:"black"},fill:dojo.colorFromHex("#3b444b"),font:"normal normal normal 7pt Tahoma",fontColor:"#717171"},marker:{stroke:{width:1},fill:"#333",font:"normal normal normal 7pt Tahoma",fontColor:"#000"},colors:[dojo.colorFromHex("#8a8c8f"),dojo.colorFromHex("#4b4b4b"),dojo.colorFromHex("#3b444b"),dojo.colorFromHex("#2e2d30"),dojo.colorFromHex("#000000")]});})();}if(!dojo._hasResource["dojox.charting.widget.Sparkline"]){dojo._hasResource["dojox.charting.widget.Sparkline"]=true;dojo.provide("dojox.charting.widget.Sparkline");(function(){var d=dojo;dojo.declare("dojox.charting.widget.Sparkline",dojox.charting.widget.Chart2D,{theme:dojox.charting.themes.ET.greys,margins:{l:0,r:0,t:0,b:0},type:"Lines",valueFn:"Number(x)",store:"",field:"",query:"",queryOptions:"",start:"0",count:"Infinity",sort:"",data:"",name:"default",buildRendering:function(){var n=this.srcNodeRef;if(!n.childNodes.length||!d.query("> .axis, > .plot, > .action, > .series",n).length){var plot=document.createElement("div");d.attr(plot,{"class":"plot","name":"default","type":this.type});n.appendChild(plot);var _368=document.createElement("div");d.attr(_368,{"class":"series",plot:"default",name:this.name,start:this.start,count:this.count,valueFn:this.valueFn});d.forEach(["store","field","query","queryOptions","sort","data"],function(i){if(this[i].length){d.attr(_368,i,this[i]);}},this);n.appendChild(_368);}this.inherited(arguments);}});})();}if(!dojo._hasResource["dojox.charting.widget.Legend"]){dojo._hasResource["dojox.charting.widget.Legend"]=true;dojo.provide("dojox.charting.widget.Legend");dojo.declare("dojox.charting.widget.Legend",[dijit._Widget,dijit._Templated],{chartRef:"",horizontal:true,swatchSize:18,templateString:"<table dojoAttachPoint='legendNode' class='dojoxLegendNode'><tbody dojoAttachPoint='legendBody'></tbody></table>",legendNode:null,legendBody:null,postCreate:function(){if(!this.chart){if(!this.chartRef){return;}this.chart=dijit.byId(this.chartRef);if(!this.chart){var node=dojo.byId(this.chartRef);if(node){this.chart=dijit.byNode(node);}else{return;}}this.series=this.chart.chart.series;}else{this.series=this.chart.series;}this.refresh();},refresh:function(){var df=dojox.lang.functional;if(this._surfaces){dojo.forEach(this._surfaces,function(_369){_369.destroy();});}this._surfaces=[];while(this.legendBody.lastChild){dojo.destroy(this.legendBody.lastChild);}if(this.horizontal){dojo.addClass(this.legendNode,"dojoxLegendHorizontal");this._tr=dojo.doc.createElement("tr");this.legendBody.appendChild(this._tr);this._inrow=0;}var s=this.series;if(s.length==0){return;}if(s[0].chart.stack[0].declaredClass=="dojox.charting.plot2d.Pie"){var t=s[0].chart.stack[0];if(typeof t.run.data[0]=="number"){var _36a=df.map(t.run.data,"Math.max(x, 0)");if(df.every(_36a,"<= 0")){return;}var _36b=df.map(_36a,"/this",df.foldl(_36a,"+",0));dojo.forEach(_36b,function(x,i){this._addLabel(t.dyn[i],t._getLabel(x*100)+"%");},this);}else{dojo.forEach(t.run.data,function(x,i){this._addLabel(t.dyn[i],x.legend||x.text||x.y);},this);}}else{dojo.forEach(s,function(x){this._addLabel(x.dyn,x.legend||x.name);},this);}},_addLabel:function(dyn,_36c){var icon=dojo.doc.createElement("td"),text=dojo.doc.createElement("td"),div=dojo.doc.createElement("div");dojo.addClass(icon,"dojoxLegendIcon");dojo.addClass(text,"dojoxLegendText");div.style.width=this.swatchSize+"px";div.style.height=this.swatchSize+"px";icon.appendChild(div);if(this._tr){this._tr.appendChild(icon);this._tr.appendChild(text);if(++this._inrow===this.horizontal){this._tr=dojo.doc.createElement("tr");this.legendBody.appendChild(this._tr);this._inrow=0;}}else{var tr=dojo.doc.createElement("tr");this.legendBody.appendChild(tr);tr.appendChild(icon);tr.appendChild(text);}this._makeIcon(div,dyn);text.innerHTML=String(_36c);},_makeIcon:function(div,dyn){var mb={h:this.swatchSize,w:this.swatchSize};var _36d=dojox.gfx.createSurface(div,mb.w,mb.h);this._surfaces.push(_36d);if(dyn.fill){_36d.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setFill(dyn.fill).setStroke(dyn.stroke);}else{if(dyn.stroke||dyn.marker){var line={x1:0,y1:mb.h/2,x2:mb.w,y2:mb.h/2};if(dyn.stroke){_36d.createLine(line).setStroke(dyn.stroke);}if(dyn.marker){var c={x:mb.w/2,y:mb.h/2};if(dyn.stroke){_36d.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.stroke.color).setStroke(dyn.stroke);}else{_36d.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.color).setStroke(dyn.color);}}}else{_36d.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setStroke("black");_36d.createLine({x1:2,y1:2,x2:mb.w-2,y2:mb.h-2}).setStroke("black");_36d.createLine({x1:2,y1:mb.h-2,x2:mb.w-2,y2:2}).setStroke("black");}}}});}
