/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import nu.xom.Builder;
import nu.xom.Element;
import nu.xom.ParsingException;
import nu.xom.converters.DOMConverter;
import org.springframework.ws.server.endpoint.PayloadEndpoint;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class AbstractXomPayloadEndpoint
extends TransformerObjectSupport
implements PayloadEndpoint {
    private DocumentBuilderFactory documentBuilderFactory;

    public final Source invoke(Source request) throws Exception {
        Element responseElement;
        Element requestElement = null;
        if (request != null) {
            if (request instanceof DOMSource) {
                requestElement = this.handleDomSource((DOMSource)request);
            } else if (request instanceof SAXSource) {
                requestElement = this.handleSaxSource((SAXSource)request);
            } else if (request instanceof StreamSource) {
                requestElement = this.handleStreamSource((StreamSource)request);
            } else {
                throw new IllegalArgumentException("Source [" + request.getClass().getName() + "] is neither SAXSource, DOMSource, nor StreamSource");
            }
        }
        if ((responseElement = this.invokeInternal(requestElement)) != null) {
            if (this.documentBuilderFactory == null) {
                this.createDocumentBuilderFactory();
            }
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            nu.xom.Document responseDocument = new nu.xom.Document(responseElement);
            Document w3cDocument = DOMConverter.convert((nu.xom.Document)responseDocument, (DOMImplementation)documentBuilder.getDOMImplementation());
            return new DOMSource(w3cDocument);
        }
        Source result = null;
        return result;
    }

    private Element handleDomSource(DOMSource request) {
        Node w3cNode = request.getNode();
        org.w3c.dom.Element w3cElement = null;
        if (w3cNode.getNodeType() == 1) {
            w3cElement = (org.w3c.dom.Element)w3cNode;
        } else if (w3cNode.getNodeType() == 9) {
            Document w3cDocument = (Document)w3cNode;
            w3cElement = w3cDocument.getDocumentElement();
        }
        return DOMConverter.convert((org.w3c.dom.Element)w3cElement);
    }

    private Element handleSaxSource(SAXSource request) throws ParsingException, IOException {
        nu.xom.Document document;
        Builder builder = new Builder(request.getXMLReader());
        InputSource inputSource = request.getInputSource();
        if (inputSource.getByteStream() != null) {
            document = builder.build(inputSource.getByteStream());
        } else if (inputSource.getCharacterStream() != null) {
            document = builder.build(inputSource.getCharacterStream());
        } else {
            throw new IllegalArgumentException("InputSource in SAXSource contains neither byte stream nor character stream");
        }
        return document.getRootElement();
    }

    private Element handleStreamSource(StreamSource request) throws ParsingException, IOException {
        nu.xom.Document document;
        Builder builder = new Builder();
        if (request.getInputStream() != null) {
            document = builder.build(request.getInputStream());
        } else if (request.getReader() != null) {
            document = builder.build(request.getReader());
        } else {
            throw new IllegalArgumentException("StreamSource contains neither byte stream nor character stream");
        }
        return document.getRootElement();
    }

    private void createDocumentBuilderFactory() {
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    protected abstract Element invokeInternal(Element var1) throws Exception;
}

