/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.core.JdkVersion;
import org.springframework.util.Assert;

public final class MethodEndpoint {
    private Object bean;
    private Method method;

    public MethodEndpoint(Object bean, Method method) {
        Assert.notNull((Object)bean, (String)"bean must not be null");
        Assert.notNull((Object)method, (String)"method must not be null");
        this.bean = bean;
        this.method = method;
    }

    public MethodEndpoint(Object bean, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        Assert.notNull((Object)bean, (String)"bean must not be null");
        Assert.notNull((Object)methodName, (String)"method must not be null");
        this.bean = bean;
        this.method = bean.getClass().getMethod(methodName, parameterTypes);
    }

    public Object getBean() {
        return this.bean;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object invoke(Object[] args) throws Exception {
        try {
            return this.method.invoke(this.bean, args);
        }
        catch (InvocationTargetException ex) {
            this.handleInvocationTargetException(ex);
            throw new IllegalStateException("Unexpected exception thrown by method - " + ex.getTargetException().getClass().getName() + ": " + ex.getTargetException().getMessage());
        }
    }

    private void handleInvocationTargetException(InvocationTargetException ex) throws Exception {
        if (ex.getTargetException() instanceof RuntimeException) {
            throw (RuntimeException)ex.getTargetException();
        }
        if (ex.getTargetException() instanceof Error) {
            throw (Error)ex.getTargetException();
        }
        if (ex.getTargetException() instanceof Exception) {
            throw (Exception)ex.getTargetException();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof MethodEndpoint) {
            MethodEndpoint other = (MethodEndpoint)o;
            return this.bean.equals(other.bean) && this.method.equals(other.method);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.bean.hashCode() + this.method.hashCode();
    }

    public String toString() {
        if (JdkVersion.getMajorJavaVersion() <= 1) {
            return this.method.toString();
        }
        return GenericToStringProvider.toString(this.method);
    }

    private static class GenericToStringProvider {
        private GenericToStringProvider() {
        }

        public static String toString(Method method) {
            return method.toGenericString();
        }
    }
}

