/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.axiom.AxiomSoap11Fault;
import org.springframework.ws.soap.axiom.AxiomSoapElement;
import org.springframework.ws.soap.axiom.CachingPayload;
import org.springframework.ws.soap.axiom.NonCachingPayload;
import org.springframework.ws.soap.axiom.Payload;

abstract class AxiomSoapBody
extends AxiomSoapElement
implements SoapBody {
    private final Payload payload;

    protected AxiomSoapBody(SOAPBody axiomBody, SOAPFactory axiomFactory, boolean payloadCaching) {
        super((OMElement)axiomBody, axiomFactory);
        this.payload = payloadCaching ? new CachingPayload(axiomBody, axiomFactory) : new NonCachingPayload(axiomBody, axiomFactory);
    }

    public Source getPayloadSource() {
        return this.payload.getSource();
    }

    public Result getPayloadResult() {
        return this.payload.getResult();
    }

    public boolean hasFault() {
        return this.getAxiomBody().hasFault();
    }

    public SoapFault getFault() {
        SOAPFault axiomFault = this.getAxiomBody().getFault();
        return axiomFault != null ? new AxiomSoap11Fault(axiomFault, this.getAxiomFactory()) : null;
    }

    protected final SOAPBody getAxiomBody() {
        return (SOAPBody)this.getAxiomElement();
    }
}

