/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint;

import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.AbstractEndpointExceptionResolver;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.server.endpoint.SoapFaultDefinition;
import org.springframework.ws.soap.soap11.Soap11Body;

public abstract class AbstractSoapFaultDefinitionExceptionResolver
extends AbstractEndpointExceptionResolver {
    private SoapFaultDefinition defaultFault;

    public void setDefaultFault(SoapFaultDefinition defaultFault) {
        this.defaultFault = defaultFault;
    }

    protected abstract SoapFaultDefinition getFaultDefinition(Object var1, Exception var2);

    protected final boolean resolveExceptionInternal(MessageContext messageContext, Object endpoint, Exception ex) {
        Assert.isInstanceOf((Class)SoapMessage.class, (Object)messageContext.getResponse(), (String)"AbstractSoapFaultDefinitionExceptionResolver requires a SoapMessage");
        SoapFaultDefinition definition = this.getFaultDefinition(endpoint, ex);
        if (definition == null) {
            definition = this.defaultFault;
        }
        if (definition == null) {
            return false;
        }
        String faultStringOrReason = definition.getFaultStringOrReason();
        if (!StringUtils.hasLength((String)faultStringOrReason)) {
            faultStringOrReason = StringUtils.hasLength((String)ex.getMessage()) ? ex.getMessage() : ex.toString();
        }
        SoapBody soapBody = ((SoapMessage)messageContext.getResponse()).getSoapBody();
        SoapFault fault = null;
        if (SoapFaultDefinition.SERVER.equals(definition.getFaultCode()) || SoapFaultDefinition.RECEIVER.equals(definition.getFaultCode())) {
            fault = soapBody.addServerOrReceiverFault(faultStringOrReason, definition.getLocale());
        } else if (SoapFaultDefinition.CLIENT.equals(definition.getFaultCode()) || SoapFaultDefinition.SENDER.equals(definition.getFaultCode())) {
            fault = soapBody.addClientOrSenderFault(faultStringOrReason, definition.getLocale());
        } else if (soapBody instanceof Soap11Body) {
            Soap11Body soap11Body = (Soap11Body)soapBody;
            fault = soap11Body.addFault(definition.getFaultCode(), faultStringOrReason, definition.getLocale());
        } else {
            this.logger.warn((Object)"SOAP 1.2 does not allow custom FaultCodes, only SENDER or RECEIVER.");
        }
        if (fault != null) {
            this.customizeFault(endpoint, ex, fault);
        }
        return true;
    }

    protected void customizeFault(Object endpoint, Exception ex, SoapFault fault) {
    }
}

