/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractReceiverConnection;
import org.springframework.ws.transport.EndpointAwareWebServiceConnection;
import org.springframework.ws.transport.FaultAwareWebServiceConnection;
import org.springframework.ws.transport.support.EnumerationIterator;

public class HttpServletConnection
extends AbstractReceiverConnection
implements EndpointAwareWebServiceConnection,
FaultAwareWebServiceConnection {
    private final HttpServletRequest httpServletRequest;
    private final HttpServletResponse httpServletResponse;
    private boolean statusCodeSet = false;

    protected HttpServletConnection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.httpServletRequest = httpServletRequest;
        this.httpServletResponse = httpServletResponse;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpServletResponse;
    }

    public void endpointNotFound() {
        this.getHttpServletResponse().setStatus(404);
        this.statusCodeSet = true;
    }

    public boolean hasError() throws IOException {
        return false;
    }

    public String getErrorMessage() throws IOException {
        return null;
    }

    public URI getUri() throws URISyntaxException {
        return new URI(this.httpServletRequest.getScheme(), null, this.httpServletRequest.getServerName(), this.httpServletRequest.getServerPort(), this.httpServletRequest.getRequestURI(), this.httpServletRequest.getQueryString(), null);
    }

    protected Iterator getRequestHeaderNames() throws IOException {
        return new EnumerationIterator(this.getHttpServletRequest().getHeaderNames());
    }

    protected Iterator getRequestHeaders(String name) throws IOException {
        return new EnumerationIterator(this.getHttpServletRequest().getHeaders(name));
    }

    protected InputStream getRequestInputStream() throws IOException {
        return this.getHttpServletRequest().getInputStream();
    }

    protected void addResponseHeader(String name, String value) throws IOException {
        this.getHttpServletResponse().addHeader(name, value);
    }

    protected OutputStream getResponseOutputStream() throws IOException {
        return this.getHttpServletResponse().getOutputStream();
    }

    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        this.statusCodeSet = true;
    }

    public void onClose() throws IOException {
        if (!this.statusCodeSet) {
            this.getHttpServletResponse().setStatus(202);
        }
    }

    public boolean hasFault() throws IOException {
        return false;
    }

    public void setFault(boolean fault) throws IOException {
        if (fault) {
            this.getHttpServletResponse().setStatus(500);
        } else {
            this.getHttpServletResponse().setStatus(200);
        }
        this.statusCodeSet = true;
    }
}

